/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.amh;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public class BankBusinessConfig
extends BankPropertyConfig {
    public static final PropertyConfigItem CITIC_AMH_PAY_STATE_TIMEOUT = PropertyConfigItem.builder().key("CITIC_AMH_PAY_STATE_TIMEOUT").mlName(new MultiLangEnumBridge("\u4ed8\u6b3e\u72b6\u6001\u8d85\u65f6\u65f6\u95f4\u3002", "BankBusinessConfig_81", "ebg-aqap-banks-citic-amh")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u4ed8\u6b3e\u63d0\u4ea4\u8d85\u8fc7\u914d\u7f6e\u7684\u65f6\u95f4\u672a\u5f97\u5230\u94f6\u884c\u54cd\u5e94\uff0c\u5c06\u4ed8\u6b3e\u72b6\u6001\u7f6e\u4e3a\u4ea4\u6613\u672a\u786e\u8ba4\u3002", "BankBusinessConfig_82", "ebg-aqap-banks-citic-amh"), new MultiLangEnumBridge("\u914d\u7f6e\u5927\u4e8e0\u7684\u6570\u5b57\uff0c\u5355\u4f4d\uff1a\u5c0f\u65f6\u3002\u4e0d\u8bbe\u7f6e\u5219\u4e0d\u4fee\u6539\u4ea4\u6613\u72b6\u6001\u3002", "BankBusinessConfig_83", "ebg-aqap-banks-citic-amh")})).set2Integer().set2MinValueNum(Integer.valueOf(0)).defaultValues((List)Lists.newArrayList((Object[])new String[]{"0"})).build();
    private static final PropertyConfigItem citic_amh_balance_choose = PropertyConfigItem.builder().key("citic_amh_balance_choose").mlName(new MultiLangEnumBridge("MT940\u63a8\u9001\u5468\u671f", "BankBusinessConfig_90", "ebg-aqap-banks-citic-amh")).mlDesc((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("MT940\u63a8\u9001\u5468\u671f\uff1a", "BankBusinessConfig_91", "ebg-aqap-banks-citic-amh"), new MultiLangEnumBridge("\u4e2d\u4fe1\u94f6\u884c\u4f5c\u4e3a\u6536\u62a5\u65b9\uff0c\u63a5\u6536\u63a8\u9001MT940\u6587\u4ef6\u7684\u65f6\u95f4\u3002", "BankBusinessConfig_92", "ebg-aqap-banks-citic-amh"), new MultiLangEnumBridge("\u8be5\u53c2\u6570\u5f71\u54cd\u4f59\u989d\u67e5\u8be2\uff0c\u5982\u9694\u65e5\u63a8\u9001\uff0c\u5219\u67e5\u8be2\u5386\u53f2\u4f59\u989d\u65f6\uff0c\u8bf7\u6c42\u94f6\u884c\u65e5\u671f\u8d77\u6b62\u65f6\u95f4\u4e3a\u67e5\u8be2\u65e5\u671f+1\u65e5\u3002\u5982\u5f53\u65e5\u63a8\u9001\uff0c\u5219\u67e5\u8be2\u5386\u53f2\u4f59\u989d\u65f6\uff0c\u8bf7\u6c42\u94f6\u884c\u65e5\u671f\u8d77\u6b62\u65f6\u95f4\u4e3a\u67e5\u8be2\u65e5\u671f\u3002", "BankBusinessConfig_93", "ebg-aqap-banks-citic-amh")})).mlSourceNames((List)Lists.newArrayList((Object[])new MultiLangEnumBridge[]{new MultiLangEnumBridge("\u9694\u65e5\u63a8\u9001", "BankBusinessConfig_94", "ebg-aqap-banks-citic-amh"), new MultiLangEnumBridge("\u5f53\u65e5\u63a8\u9001", "BankBusinessConfig_95", "ebg-aqap-banks-citic-amh")})).sourceValues((List)Lists.newArrayList((Object[])new String[]{"nestday", "today"})).defaultValues((List)Lists.newArrayList((Object[])new String[]{"nestday"})).isAccNo(true).mustInput(true).build();

    public String getBankVersionID() {
        return "CITIC_AMH";
    }

    public List<PropertyConfigItem> getAllPropertyConfigItems() {
        List configItemList = this.getBankAddtionalPropertyConfigItems(false, false, false, false);
        configItemList.addAll(Lists.newArrayList((Object[])new PropertyConfigItem[]{CITIC_AMH_PAY_STATE_TIMEOUT, BANK_SWIFT_CODE, citic_amh_balance_choose}));
        return configItemList;
    }

    public static boolean queryBalanceType(String accNo) {
        return "today".equals(citic_amh_balance_choose.getCurrentValueWithObjectID(accNo));
    }

    public static int getPayStateTimeout() {
        String config = CITIC_AMH_PAY_STATE_TIMEOUT.getCurrentValue();
        int timeout = 0;
        if (null != config && config.length() > 0) {
            try {
                if (Integer.parseInt(config) > 0) {
                    timeout = Integer.parseInt(config);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return timeout;
    }

    public static boolean isPayStateTimeout(LocalDateTime submitSuccessTime) {
        int payStateTimeout = BankBusinessConfig.getPayStateTimeout();
        if (payStateTimeout <= 0) {
            return false;
        }
        LocalDateTime time = submitSuccessTime.plus(payStateTimeout * 60 * 60, ChronoUnit.SECONDS);
        return time.isBefore(LocalDateTime.now());
    }

    public static String getBicCode(String accNo) {
        return BANK_SWIFT_CODE.getCurrentValueWithObjectID(accNo);
    }

    public boolean isForeignBank() {
        return true;
    }
}

