/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.amh.services.balance;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.amh.BankBusinessConfig;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.services.MappingAcctService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        String accno;
        MappingAcctService service = MappingAcctService.getInstance();
        if (service.isExist(accno = request.getHeader().getAcnt().getAccNo())) {
            String iso = CurrencyUtils.convert2Iso((String)request.getCurrency(), (String)request.getHeader().getBankVersionID(), (String)request.getHeader().getCustomerID());
            accno = service.mapping(accno, iso);
        }
        DateTimeFormatter fmt = DateTimeFormatter.ofPattern("yyyyMMdd");
        Element root = new Element("stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLMTCQRY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"accNo", (String)accno);
        if (!BankBusinessConfig.queryBalanceType(accno)) {
            JDomUtils.addChild((Element)root, (String)"startDate", (String)request.getStartDate().plusDays(1L).format(fmt));
            JDomUtils.addChild((Element)root, (String)"endDate", (String)request.getStartDate().plusDays(1L).format(fmt));
        } else {
            JDomUtils.addChild((Element)root, (String)"startDate", (String)request.getStartDate().format(fmt));
            JDomUtils.addChild((Element)root, (String)"endDate", (String)request.getStartDate().format(fmt));
        }
        JDomUtils.addChild((Element)root, (String)"pageNumber", (String)"10");
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage) || StringUtils.isEmpty((String)currentPage)) {
            currentPage = "1";
        }
        JDomUtils.addChild((Element)root, (String)"startRecord", (String)currentPage);
        JDomUtils.addChild((Element)root, (String)"cryType", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)root, (String)"msgType", (String)"AMH940");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        String status = root.getChildText("status");
        String statusText = root.getChildText("statusText");
        BankResponse rsp = new BankResponse(status, statusText);
        ParserUtils.checkRspCode((BankResponse)rsp, (String)"AAAAAAA");
        String totalNum = root.getChildTextTrim("totalNum");
        if (StringUtils.isEmpty((String)totalNum) || "0".equals(totalNum)) {
            this.setLastPage(true);
            return new EBBankBalanceResponse();
        }
        Integer total = Integer.parseInt(totalNum);
        String currentPage = this.getCurrentPage();
        int pagenow = Integer.parseInt(currentPage);
        if (pagenow * 10 < total) {
            this.setLastPage(false);
            String nextpage = pagenow + 1 + "";
            this.setCurrentPage(nextpage);
        } else {
            this.setLastPage(true);
        }
        Element list = root.getChild("list");
        List rows = list.getChildren();
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        for (int i = 0; i < rows.size(); ++i) {
            Element element = (Element)rows.get(i);
            String islastPage = element.getChildTextTrim("islastPage");
            if (!"Y".equals(islastPage)) continue;
            BalanceInfo balanceInfo = new BalanceInfo();
            String finalBalance = element.getChildTextTrim("finalBalance");
            String finalBalanceDate = element.getChildTextTrim("finalBalanceDate");
            String cryType = element.getChildTextTrim("cryType");
            this.setBankCurrency(balanceInfo, cryType);
            this.setBalanceDateTime(balanceInfo, this.parseDateTime(finalBalanceDate));
            this.setCurrentBalance(balanceInfo, finalBalance);
            this.setBankAcnt(balanceInfo, request.getAcnt());
            balances.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balances);
    }

    public boolean match(BankBalanceRequest request) {
        return true;
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLMTCQRY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d77\u5916\u8d26\u6237\u67e5\u8be2\u2014\u5f52\u96c6\u8d26\u5355\u67e5\u8be2", (String)"HistoryBalanceImpl_9", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]);
    }

    private LocalDateTime parseDateTime(String dateStr) {
        LocalDateTime localDateTime;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        try {
            Date date = formatter.parse(dateStr);
            Instant instant = date.toInstant();
            ZoneId zone = ZoneId.systemDefault();
            localDateTime = LocalDateTime.ofInstant(instant, zone);
        }
        catch (Exception ex) {
            return null;
        }
        return localDateTime;
    }

    public void doBizWithPagePre(BankBalanceRequest request) {
        this.setCurrentPage("1");
        this.setLastPage(false);
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        return true;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        String key;
        String datestr;
        String currency;
        String accno;
        BalanceInfo balanceInfo;
        int i;
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        BankBalanceRequest bankBalanceRequest = new BankBalanceRequest();
        bankBalanceRequest.setCurrency(request.getCurrency());
        bankBalanceRequest.setStartDate(startDate);
        bankBalanceRequest.setEndDate(startDate);
        bankBalanceRequest.setHeader(request.getHeader());
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        do {
            try {
                EBBankBalanceResponse response = this.doBizPreDay(bankBalanceRequest);
                balances.addAll(response.getBalances());
            }
            catch (Exception e) {
                BalanceInfo balanceInfo2 = new BalanceInfo();
                if (e.getCause() != null && e.getCause().getCause() != null) {
                    balanceInfo2.setError(e.getCause().getCause().getMessage());
                } else {
                    balanceInfo2.setError(e.getMessage());
                }
                balanceInfo2.setBankCurrency(request.getCurrency());
                balanceInfo2.setBankAcnt(request.getAcnt());
                balanceInfo2.setBalanceDateTime(startDate.atStartOfDay());
                balances.add(balanceInfo2);
                if (PROCESS_CONNECTED == EBContext.getContext().getProcessFlag()) break;
            }
            startDate = startDate.plusDays(1L);
            bankBalanceRequest.setStartDate(startDate);
            bankBalanceRequest.setEndDate(startDate);
        } while (ChronoUnit.DAYS.between(startDate, endDate) >= 0L);
        ArrayList<BalanceInfo> result = new ArrayList<BalanceInfo>(1);
        HashMap<String, String> keyset = new HashMap<String, String>(1);
        for (i = 0; i < balances.size(); ++i) {
            balanceInfo = (BalanceInfo)balances.get(i);
            if (!StringUtils.isEmpty((String)balanceInfo.getError())) continue;
            accno = balanceInfo.getBankAcnt().getAccNo();
            currency = balanceInfo.getBankCurrency();
            datestr = balanceInfo.getBalanceDateTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            key = accno + datestr + currency;
            if (keyset.containsKey(key)) continue;
            result.add(balanceInfo);
            keyset.put(key, key);
        }
        for (i = 0; i < balances.size(); ++i) {
            balanceInfo = (BalanceInfo)balances.get(i);
            accno = balanceInfo.getBankAcnt().getAccNo();
            currency = balanceInfo.getBankCurrency();
            datestr = balanceInfo.getBalanceDateTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            key = accno + datestr + currency;
            if (StringUtils.isEmpty((String)balanceInfo.getError()) || keyset.containsKey(key)) continue;
            result.add(balanceInfo);
            keyset.put(key, key);
        }
        return new EBBankBalanceResponse(result);
    }

    public EBBankBalanceResponse doBizPreDay(BankBalanceRequest request) {
        ArrayList balances = new ArrayList(16);
        this.doBizWithPagePre(request);
        try {
            do {
                EBBankBalanceResponse response;
                if (!CollectionUtil.isNotEmpty((Collection)(response = this.process(request)).getBalances())) continue;
                balances.addAll(response.getBalances());
            } while (!this.isLastPage());
            return new EBBankBalanceResponse(balances);
        }
        catch (Exception var4) {
            throw EBExceiptionUtil.serviceException((Throwable)var4);
        }
    }
}

