/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.amh.services.payment.oversea;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.citic.amh.BankBusinessConfig;
import kd.ebg.aqap.banks.citic.amh.services.payment.oversea.CompanyQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DLXPYSUB";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d77\u5916\u8d44\u91d1\u8f6c\u8d26\u8bf7\u6c42\uff08MT101\uff09", (String)"CompanyImpl_2", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6d77\u5916\u8d44\u91d1\u8f6c\u8d26\u8bf7\u6c42\uff08MT101\uff09\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"CompanyImpl_3", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]));
        }
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLXPYSUB");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String trandate = LocalDate.now().format(DateTimeFormatter.ofPattern("yyMMdd"));
        String prex = RequestContextUtils.getBankParameterValue((String)"userprex");
        StringBuilder builder = new StringBuilder();
        String seq = Sequence.getAutoincrementNumber((int)7);
        builder.append(prex).append(date).append(seq);
        JDomUtils.addChild((Element)root, (String)"clientID", (String)builder.toString());
        JDomUtils.addChild((Element)root, (String)"tranNo", (String)builder.toString());
        PaymentInfoSysFiled.set((List)paymentInfos, (String)"pay_tranNo", (String)builder.toString());
        JDomUtils.addChild((Element)root, (String)"version", (String)"1.0.0");
        JDomUtils.addChild((Element)root, (String)"channelFlag", (String)prex);
        String userbic = RequestContextUtils.getBankParameterValue((String)"userbic");
        JDomUtils.addChild((Element)root, (String)"repBank", (String)BankBusinessConfig.getBicCode(request.getAcnt().getAccNo()));
        JDomUtils.addChild((Element)root, (String)"messBank", (String)userbic);
        StringBuilder builder2 = new StringBuilder();
        builder2.append(date).append(seq);
        JDomUtils.addChild((Element)root, (String)"ebkNo", (String)builder2.toString());
        paymentInfo.setBankRefID(builder2.toString());
        paymentInfo.setKdFlagID(builder2.toString());
        JDomUtils.addChild((Element)root, (String)"tranDate", (String)trandate);
        JDomUtils.addChild((Element)root, (String)"UUID", (String)UUID.randomUUID().toString());
        Element list = JDomUtils.addChild((Element)root, (String)"list");
        list.setAttribute("name", "userDataList");
        Element row = JDomUtils.addChild((Element)list, (String)"row");
        JDomUtils.addChild((Element)row, (String)"tranRefNo", (String)builder2.toString());
        JDomUtils.addChild((Element)row, (String)"cryType", (String)paymentInfo.getCurrency());
        if ("JPY".equals(paymentInfo.getCurrency())) {
            JDomUtils.addChild((Element)row, (String)"tranAmt", (String)(paymentInfo.getAmount().intValue() + ""));
        } else {
            JDomUtils.addChild((Element)row, (String)"tranAmt", (String)paymentInfo.getAmount().toPlainString());
        }
        JDomUtils.addChild((Element)row, (String)"payerAccNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)row, (String)"payerBEI", (String)userbic);
        JDomUtils.addChild((Element)row, (String)"payerName", (String)request.getAcnt().getEnAccName());
        JDomUtils.addChild((Element)row, (String)"payerAddr", (String)paymentInfo.getPayerAddress());
        JDomUtils.addChild((Element)row, (String)"payerOpactBic", (String)"");
        JDomUtils.addChild((Element)row, (String)"payeSttlmCode", (String)"");
        JDomUtils.addChild((Element)row, (String)"payeSttlmId", (String)"");
        JDomUtils.addChild((Element)row, (String)"midlBic", (String)"");
        if (!StringUtils.isEmpty((String)paymentInfo.getIncomeSwiftCode())) {
            JDomUtils.addChild((Element)row, (String)"rcvBic", (String)paymentInfo.getIncomeSwiftCode());
            JDomUtils.addChild((Element)row, (String)"payeOpactName", (String)"");
            JDomUtils.addChild((Element)row, (String)"payeOpactAddr", (String)"");
        } else {
            JDomUtils.addChild((Element)row, (String)"rcvBic", (String)"");
            JDomUtils.addChild((Element)row, (String)"payeOpactName", (String)paymentInfo.getIncomeBankName());
            JDomUtils.addChild((Element)row, (String)"payeOpactAddr", (String)paymentInfo.getIncomeBankAddress());
        }
        JDomUtils.addChild((Element)row, (String)"rcvAccNo", (String)paymentInfo.getIncomeAccNo());
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getIncomeCountry());
        if (null == code) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6%s\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5339\u914d\u56fd\u5bb6\u4ee3\u7801\u8868\u3002", (String)"CompanyImpl_8", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]), paymentInfo.getIncomeCountry()));
        }
        JDomUtils.addChild((Element)row, (String)"rcvCnCity", (String)code.geteChart2());
        JDomUtils.addChild((Element)row, (String)"rcvName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)row, (String)"rcvAddr", (String)"");
        JDomUtils.addChild((Element)row, (String)"remPostscript", (String)paymentInfo.getExplanation());
        String feetype = paymentInfo.getPayerFeeType();
        if ("02".equals(feetype)) {
            JDomUtils.addChild((Element)row, (String)"declareNo", (String)"BEN");
        } else if ("01".equals(feetype)) {
            JDomUtils.addChild((Element)row, (String)"declareNo", (String)"OUR");
        } else if ("03".equals(feetype)) {
            JDomUtils.addChild((Element)row, (String)"declareNo", (String)"SHA");
        }
        JDomUtils.addChild((Element)row, (String)"instructionCode", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String message = JDomUtils.root2String((Element)root, (String)encoding);
        return message;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        String status = root.getChildText("status");
        String statusText = root.getChildText("statusText");
        if ("AAAAAAA".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyImpl_4", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]), (String)status, (String)statusText);
        } else if ("ED11306".equalsIgnoreCase(status) || "ED11313".equalsIgnoreCase(status) || "ED11315".equalsIgnoreCase(status) || "ED11314".equalsIgnoreCase(status) || "ED11310".equalsIgnoreCase(status) || "ED11311".equalsIgnoreCase(status) || "ED02071".equalsIgnoreCase(status) || "FRNF010".equalsIgnoreCase(status) || "PAAR000".equalsIgnoreCase(status) || "PC5R000".equalsIgnoreCase(status) || "PC5R002".equalsIgnoreCase(status) || "PC5R003".equalsIgnoreCase(status) || "PC5R006".equalsIgnoreCase(status) || "PC5R008".equalsIgnoreCase(status) || "PC5R010".equalsIgnoreCase(status) || "PC5R011".equalsIgnoreCase(status) || "PC5R013".equalsIgnoreCase(status) || "PC5R019".equalsIgnoreCase(status) || "PC5R021".equalsIgnoreCase(status) || "PC5R026".equalsIgnoreCase(status) || "PC5R027".equalsIgnoreCase(status) || "PC5R028".equalsIgnoreCase(status) || "PC5R029".equalsIgnoreCase(status) || "PC5R030".equalsIgnoreCase(status) || "PC5R036".equalsIgnoreCase(status) || "PC5R037".equalsIgnoreCase(status) || "ED04500".equalsIgnoreCase(status) || "ED00066".equalsIgnoreCase(status) || "TB00040".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)status, (String)statusText);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)status, (String)statusText);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

