/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nbcb.dc.service.payment;

import kd.ebg.aqap.banks.nbcb.dc.service.payment.company.CompanyPayImpl;
import kd.ebg.aqap.banks.nbcb.dc.service.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.banks.nbcb.dc.service.payment.individual.newindiv.PaymentImpl;
import kd.ebg.aqap.banks.nbcb.dc.service.payment.individual.salary.InnerAndOuterWageAgency;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.PayRouteEnum;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        if (this.isPay_for_salary(paymentInfo)) {
            if (this.isSameBank(paymentInfo)) {
                this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, InnerAndOuterWageAgency.class.getName());
            }
            paymentInfo.setToIndividual("true");
        } else if (this.isPay_for_capital_allocation(paymentInfo)) {
            this.setImplClassNameCustom(paymentInfo, CompanyPayImpl.class.getName());
            paymentInfo.setToIndividual("false");
        } else if (this.isPay(paymentInfo)) {
            if (this.isSalaryUseCN(paymentInfo)) {
                paymentInfo.setToIndividual("true");
                this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
            } else if (this.isTransferUseCN(paymentInfo)) {
                paymentInfo.setToIndividual("false");
                this.setImplClassNameCustom(paymentInfo, CompanyPayImpl.class.getName());
            } else if (!this.isSameBank(paymentInfo)) {
                this.setImplClassName(paymentInfo, PaymentImpl.class.getName());
            } else {
                paymentInfo.setToIndividual("false");
                this.setImplClassNameCustom(paymentInfo, CompanyPayImpl.class.getName());
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getSubBizTypeCheckMsg((String)paymentInfo.getSubBizType()));
        }
        busiImplInfo.setPackageKey("");
        return busiImplInfo;
    }

    public void setImplClassNameCustom(PaymentInfo paymentInfo, String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            String payBizCode = paymentInfo.is2SameBank() ? "srv006_singleInnerTransfer" : "srv007_singleOuterTransfer";
            paymentInfo.setImplClassName(className);
            this.addRoute(false, PayRouteEnum.IMPL.getDesc(), className);
            try {
                AbstractPayImpl pay = (AbstractPayImpl)Class.forName(className).newInstance();
                this.addRoute(false, PayRouteEnum.BANK_PAY_CODE.getDesc(), payBizCode);
                paymentInfo.setQueryImplClassName(pay.defaultQueryClass().getName());
                className = pay.defaultQueryClass().getName();
                this.addRoute(false, PayRouteEnum.QUERY_IMPL.getDesc(), className);
                try {
                    AbstractQueryPayImpl queryPay = (AbstractQueryPayImpl)Class.forName(className).newInstance();
                    String bankQueryPayCode = queryPay.getBizCode();
                    this.addRoute(false, PayRouteEnum.BANK_QUERY_PAY_CODE.getDesc(), StringUtils.isEmpty((String)bankQueryPayCode) ? "" : bankQueryPayCode);
                }
                catch (Exception var5) {
                    EBExceiptionUtil.serviceException((String)("QueryPayImpl = " + className + " is not found"), (Throwable)var5);
                }
            }
            catch (Exception var5) {
                EBExceiptionUtil.serviceException((String)("PayImpl = " + className + " is not found"), (Throwable)var5);
            }
        }
    }

    public void appendData(PaymentInfo paymentInfo) throws EBServiceException {
        this.setPayRouteTrace(paymentInfo, this.getBusiImplInfo(paymentInfo));
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

