/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.yifubao.cmp.sdk.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import kd.bos.dataentity.resource.ResManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.util.Base64;

public class RSAUtil {
    private static final String RSA = "RSA";
    private static final int RSA_SIZE_2048 = 2048;
    private static final int RSA_SIZE_1024 = 1024;
    private static final String MD5_WITH_RSA = "MD5withRSA";
    private static final String SHA1_WITH_RSA = "SHA1WithRSA";
    public static final String PUBLIC_KEY = "publicKey";
    public static final String PUBLIC_KEY_B64 = "publicKeyBase64";
    public static final String PRIVATE_KEY = "privateKey";
    public static final String PRIVATE_KEY_B64 = "privateKeyBase64";

    public static Map<String, Object> create1024Key() throws NoSuchAlgorithmException {
        return RSAUtil.createKey(1024);
    }

    public static Map<String, Object> create2048Key() throws NoSuchAlgorithmException {
        return RSAUtil.createKey(2048);
    }

    public static Map<String, Object> createKey(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = null;
        keyGen = KeyPairGenerator.getInstance(RSA);
        keyGen.initialize(keySize, new SecureRandom());
        KeyPair key = keyGen.generateKeyPair();
        PublicKey pubKey = key.getPublic();
        PrivateKey priKey = key.getPrivate();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(PUBLIC_KEY, pubKey);
        map.put(PRIVATE_KEY, priKey);
        map.put(PUBLIC_KEY_B64, Base64.encodeBase64String((byte[])pubKey.getEncoded()));
        map.put(PRIVATE_KEY_B64, Base64.encodeBase64String((byte[])priKey.getEncoded()));
        return map;
    }

    public static void createKey(String publicFilePath, String privateFilePath, int keySize) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(RSA);
        keyGen.initialize(keySize, new SecureRandom());
        KeyPair pair = keyGen.generateKeyPair();
        RSAUtil.write(publicFilePath, pair.getPublic());
        RSAUtil.write(privateFilePath, pair.getPrivate());
    }

    private static void write(String path, Object key) throws Exception {
        boolean creat;
        File file = new File(path);
        if (!file.getParentFile().exists() && !(creat = file.getParentFile().mkdirs())) {
            System.out.println("\u521b\u5efa\u6587\u4ef6\u76ee\u5f55\u5f02\u5e38\uff01");
            return;
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(path));
            oos.writeObject(key);
        }
        catch (Exception e) {
            throw new Exception(ResManager.loadKDString((String)"\u5bc6\u94a5\u5199\u5165\u5f02\u5e38", (String)"RSAUtil_0", (String)"ebg-aqap-banks-yifubao-cmp", (Object[])new Object[0]), e);
        }
        finally {
            if (null != oos) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    oos = null;
                }
            }
        }
    }

    public static boolean vertiy(byte[] data, byte[] sign, PublicKey pubk) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(SHA1_WITH_RSA);
        signature.initVerify(pubk);
        signature.update(data);
        return signature.verify(sign);
    }

    public static boolean vertiy(String data, String sign, PublicKey pubk) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        return RSAUtil.vertiy(data.getBytes(), Base64.decodeBase64((String)sign), pubk);
    }

    public static byte[] sign(byte[] data, PrivateKey prik) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(SHA1_WITH_RSA);
        signature.initSign(prik);
        signature.update(data);
        return signature.sign();
    }

    public static String sign(String data, PrivateKey prik) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        return Base64.encodeBase64String((byte[])RSAUtil.sign(data.getBytes(), prik)).trim();
    }

    public static PublicKey getPublicKey(String strPubKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)strPubKey));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
        return pubKey;
    }

    public static PrivateKey getPrivateKey(String strPriKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec priKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)strPriKey));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PrivateKey priKey = keyFactory.generatePrivate(priKeySpec);
        return priKey;
    }

    public static PublicKey resolvePublicKey(String path) throws Exception {
        PublicKey publicKey;
        PublicKey pubkey = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = FileUtils.openInputStream((File)new File(path));
            ois = new ObjectInputStream(fis);
            publicKey = pubkey = (PublicKey)ois.readObject();
        }
        catch (Exception e) {
            try {
                throw new Exception(ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38", (String)"RSAUtil_1", (String)"ebg-aqap-banks-yifubao-cmp", (Object[])new Object[0]), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        IOUtils.closeQuietly((InputStream)fis);
        return publicKey;
    }

    public static PrivateKey resolvePrivateKey(String path) throws Exception {
        PrivateKey privateKey;
        PrivateKey prikey = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = FileUtils.openInputStream((File)new File(path));
            ois = new ObjectInputStream(fis);
            privateKey = prikey = (PrivateKey)ois.readObject();
        }
        catch (Exception e) {
            try {
                throw new Exception(ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38", (String)"RSAUtil_1", (String)"ebg-aqap-banks-yifubao-cmp", (Object[])new Object[0]), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        IOUtils.closeQuietly((InputStream)fis);
        return privateKey;
    }

    public static String getBase64PublicKeyString(PublicKey pubKey) {
        return Base64.encodeBase64String((byte[])pubKey.getEncoded()).trim();
    }

    public static String getBase64PrivateKeyString(PrivateKey priKey) {
        return Base64.encodeBase64String((byte[])priKey.getEncoded()).trim();
    }

    public static String getBase64PublicKeyString(String path) throws Exception {
        PublicKey pubKey = RSAUtil.resolvePublicKey(path);
        return RSAUtil.getBase64PublicKeyString(pubKey);
    }

    public static String getBase64PrivateKeyString(String path) throws Exception {
        PrivateKey priKey = RSAUtil.resolvePrivateKey(path);
        return RSAUtil.getBase64PrivateKeyString(priKey);
    }

    public static String encrypt(Key key, String message) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, key);
        byte[] miwen = cipher.doFinal(message.getBytes());
        return String.valueOf(new BigInteger(miwen));
    }

    public static String decrypt(Key key, String message) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] miwen = new BigInteger(message).toByteArray();
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, key);
        byte[] result = cipher.doFinal(miwen);
        return new String(result);
    }

    public static void main(String[] args) throws Exception {
        RSAUtil.createKey("D:/RSA/public.key", "D:/RSA/private.key", 1024);
        PublicKey pubKey = RSAUtil.resolvePublicKey("D:/RSA/public.key");
        PrivateKey priKey = RSAUtil.resolvePrivateKey("D:/RSA/private.key");
        System.out.println("\u516c\u94a5\uff1a" + Base64.encodeBase64String((byte[])pubKey.getEncoded()));
        System.out.println("\u79c1\u94a5\uff1a" + Base64.encodeBase64String((byte[])priKey.getEncoded()));
        String data = "B64DC35297E509D8078FDD64DDBBED73";
        String signData = RSAUtil.sign(data, priKey);
        System.out.println("\u7b7e\u540d\u503c\u4e3a\uff1a" + signData);
        boolean result = RSAUtil.vertiy(data, signData, pubKey);
        System.out.println("\u9a8c\u7b7e\u7ed3\u679c\u4e3a\uff1a" + result);
    }
}

