/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.yifubao.cmp.service.detail;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.yifubao.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.yifubao.cmp.sdk.SignatureUtil;
import kd.ebg.aqap.banks.yifubao.cmp.utils.ElementUtil;
import kd.ebg.aqap.banks.yifubao.cmp.utils.PostUtil;
import kd.ebg.aqap.banks.yifubao.cmp.utils.SignUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class HisDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(HisDetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        return null;
    }

    public Map<String, Object> packMap(BankDetailRequest bankDetailRequest) {
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        StringBuilder packStr = new StringBuilder();
        HashMap<String, Object> signMap = new HashMap<String, Object>(16);
        String account_ID = BankBusinessConfig.getAccount(accNo);
        ElementUtil.addElement(packStr, signMap, "merchantNo", account_ID);
        ElementUtil.addElement(packStr, signMap, "inputCharset", "UTF-8");
        String public_index = BankBusinessConfig.getPublic_index(accNo);
        ElementUtil.addElement(packStr, signMap, "publicKeyIndex", public_index);
        ElementUtil.addElement(packStr, signMap, "submitTime", LocalDateUtil.formatDate((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
        ElementUtil.addElement(packStr, signMap, "billDate", LocalDateUtil.formatDate((LocalDate)bankDetailRequest.getStartDate()));
        ElementUtil.addElement(packStr, signMap, "billType", "01");
        try {
            String digest = SignatureUtil.digest(signMap);
            String signresult = SignUtils.sign(digest);
            ElementUtil.addElement(packStr, signMap, "signAlgorithm", "RSA");
            ElementUtil.addElement(packStr, signMap, "signature", signresult);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
        logger.info("\u8bf7\u6c42\u5185\u5bb9\uff1a" + packStr);
        return signMap;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String result) {
        BankAcnt acnt = bankDetailRequest.getAcnt();
        result = HisDetailImpl.changeCode(result).replace("   ", "");
        logger.info("\u83b7\u53d6\u5230\u7684\u5bf9\u8d26\u5355\u4fe1\u606f\uff1a" + result);
        List<String[]> datas = HisDetailImpl.parseData(result);
        ArrayList<DetailInfo> list = new ArrayList<DetailInfo>(1);
        for (int i = 0; i < datas.size(); ++i) {
            String[] str = datas.get(i);
            DetailInfo info = new DetailInfo();
            list.add(info);
            info.setBankVersionID(acnt.getBankVersionId());
            info.setBankLoginID(acnt.getBankLoginId());
            info.setCurrency(acnt.getCurrency());
            if (str[5].contains("(") && str[5].contains(")")) {
                info.setOppAccName(str[5].substring(0, str[5].lastIndexOf("(")));
                info.setOppAccNo(str[5].substring(str[5].lastIndexOf("(") + 1, str[5].lastIndexOf(")")));
            } else {
                info.setOppAccName(str[5]);
            }
            String transTime = str[8];
            if (StringUtils.isNotEmpty((String)transTime)) {
                info.setTransTime(LocalDateUtil.parseDateTime((String)transTime, (String)"yyyy-MM-dd HH:mm:ss"));
                info.setTransDate(info.getTransTime().toLocalDate());
            }
            BigDecimal inAmount = new BigDecimal(str[9]);
            BigDecimal outAmount = new BigDecimal(str[10]);
            String JYAmount = "";
            if (inAmount.compareTo(BigDecimal.ZERO) == 0) {
                info.setDebitAmount(outAmount.abs());
                info.setCreditAmount(BigDecimal.ZERO);
                JYAmount = str[10];
            } else {
                info.setDebitAmount(BigDecimal.ZERO);
                info.setCreditAmount(inAmount.abs());
                JYAmount = str[9];
            }
            info.setUseCn(str[0]);
            info.setAccNo(acnt.getAccNo());
            info.setAccName(acnt.getAccName());
            info.setBankName(acnt.getBankName());
            info.setTransType("normal");
            if (StringUtils.isNotEmpty((String)str[11])) {
                try {
                    info.setBalance(new BigDecimal(str[11]));
                }
                catch (Exception e) {
                    logger.error("balance:", (Throwable)e);
                }
            }
            String exp = str[13];
            info.setExplanation(exp);
            info.setBankDetailNo(str[2]);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)str[0]);
            jsonObject.put("CWSerialNo", (Object)str[1]);
            jsonObject.put("JYSerialNo", (Object)str[2]);
            jsonObject.put("TSSerialNo", (Object)str[3]);
            jsonObject.put("SZTransTime", (Object)str[8]);
            jsonObject.put("JYAmount", (Object)JYAmount);
            jsonObject.put("Balance", (Object)str[11]);
            info.setJsonMap(jsonObject.toJSONString());
            info.setReceiptNo(str[1]);
        }
        return new EBBankDetailResponse(list);
    }

    public static List<String[]> parseData(String content) {
        ArrayList<String[]> dataRows = new ArrayList<String[]>();
        try (BufferedReader reader = new BufferedReader(new StringReader(content));){
            String line;
            boolean isFirstDataLine = true;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
                if (isFirstDataLine) {
                    isFirstDataLine = false;
                    continue;
                }
                String[] data = line.split(",", -1);
                for (int i = 0; i < data.length; ++i) {
                    data[i] = data[i].trim();
                }
                dataRows.add(data);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)"parse error", (Throwable)e);
        }
        return dataRows;
    }

    public static String changeCode(String result) {
        try {
            result = new String(result.getBytes(StandardCharsets.ISO_8859_1), "GB18030");
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)"chartset error", (Throwable)e);
        }
        return result;
    }

    public EBBankDetailResponse process(BankDetailRequest request) {
        try {
            EBContext.getContext().setProcessFlag(PROCESS_PACK);
            Map<String, Object> body = this.packMap(request);
            String result = PostUtil.sendMsg(body, request.getAcnt());
            return this.parse(request, result);
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            logger.error("\u660e\u7ec6\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            String errorMsg = ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-yifubao-cmp", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-yifubao-cmp", (Object[])new Object[0]), e.getMessage());
            }
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u8d26\u5355\u4e0b\u8f7d", (String)"DetailImpl_3", (String)"ebg-aqap-banks-yifubao-cmp", (Object[])new Object[0]);
    }

    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        ArrayList result = new ArrayList(1);
        LocalDate date = startDate;
        while (!date.isAfter(endDate)) {
            request.setStartDate(date);
            EBBankDetailResponse response = this.process(request);
            result.addAll(response.getDetails());
            date = date.plusDays(1L);
        }
        request.setStartDate(startDate);
        return new EBBankDetailResponse(result);
    }
}

