/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.yifubao.cmp.utils;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.banks.yifubao.cmp.YFuBaoConstant;
import kd.ebg.aqap.banks.yifubao.cmp.sdk.SignatureUtil;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class SignUtils
implements YFuBaoConstant {
    public static String sign(String oriStr) {
        String private_key = SignUtils.getRealCertContent("private_key", EBContext.getContext().getCustomID(), EBContext.getContext().getAcnt().getAccNo());
        String sign = "";
        try {
            sign = SignatureUtil.sign(oriStr, private_key);
        }
        catch (Exception e) {
            EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
        }
        return sign;
    }

    private static String getRealCertContent(String name, String customId, String acctNo) {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findAccCertByBankLoginIDAndBankConfigIDAndCustomID(name, RequestContextUtils.getRequestContext().getBankLoginID(), customId, acctNo);
        if (StringUtils.isNotEmpty((String)certInfo.getFileContent())) {
            byte[] certBytes;
            AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
            CipherInfo cipherInfo = security.getCipherInfo(certInfo.getFileContent());
            int version = cipherInfo.getCipherVersion();
            String id = "";
            if (version == 0) {
                certBytes = java.util.Base64.getDecoder().decode(cipherInfo.getCipherData());
                id = SignUtils.getID(name);
            } else {
                certBytes = Base64.decodeBase64((String)cipherInfo.getCipherData());
            }
            byte[] plainData = DesUtil.decryptProxyCert((byte[])certBytes, (String)customId, (int)version, (String)id);
            return StringUtils.byteToString((byte[])plainData);
        }
        return "";
    }

    private static String getID(String name) {
        String id = "";
        String bankLoginID = EBContext.getContext().getBankLoginID();
        QFilter filter = QFilter.of((String)"bank_config_id=? and bank_login_id=?", (Object[])new Object[]{name, bankLoginID});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_bd_cert", (String)"id", (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            id = dynamicObject.getString("id");
        }
        return id;
    }
}

