/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scb.h2h.service;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.ebg.aqap.banks.scb.h2h.BankBusinessConfig;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SCBH2H_Packer {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HHmmss");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");

    public static String formatDate(LocalDate localDate) {
        return localDate.format(DATE_FORMATTER);
    }

    public static String formatTime(LocalTime localDate) {
        return localDate.format(TIME_FORMATTER);
    }

    public static Element createHead(String bizType, String seqno) {
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)LocalDateUtil.formatLocalTime((LocalTime)LocalTime.now()));
        JDomUtils.addChild((Element)head, (String)"bizType", (String)bizType);
        if ("BALANCE".equals(bizType) && BankBusinessConfig.isUseNewBalance()) {
            JDomUtils.addChild((Element)head, (String)"subBizType", (String)"NEW_BALANCE");
        }
        JDomUtils.addChild((Element)head, (String)"token", (String)"");
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        return head;
    }

    public static Element createHead(String bizType) {
        return SCBH2H_Packer.createHead(bizType, Sequence.gen16Sequence());
    }

    public static boolean isContainsStrangeStr(String content) {
        if (StringUtils.isEmpty((String)content)) {
            return false;
        }
        for (int i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            if (ch != '~' && ch != '!' && ch != '@' && ch != '#' && ch != '$' && ch != '%' && ch != '^' && ch != '&' && ch != '*' && ch != '_' && ch != '{' && ch != '}' && ch != '\"' && ch != '`' && ch != '=' && ch != '[' && ch != ']' && ch != ';') continue;
            return true;
        }
        return false;
    }
}

