/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jjccb.cmp.services.payment.salary;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jjccb.cmp.services.util.Common;
import kd.ebg.aqap.banks.jjccb.cmp.services.util.FileDownloadUtil;
import kd.ebg.aqap.banks.jjccb.cmp.services.util.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger log = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public int getBatchSize() {
        return 200;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        return this.pack200201(paymentInfos, ((PaymentInfo)paymentInfos.get(0)).getBankRefID());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        return this.parse200201(paymentInfos, responseStr);
    }

    private EBBankPayResponse parse200201(List<PaymentInfo> paymentInfos, String response) {
        Element ap = JDomUtils.string2Root((String)response, (String)RequestContextUtils.getCharset());
        Element head = ap.getChild("head");
        BankResponse bankResponse = Common.parseBankResponse((Element)head);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = ap.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u8bb0\u5f55\u4e3a\u7a7a\u3002", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-jjccb-cmp", (Object[])new Object[0]));
        }
        String file_flag = head.getChildTextTrim("file_flag");
        String serial_record = "";
        if ("1".equals(file_flag)) {
            this.log.info("\u672c\u6b21\u6279\u91cf\u4ee3\u53d1\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de'\u6587\u4ef6'");
            String file_name = body.getChildTextTrim("file_name");
            try {
                serial_record = new FileDownloadUtil().doBiz(file_name);
            }
            catch (Exception e) {
                this.log.error("\u4ece\u91d1\u8776\u4ee3\u7406\u7a0b\u5e8f\u83b7\u53d6\u6279\u91cf\u4ee3\u53d1\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"[\u6279\u91cf\u8f6c\u8d26\u7ed3\u679c\u660e\u7ec6\u67e5\u8be2]\u83b7\u53d6\u6587\u4ef6\u5931\u8d25\u3002", (String)"QueryPayImpl_9", (String)"ebg-aqap-banks-jjccb-cmp", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            serial_record = body.getChildTextTrim("serial_record");
        }
        String[][] mfs = this.parseMFS(serial_record, recordNum, fieldNum);
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<BankResPaymentInfo>(16);
        for (int i = 0; i < mfs.length; ++i) {
            String ACNO = mfs[i][1];
            String ACNAME = mfs[i][3];
            String AMT = mfs[i][5];
            String STAT = mfs[i][9];
            String ERR_MSG = mfs[i][10];
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(ACNO, ACNAME, AMT);
            bankResPaymentInfo.setBankStatus(STAT);
            bankResPaymentInfo.setBankMsg(ERR_MSG);
            if ("8".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
            } else if ("5".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
            } else if ("1".equals(STAT) || "3".equals(STAT)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUBMITED);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
        }
        MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
        matchPayStatusModel.setMatchRule("ACCOUNT_NAME_AMOUNT");
        matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
        List allPaymentInfo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo((String)paymentInfos.get(0).getBankBatchSeqID());
        return new EBBankPayResponse(CommonPayStatusMatchUtil.HandlePayStatus((MatchPayStatusModel)matchPayStatusModel, (List)allPaymentInfo));
    }

    private String pack200201(List<PaymentInfo> paymentInfos, String serial_no) {
        String tr_code = "200201";
        Element ap = Packer.createCommonHead((String)tr_code, (String)Sequence.genSequence(), (String)"0");
        Element body = ap.getChild("body");
        String date = paymentInfos.get(0).getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)date);
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serial_no);
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)paymentInfos.get(0).getBankBatchSeqId());
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return Common.createCommonMsg((String)xmlMsg);
    }

    private String[][] parseMFS(String content, int recordNum, int fieldNum) {
        String[] allRecord = StringUtils.split((String)content, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allRecord[i * fieldNum + j];
            }
        }
        return r2;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200201";
    }

    public String getBizDesc() {
        return null;
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg((String)super.recv(inputStream));
    }
}

