/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crcb.dc.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crcb.dc.helper.BankCode;
import kd.ebg.aqap.banks.crcb.dc.helper.JDOMHelper;
import kd.ebg.aqap.banks.crcb.dc.helper.SHA1Encrypt;
import kd.ebg.aqap.banks.crcb.dc.helper.SvsSign;
import kd.ebg.aqap.banks.crcb.dc.login.LoginImpl;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.output.XMLOutputter;

public class RequestPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(RequestPacker.class);

    public static String getLoginMessage() {
        String customerId = RequestContextUtils.getBankParameterValue((String)"cust_no");
        String pass = RequestContextUtils.getBankParameterValue((String)"ciph");
        String reqTime = String.valueOf(System.currentTimeMillis());
        String serialNo = Sequence.gen18Sequence();
        SHA1Encrypt encrytyp = new SHA1Encrypt();
        String newPwd = encrytyp.getDigestOfString((customerId + pass).getBytes());
        String header = "-1|CL0001|" + serialNo + "|" + reqTime + "|#";
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("userID", customerId);
        requestMap.put("userPWD", newPwd);
        String loginMessage = JDOMHelper.requestMessageFYIEncrypt(requestMap, "CL0001");
        String signData = "";
        try {
            signData = SvsSign.getInstance().signData(loginMessage);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u767b\u9646\u7b7e\u540d\u5931\u8d25", (String)"RequestPacker_0", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)signData)) {
            signData = "-1";
        }
        String requestData = JDOMHelper.requestHttpMessage(header, signData, loginMessage);
        return requestData;
    }

    public static String packBalanceMessage(BankAcnt acnts) {
        String header = RequestPacker.getHeader("CL0003");
        return RequestPacker.packBalance(acnts, header);
    }

    public static String packBalance(BankAcnt acnts, String header) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("I1ACNO", acnts.getAccNo());
        String reqMessage = JDOMHelper.requestMessageFYIEncrypt(requestMap, "CL0003");
        logger.info("reqMessage: " + reqMessage);
        try {
            String signData = SvsSign.getInstance().signData(reqMessage);
            if (!StringUtils.isEmpty((String)signData)) {
                String requestData = JDOMHelper.requestHttpMessage(header, signData, reqMessage);
                return requestData;
            }
        }
        catch (Exception e) {
            logger.info("\u6253\u5305\u5f53\u65e5\u4f59\u989d\u62a5\u6587\u5931\u8d25 ", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6253\u5305\u5f53\u65e5\u4f59\u989d\u62a5\u6587\u5931\u8d25\u3002", (String)"RequestPacker_1", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return "";
    }

    public static String getHeader(String transCode) {
        Map<String, Object> resLoginMap = LoginImpl.getInstance().login();
        if (resLoginMap != null && StringUtils.equals((String)"00000000", (String)(resLoginMap.get("retCode") == null ? "" : resLoginMap.get("retCode").toString()))) {
            String reqTime = String.valueOf(System.currentTimeMillis());
            String sessionId = resLoginMap.get("sessionId").toString();
            String serialNo = resLoginMap.get("serialNo").toString();
            String header = sessionId + "|" + transCode + "|" + serialNo + "|" + reqTime + "|#";
            return header;
        }
        logger.info("\u767b\u9646\u5931\u8d25\uff01");
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u767b\u9646\u5931\u8d25!", (String)"RequestPacker_2", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]));
    }

    public static String getHistoryBalanceMessage(BankBalanceRequest request) {
        String header = RequestPacker.getHeader("CL0013");
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("I1ACNO", request.getAcnt().getAccNo());
        requestMap.put("I1CYTP", request.getBankCurrency());
        requestMap.put("I1STDT", LocalDateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyyMMdd"));
        requestMap.put("I1EDDT", LocalDateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyyMMdd"));
        String reqMessage = JDOMHelper.requestMessageFYIEncrypt(requestMap, "CL0013");
        try {
            String signData = SvsSign.getInstance().signData(reqMessage);
            if (!StringUtils.isEmpty((String)signData)) {
                String requestData = JDOMHelper.requestHttpMessage(header, signData, reqMessage);
                logger.info("\u5386\u53f2\u4f59\u989d\u7b7e\u540d\u503c:" + requestData);
                return requestData;
            }
        }
        catch (Exception e) {
            logger.info("\u6253\u5305\u5386\u53f2\u4f59\u989d\u62a5\u6587\u5931\u8d25 ", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6253\u5305\u5386\u53f2\u4f59\u989d\u62a5\u6587\u5931\u8d25\u3002", (String)"RequestPacker_3", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return "";
    }

    public static String getDetailsMessage(BankDetailRequest rqst, int page, int size) {
        String transCode = "CL0004";
        String header = RequestPacker.getHeader(transCode);
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("I1ACNO", rqst.getAcnt().getAccNo());
        requestMap.put("I1CYTP", "");
        requestMap.put("I1STDT", LocalDateUtil.formatDate((LocalDate)rqst.getStartDate(), (String)"yyyyMMdd"));
        requestMap.put("I1EDDT", LocalDateUtil.formatDate((LocalDate)rqst.getEndDate(), (String)"yyyyMMdd"));
        requestMap.put("I1BGAT", "");
        requestMap.put("I1EDAT", "");
        requestMap.put("I1QYFG", "");
        int startTag = page * size + 1;
        requestMap.put("Num", startTag + "");
        requestMap.put("QryNum", size + "");
        String reqMessage = JDOMHelper.requestMessageFYIEncrypt(requestMap, transCode);
        try {
            String signData = SvsSign.getInstance().signData(reqMessage);
            if (!StringUtils.isEmpty((String)signData)) {
                String requestData = JDOMHelper.requestHttpMessage(header, signData, reqMessage);
                logger.info("\u4ea4\u6613\u660e\u7ec6\u7b7e\u540d\u503c:" + requestData);
                return requestData;
            }
        }
        catch (Exception e) {
            logger.info("\u6253\u5305\u4ea4\u6613\u660e\u7ec6\u62a5\u6587\u5931\u8d25 ", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u62a5\u6587\u6253\u5305\u5931\u8d25\u3002", (String)"RequestPacker_4", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return "";
    }

    private static boolean validConfig(String paramString1, String paramString2, String paramString3, String paramString6, String paramString7, String paramString8) {
        return !StringUtils.isEmpty((String)paramString1) && !StringUtils.isEmpty((String)paramString2) && !StringUtils.isEmpty((String)paramString3) && !StringUtils.isEmpty((String)paramString6) && !StringUtils.isEmpty((String)paramString7) && !StringUtils.isEmpty((String)paramString8);
    }

    public static String getPaySalaryMessage(PaymentInfo[] paymentInfoArray) {
        PaymentInfo paymentInfo = paymentInfoArray[0];
        String header = RequestPacker.getHeader(BankCode.PAY_FOR_SALARY_CODE);
        Element root = new Element("CQRCBBankData");
        Element orReq = JDomUtils.addChild((Element)root, (String)"opReq");
        Element ReqParam = JDomUtils.addChild((Element)orReq, (String)"ReqParam");
        BigDecimal totalAmt = new BigDecimal("0.00");
        JDomUtils.addChild((Element)ReqParam, (String)"I1QYLS", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)ReqParam, (String)"I1SMID", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"I1ATID", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"O1YWLX", (String)"101");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
        JDomUtils.addChild((Element)ReqParam, (String)"O1DFYF", (String)sdf.format(new Date()));
        JDomUtils.addChild((Element)ReqParam, (String)"O1FKAC", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"O1TRCT", (String)(paymentInfoArray.length + ""));
        if (StringUtils.isEmpty((String)paymentInfo.getExplanation())) {
            JDomUtils.addChild((Element)ReqParam, (String)"O1PCBZ", (String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"RequestPacker_6", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]));
        } else {
            JDomUtils.addChild((Element)ReqParam, (String)"O1PCBZ", (String)paymentInfo.getExplanation());
        }
        JDomUtils.addChild((Element)ReqParam, (String)"I1NBBH", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"O1FLAG", (String)"0");
        JDomUtils.addChild((Element)ReqParam, (String)"O1SHOW", (String)"0");
        JDomUtils.addChild((Element)ReqParam, (String)"O1TRAM", (String)(totalAmt + ""));
        JDomUtils.addChild((Element)ReqParam, (String)"IJYLX", (String)"1");
        Element listSet = JDomUtils.addChild((Element)ReqParam, (String)"LIST");
        for (PaymentInfo payment : paymentInfoArray) {
            Element reqParam = JDomUtils.addChild((Element)listSet, (String)"RECORD");
            JDomUtils.addChild((Element)reqParam, (String)"O2SKZH", (String)payment.getIncomeAccNo());
            JDomUtils.addChild((Element)reqParam, (String)"O2SKXM", (String)payment.getIncomeAccName());
            JDomUtils.addChild((Element)reqParam, (String)"O2JYJE", (String)(payment.getAmount() + ""));
            JDomUtils.addChild((Element)reqParam, (String)"O2JYBZ", (String)payment.getExplanation());
            totalAmt = totalAmt.add(payment.getAmount());
        }
        ReqParam.getChild("O1TRAM").setText(totalAmt + "");
        XMLOutputter out = new XMLOutputter();
        String xmlStr = out.outputString(ReqParam);
        String reqMessage = xmlStr = xmlStr.substring(xmlStr.indexOf("<ReqParam>"), xmlStr.indexOf("</ReqParam>") + "</ReqParam>".length());
        logger.info("\u539f\u59cb\u62a5\u6587" + reqMessage);
        String signData = "";
        try {
            if (BankCode.CRCB_REQUEST_MODE.startsWith("http")) {
                signData = SvsSign.getInstance().signData(reqMessage);
            }
            if (!StringUtils.isEmpty((String)signData)) {
                String requestData = JDOMHelper.requestHttpMessage(header, signData, reqMessage);
                logger.info("\u7b7e\u540d\u540e\u62a5\u6587" + reqMessage);
                return requestData;
            }
        }
        catch (Exception e) {
            logger.info("\u4ee3\u53d1\u5de5\u8d44\u7b7e\u540d\u5931\u8d25", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u7b7e\u540d\u5931\u8d25\u3002", (String)"RequestPacker_7", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return "-1";
    }

    public static String getQueryPaySalaryMessage(PaymentInfo[] paymentInfoArray) {
        PaymentInfo paymentInfo = paymentInfoArray[0];
        String reqMessage = "";
        String header = RequestPacker.getHeader(BankCode.QUERY_PAY_FOR_SALARY_CODE);
        Element root = new Element("CQRCBBankData");
        Element orReq = JDomUtils.addChild((Element)root, (String)"opReq");
        Element ReqParam = JDomUtils.addChild((Element)orReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"I1QYLS", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)ReqParam, (String)"O1FLAG", (String)"0");
        XMLOutputter out = new XMLOutputter();
        String xmlStr = out.outputString(ReqParam);
        reqMessage = xmlStr = xmlStr.substring(xmlStr.indexOf("<ReqParam>"), xmlStr.indexOf("</ReqParam>") + "</ReqParam>".length());
        String signData = "";
        try {
            signData = SvsSign.getInstance().signData(reqMessage);
            if (!StringUtils.isEmpty((String)signData)) {
                String requestData = JDOMHelper.requestHttpMessage(header, signData, reqMessage);
                logger.info("\u67e5\u8be2\u4ee3\u53d1\u4ed8\u6b3e\u7ed3\u679c\u7b7e\u540d\u503c:" + requestData);
                return requestData;
            }
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u4ee3\u53d1\u4ed8\u6b3e\u7ed3\u679c\u62a5\u6587\u7ec4\u88c5\u5931\u8d25", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4ee3\u53d1\u4ed8\u6b3e\u7ed3\u679c\u62a5\u6587\u7ec4\u88c5\u5931\u8d25\u3002", (String)"RequestPacker_8", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return "-1";
    }

    public static String getQueryPayMessage(PaymentInfo[] paymentArray) {
        String header = RequestPacker.getHeader(BankCode.TRANSFER_STATUS_CODE);
        PaymentInfo paymentInfo = paymentArray[0];
        HashMap<String, Object> requestMap = new HashMap<String, Object>(16);
        requestMap.put("I1QYLS", paymentInfo.getBankDetailSeqId());
        requestMap.put("I1TLSQ", "");
        String reqMessage = JDOMHelper.requestMessageFYIEncrypt(requestMap, BankCode.TRANSFER_STATUS_CODE);
        try {
            String signData = SvsSign.getInstance().signData(reqMessage);
            if (!StringUtils.isEmpty((String)signData)) {
                String requestData = JDOMHelper.requestHttpMessage(header, signData, reqMessage);
                logger.info("\u67e5\u8be2\u4ed8\u6b3e\u7ed3\u679c\u7b7e\u540d\u503c:" + requestData);
                return requestData;
            }
        }
        catch (Exception e) {
            logger.info("\u67e5\u8be2\u4ed8\u6b3e\u62a5\u6587\u7ec4\u88c5\u5931\u8d25", (Object)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u62a5\u6587\u7ec4\u88c5\u5931\u8d25\u3002", (String)"RequestPacker_9", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return "-1";
    }
}

