/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.crcb.dc.payment.individual;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.crcb.dc.helper.BankCode;
import kd.ebg.aqap.banks.crcb.dc.helper.JDOMHelper;
import kd.ebg.aqap.banks.crcb.dc.helper.RequestPacker;
import kd.ebg.aqap.banks.crcb.dc.helper.ResponseParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 200;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=UTF-8");
    }

    public String pack(BankPayRequest bankPayRequest) {
        return RequestPacker.getQueryPaySalaryMessage(bankPayRequest.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rps) {
        if (rps != null && !rps.isEmpty() && !rps.equals("-1")) {
            Map<String, Object> resBankMessage = JDOMHelper.getBodyData(rps);
            Map<String, Object> map = ResponseParser.submitQuerySalaryMessage(resBankMessage);
            ResponseParser.parserSalaryMessage(bankPayRequest.getPaymentInfoAsArray(), rps, map);
        } else {
            ResponseParser.parserSalaryMessage(bankPayRequest.getPaymentInfoAsArray(), "-1", new HashMap<String, Object>(1));
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return BankCode.QUERY_PAY_FOR_SALARY_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5bf9\u79c1\u4ed8\u6b3e", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-crcb-dc", (Object[])new Object[0]);
    }
}

