/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.api.payment.bulk;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbl.dc.HsblMetaDataImpl;
import kd.ebg.aqap.banks.hsbl.dc.service.api.HsblPgpHelper;
import kd.ebg.aqap.banks.hsbl.dc.service.utils.HSBL_DC_Utils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.HttpsConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.TcpConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class BulkQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(BulkQueryPayImpl.class);

    public IConnection getConnection(ConnectionFactory factory) {
        HashMap<String, String> httpHeaders = new HashMap<String, String>(16);
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("x-hsbc-client-id", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.clientId));
        httpHeaders.put("x-hsbc-client-secret", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.clientSecret));
        httpHeaders.put("x-hsbc-profile-id", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.profileId));
        String ip = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiIP);
        String port = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiPort);
        String protocol = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiProtocol);
        String uri = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.queryPayURI);
        String timeOut = RequestContextUtils.getBankParameterValue((String)"timeout");
        if ("http".equalsIgnoreCase(protocol)) {
            return new HttpConnection(ip, Integer.parseInt(port), uri, httpHeaders, Integer.parseInt(timeOut));
        }
        if ("tcp".equalsIgnoreCase(protocol)) {
            return new TcpConnection(ip, Integer.parseInt(port), Integer.parseInt(timeOut));
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return new HttpsConnection(ip, Integer.parseInt(port), uri, httpHeaders, Integer.parseInt(timeOut));
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5176\u4ed6\u901a\u8baf\u534f\u8bae\u3002", (String)"BulkQueryPayImpl_0", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element StatusEnquiry = JDomUtils.createRoot((String)"StatusEnquiry");
        String ProfileID = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.profileId);
        JDomUtils.addChild((Element)StatusEnquiry, (String)"ProfileID", (String)ProfileID);
        Element Key = JDomUtils.addChild((Element)StatusEnquiry, (String)"Key");
        String referenceId = PaymentInfoSysFiled.get((PaymentInfo)((PaymentInfo)paymentInfos.get(0)), (String)"hsbl_referenceId");
        if (StringUtils.isEmpty((String)referenceId)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u6d41\u6c34\u53f7ReferenceID\u4e3a\u7a7a\u3002", (String)"BulkQueryPayImpl_7", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)Key, (String)"ReferenceID", (String)referenceId);
        JDomUtils.addChild((Element)Key, (String)"MessageID", (String)"");
        JDomUtils.addChild((Element)Key, (String)"BatchID", (String)"");
        JDomUtils.addChild((Element)Key, (String)"TransactionID", (String)"");
        String xml = JDomUtils.root2String((Element)StatusEnquiry, (String)RequestContextUtils.getCharset());
        try {
            String base64 = HsblPgpHelper.encry(xml);
            JSONObject request = new JSONObject();
            request.put("paymentEnquiryBase64", (Object)base64);
            return request.toJSONString();
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"BulkQueryPayImpl_5", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        logger.infoFilerLog("\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
        JSONObject payRsp = JSONObject.parseObject((String)rspStr);
        String error = payRsp.getString("error");
        String description = payRsp.getString("description");
        if (!StringUtils.isEmpty((String)error)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"BulkQueryPayImpl_2", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)error, (String)description);
        } else {
            String origin;
            String base64 = payRsp.getString("responseBase64");
            try {
                origin = HsblPgpHelper.decry(base64);
                logger.info("\u89e3\u5bc6\u9a8c\u7b7e\u540e\u7684\u539f\u6587:" + origin);
            }
            catch (Throwable e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"BulkQueryPayImpl_6", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            Document document = JDomUtils.str2Doc((String)origin, (String)"UTF-8");
            Element root = document.getRootElement();
            Namespace ns = root.getNamespace();
            String uri = ns.getURI();
            Element cstmrPmtStsRpt = HSBL_DC_Utils.getElement((Element)root, (String)"CstmrPmtStsRpt", (Namespace)ns);
            if (cstmrPmtStsRpt == null) {
                ns = null;
                cstmrPmtStsRpt = HSBL_DC_Utils.getElement((Element)root, (String)"CstmrPmtStsRpt", (Namespace)ns);
            }
            Element OrgnlPmtInfAndSts = HSBL_DC_Utils.getElementNotNull((Element)cstmrPmtStsRpt, (String)"OrgnlPmtInfAndSts", (Namespace)ns);
            List list = OrgnlPmtInfAndSts.getChildren("TxInfAndSts", ns);
            for (Element ele : list) {
                PaymentInfo paymentInfo;
                String seqId = ele.getChildText("OrgnlEndToEndId", ns);
                String TxSts = ele.getChildText("TxSts", ns);
                Element StsRsnInf = ele.getChild("StsRsnInf", ns);
                String txMsg = TxSts;
                if (StsRsnInf != null) {
                    txMsg = StsRsnInf.getChildText("AddtlInf", ns);
                }
                if (StringUtils.isEmpty((String)seqId) || null == (paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)seqId))) continue;
                if ("RJCT".equals(TxSts)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)TxSts, (String)txMsg);
                    continue;
                }
                if ("PART".equals(TxSts) || "ACCP".equals(TxSts) || "ACTC".equals(TxSts) || "ACWC".equals(TxSts)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)"", (String)TxSts, (String)txMsg);
                    continue;
                }
                if ("ACSC".equals(TxSts) || "ACSP".equals(TxSts)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)TxSts, (String)txMsg);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)TxSts, (String)txMsg);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return "guoqiangyao";
    }

    public String getBizCode() {
        return HsblMetaDataImpl.queryPayURI;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ed8\u6b3e\u7ed3\u679c\u67e5\u8be2", (String)"BulkQueryPayImpl_4", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]);
    }

    public int getBatchSize() {
        return 10;
    }
}

