/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.api.payment.bulk;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbl.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbl.dc.HsblMetaDataImpl;
import kd.ebg.aqap.banks.hsbl.dc.service.api.HsblPgpHelper;
import kd.ebg.aqap.banks.hsbl.dc.service.api.payment.bulk.BulkQueryPayImpl;
import kd.ebg.aqap.banks.hsbl.dc.service.api.payment.single.PayPacker;
import kd.ebg.aqap.banks.hsbl.dc.service.api.payment.single.PayParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.HttpsConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.TcpConnection;
import kd.ebg.egf.common.log.EBGLogger;

public class PaymentImpl
extends AbstractPayImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public IConnection getConnection(ConnectionFactory factory) {
        HashMap<String, String> httpHeaders = new HashMap<String, String>(16);
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("x-hsbc-client-id", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.clientId));
        httpHeaders.put("x-hsbc-client-secret", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.clientSecret));
        httpHeaders.put("x-hsbc-profile-id", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.profileId));
        httpHeaders.put("x-payload-type", "pain.001.001.03");
        String ip = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiIP);
        String port = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiPort);
        String protocol = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiProtocol);
        String uri = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.batchPayURI);
        String timeOut = RequestContextUtils.getBankParameterValue((String)"timeout");
        if ("http".equalsIgnoreCase(protocol)) {
            return new HttpConnection(ip, Integer.parseInt(port), uri, httpHeaders, Integer.parseInt(timeOut));
        }
        if ("tcp".equalsIgnoreCase(protocol)) {
            return new TcpConnection(ip, Integer.parseInt(port), Integer.parseInt(timeOut));
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return new HttpsConnection(ip, Integer.parseInt(port), uri, httpHeaders, Integer.parseInt(timeOut));
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5176\u4ed6\u901a\u8baf\u534f\u8bae\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
    }

    public String getDeveloper() {
        return "guoqiangyao";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u652f\u4ed8", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]);
    }

    public int getBatchSize() {
        return 10;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return BulkQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] infos = bankPayRequest.getPaymentInfoAsArray();
        String bankMsg = PayPacker.packPayXmlPP(infos);
        try {
            String base64 = HsblPgpHelper.encry(bankMsg);
            JSONObject request = new JSONObject();
            request.put("paymentBase64", (Object)base64);
            return request.toJSONString();
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"PaymentImpl_14", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        PaymentInfo[] infos = bankPayRequest.getPaymentInfoAsArray();
        PayParser.parsePay(infos, rspStr);
        return new EBBankPayResponse(Arrays.asList(infos));
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "API".equalsIgnoreCase(BankBusinessConfig.getBorderPay()) && paymentInfo.getTotalCount() > 1;
    }
}

