/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.payment.oversea;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbl.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbl.dc.HsblMetaDataImpl;
import kd.ebg.aqap.banks.hsbl.dc.service.payment.oversea.utils.CacheManager;
import kd.ebg.aqap.banks.hsbl.dc.service.payment.oversea.utils.DbtrIdManager;
import kd.ebg.aqap.banks.hsbl.dc.service.utils.Helper;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HSBL_DC_CommonPacker {
    public static Element packPayXmlhead(PaymentInfo[] paymentInfos, Element CstmrCdtTrfInitn) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos[0];
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element GrpHdr = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"GrpHdr").setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"MsgId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)GrpHdr, (String)"CreDtTm", (String)HSBL_DC_CommonPacker.now()).setNamespace(ns1);
        String payProtocol = BankBusinessConfig.getPayProtocol();
        if (!StringUtils.isEmpty((String)payProtocol)) {
            Element Authstn = JDomUtils.addChild((Element)GrpHdr, (String)"Authstn").setNamespace(ns1);
            JDomUtils.addChild((Element)Authstn, (String)"Cd", (String)payProtocol).setNamespace(ns1);
        }
        Element NbOfTxs = JDomUtils.addChild((Element)GrpHdr, (String)"NbOfTxs").setNamespace(ns1);
        NbOfTxs.addContent(String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)GrpHdr, (String)"CtrlSum").setNamespace(ns1);
        Element InitgPty = JDomUtils.addChild((Element)GrpHdr, (String)"InitgPty").setNamespace(ns1);
        Element Id = JDomUtils.addChild((Element)InitgPty, (String)"Id").setNamespace(ns1);
        Element OrgId = JDomUtils.addChild((Element)Id, (String)"OrgId").setNamespace(ns1);
        Element Othr = JDomUtils.addChild((Element)OrgId, (String)"Othr").setNamespace(ns1);
        JDomUtils.addChild((Element)Othr, (String)"Id", (String)RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.connectCustomerID)).setNamespace(ns1);
        return GrpHdr;
    }

    public static Element packPayXmlPmtInfo(PaymentInfo[] paymentInfos, Element CstmrCdtTrfInitn) throws EBServiceException {
        String[] membids;
        PaymentInfo paymentInfo = paymentInfos[0];
        String serviceLevel = paymentInfo.getServiceLevel();
        String pmtMtd = paymentInfo.getPaymentMethod();
        String accNo = paymentInfo.getAccNo();
        String checkUsage = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"chequeUsage");
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Element PmtInf = JDomUtils.addChild((Element)CstmrCdtTrfInitn, (String)"PmtInf").setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtInfId", (String)paymentInfo.getBankBatchSeqId()).setNamespace(ns1);
        JDomUtils.addChild((Element)PmtInf, (String)"PmtMtd", (String)pmtMtd).setNamespace(ns1);
        Element PmtTpInf = JDomUtils.addChild((Element)PmtInf, (String)"PmtTpInf").setNamespace(ns1);
        if ("CHK".equalsIgnoreCase(pmtMtd)) {
            Element LclInstrm = JDomUtils.addChild((Element)PmtTpInf, (String)"LclInstrm").setNamespace(ns1);
            JDomUtils.addChild((Element)LclInstrm, (String)"Prtry", (String)checkUsage).setNamespace(ns1);
        } else {
            Element SvcLvl = JDomUtils.addChild((Element)PmtTpInf, (String)"SvcLvl").setNamespace(ns1);
            JDomUtils.addChild((Element)SvcLvl, (String)"Cd", (String)serviceLevel).setNamespace(ns1);
        }
        if (paymentInfo.getBookingTime() != null && paymentInfo.getBookingTime().isAfter(LocalDateTime.now())) {
            JDomUtils.addChild((Element)PmtInf, (String)"ReqdExctnDt", (String)DateTimeUtils.format((Date)Date.from(paymentInfo.getBookingTime().atZone(ZoneId.systemDefault()).toInstant()), (String)"yyyy-MM-dd")).setNamespace(ns1);
            PaymentUtil.setBookPayFlag((PaymentInfo[])paymentInfos);
        } else {
            JDomUtils.addChild((Element)PmtInf, (String)"ReqdExctnDt", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).setNamespace(ns1);
        }
        PaymentUtil.setBookPayFlag((PaymentInfo[])paymentInfos);
        Element Dbtr = JDomUtils.addChild((Element)PmtInf, (String)"Dbtr").setNamespace(ns1);
        JDomUtils.addChild((Element)Dbtr, (String)"Nm", (String)BankBusinessConfig.getPayCompanyName((String)accNo)).setNamespace(ns1);
        Element PstlAdr = JDomUtils.addChild((Element)Dbtr, (String)"PstlAdr").setNamespace(ns1);
        Helper.addressSplit((Element)PstlAdr, (String)BankBusinessConfig.getPayStreetName((String)accNo));
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getAccCountry());
        if (code == null) {
            code = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getAccCountry());
        }
        JDomUtils.addChild((Element)PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
        if ("TRF".equalsIgnoreCase(pmtMtd) && "NURG".equalsIgnoreCase(serviceLevel) && (membids = BankBusinessConfig.getDbtrId((String)accNo)) != null && membids.length > 0) {
            String dbtrid = DbtrIdManager.getInstance().getMembid(accNo);
            Element id = JDomUtils.addChild((Element)Dbtr, (String)"Id").setNamespace(ns1);
            Element orgId = JDomUtils.addChild((Element)id, (String)"OrgId").setNamespace(ns1);
            Element othr = JDomUtils.addChild((Element)orgId, (String)"Othr").setNamespace(ns1);
            LocalDateTime bookDate = paymentInfo.getBookingTime();
            Date date = Date.from(Instant.from(bookDate));
            String key = DateUtil.formatDate((Date)date) + dbtrid + accNo;
            if (CacheManager.getData((String)key) != null) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"DbtrId\u91cd\u590d\uff0c\u671f\u671b\u4ea4\u6613\u65e5\u671f\u4e0d\u80fd\u518d\u4f7f\u7528\u6b64\u8d26\u53f7\u4ed8\u6b3e(ACH)\u3002", (String)"HSBL_DC_CommonPacker_0", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
            }
            CacheManager.setData((String)key, (Object)dbtrid, (Date)date);
            PaymentUtil.setBookPayFlag((PaymentInfo[])paymentInfos);
            JDomUtils.addChild((Element)othr, (String)"Id", (String)dbtrid).setNamespace(ns1);
            Element SchmeNm = JDomUtils.addChild((Element)othr, (String)"SchmeNm").setNamespace(ns1);
            JDomUtils.addChild((Element)SchmeNm, (String)"Prtry", (String)"PSET").setNamespace(ns1);
        }
        Element DbtrAcct = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAcct").setNamespace(ns1);
        Element DbtrAcct_Id = JDomUtils.addChild((Element)DbtrAcct, (String)"Id").setNamespace(ns1);
        Element DbtrAcct_Othr = JDomUtils.addChild((Element)DbtrAcct_Id, (String)"Othr").setNamespace(ns1);
        JDomUtils.addChild((Element)DbtrAcct_Othr, (String)"Id", (String)accNo).setNamespace(ns1);
        JDomUtils.addChild((Element)DbtrAcct, (String)"Ccy", (String)paymentInfo.getCurrency()).setNamespace(ns1);
        Element DbtrAgt = JDomUtils.addChild((Element)PmtInf, (String)"DbtrAgt").setNamespace(ns1);
        Element FinInstnId = JDomUtils.addChild((Element)DbtrAgt, (String)"FinInstnId").setNamespace(ns1);
        JDomUtils.addChild((Element)FinInstnId, (String)"BIC", (String)BankBusinessConfig.getBicCode((String)accNo)).setNamespace(ns1);
        JDomUtils.addChild((Element)FinInstnId, (String)"Nm", (String)BankBusinessConfig.getBankName((String)accNo)).setNamespace(ns1);
        Element FinInstnId_PstlAdr = JDomUtils.addChild((Element)FinInstnId, (String)"PstlAdr").setNamespace(ns1);
        JDomUtils.addChild((Element)FinInstnId_PstlAdr, (String)"Ctry", (String)BankBusinessConfig.getBankCity((String)accNo)).setNamespace(ns1);
        return PmtInf;
    }

    private static String now() {
        return DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss").replace(' ', 'T');
    }
}

