/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.smbcn.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.smbcn.dc.util.PackerCommon;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final Logger logger = LoggerFactory.getLogger(DetailImpl.class);

    public EBBankDetailResponse detail(BankDetailRequest request) {
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        int differDays = (int)request.getStartDate().until(request.getEndDate(), ChronoUnit.MONTHS);
        if (differDays > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u8d77\u59cb\u65e5\u671f\u533a\u95f4\u4e0d\u80fd\u5927\u4e8e\u4e00\u4e2a\u6708\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]));
        }
        List<DetailInfo> detailInfos = this.processDetail(request);
        return new EBBankDetailResponse(detailInfos);
    }

    private List<DetailInfo> processDetail(BankDetailRequest request) {
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(1);
        this.setCurrentPage("");
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse response = this.process(request);
            if (!Objects.nonNull(response) || !Objects.nonNull(response.getDetails())) continue;
            detailInfos.addAll(response.getDetails());
        }
        return detailInfos;
    }

    public String pack(BankDetailRequest request) {
        Element root = new Element("h2h");
        Element req = PackerCommon.getBaseElement((Element)root, (String)"h2h.001.003", (String)request.getAcnt().getAccNo(), (String)request.getBankCurrency());
        JDomUtils.addChild((Element)req, (String)"beginDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)req, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        JDomUtils.addChild((Element)req, (String)"sortFlag", (String)"0");
        JDomUtils.addChild((Element)req, (String)"pageFlag", (String)this.getCurrentPage());
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return RspMsg;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        EBBankDetailResponse detailResponse = new EBBankDetailResponse();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element respInfo = JDomUtils.getChildElement((Element)root, (String)"respInfo");
        String acceptFlag = JDomUtils.getChildText((Element)respInfo, (String)"acceptFlag");
        String respCode = JDomUtils.getChildText((Element)respInfo, (String)"respCode");
        String respMsg = JDomUtils.getChildText((Element)respInfo, (String)"respMsg");
        if ("-1".equals(acceptFlag)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5931\u8d25\uff0c\u8fd4\u56de\u7801\u4e3a\uff1a%1$s,\u8fd4\u56de\u4fe1\u606f\uff1a%2$s", (String)"DetailImpl_1", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]), respCode, respMsg));
        }
        Element resp = JDomUtils.getChildElement((Element)root, (String)"resp");
        Element accPro = JDomUtils.getChildElement((Element)resp, (String)"accPro");
        String Account_num = JDomUtils.getChildText((Element)accPro, (String)"accNo");
        if (Account_num == null || !request.getAcnt().getAccNo().equals(Account_num)) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u67e5\u8be2\u7684\u8d26\u6237%1$s\u548c\u8fd4\u56de\u7ed3\u679c\u7684\u8d26\u6237%2$s\u4e0d\u4e00\u81f4\u3002", (String)"DetailImpl_2", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]), request.getAcnt().getAccNo(), Account_num);
            logger.error(resMsg);
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        String statusFlag = JDomUtils.getChildText((Element)resp, (String)"statusFlag");
        respCode = JDomUtils.getChildText((Element)resp, (String)"respCode");
        respMsg = JDomUtils.getChildText((Element)resp, (String)"respMsg");
        if (!"1".equals(statusFlag)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u5931\u8d25\uff0c\u8fd4\u56de\u7801\u4e3a\uff1a%1$s,\u8fd4\u56de\u4fe1\u606f\uff1a%2$s", (String)"DetailImpl_1", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]), respCode, respMsg));
        }
        List row = resp.getChildren("row");
        if (row == null || row.size() < 1) {
            detailResponse.setDetails(new ArrayList());
            this.setCurrentPage("");
            this.setLastPage(true);
            return detailResponse;
        }
        String pageFlag = JDomUtils.getChildText((Element)resp, (String)"pageFlag");
        if (StringUtils.isEmpty((String)pageFlag)) {
            this.setLastPage(true);
        } else {
            this.setCurrentPage(pageFlag);
        }
        ArrayList<DetailInfo> totalList = new ArrayList<DetailInfo>(1);
        for (int i = 0; i < row.size(); ++i) {
            Element element = (Element)row.get(i);
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(request.getBankCurrency());
            detail.setOppAccNo(element.getChildTextTrim("opAccNo"));
            detail.setOppAccName(element.getChildTextTrim("opAccName"));
            detail.setOppBankName(element.getChildTextTrim("opBankName"));
            detail.setAccName(request.getAcnt().getAccName());
            detail.setAccNo(request.getAcnt().getAccNo());
            String transferDate = element.getChildTextTrim("date");
            detail.setTransDate(LocalDate.parse(transferDate, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            detail.setTransTime(LocalDateTime.parse(transferDate + " 00:00:00", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            BigDecimal amount = new BigDecimal(element.getChildTextTrim("amount"));
            String dcFlag = element.getChildTextTrim("dcFlag");
            if (dcFlag.equalsIgnoreCase("D")) {
                detail.setDebitAmount(amount);
                detail.setCreditAmount(new BigDecimal(0));
            } else if (dcFlag.equalsIgnoreCase("C")) {
                detail.setDebitAmount(new BigDecimal(0));
                detail.setCreditAmount(amount);
            }
            detail.setExplanation(element.getChildTextTrim("remarks"));
            detail.setBankDetailNo(element.getChildTextTrim("corpSerial"));
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(element);
            if (StringUtils.isNotEmpty((String)element.getChildTextTrim("balance"))) {
                detail.setBalance(new BigDecimal(element.getChildTextTrim("balance")));
            }
            detail.setJsonMap(jsonStr);
            totalList.add(detail);
        }
        detailResponse.setDetails(totalList);
        return detailResponse;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "h2h.001.003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_3", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]);
    }

    public EBBankDetailResponse process(BankDetailRequest request) {
        try {
            return super.process(request);
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u660e\u7ec6\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-smbcn-dc", (Object[])new Object[0]), e.getMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/corpfe/H2HService/SC_I";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=GBK");
        super.configFactory(factory);
    }
}

