/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.szsrcb.cmp.services.detail;

import com.google.common.collect.Maps;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.szsrcb.cmp.services.Common;
import kd.ebg.aqap.banks.szsrcb.cmp.services.Packer;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public String pack(BankDetailRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "03020101A0007";
        Element ap = Packer.createCommonHead((String)tr_code, (String)req_no, (String)"0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"currency", (String)rqst.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"startDate", (String)LocalDateUtil.formatDate((LocalDate)rqst.getStartDate()));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)LocalDateUtil.formatDate((LocalDate)rqst.getEndDate()));
        JDomUtils.addChild((Element)body, (String)"pager", (String)"");
        JDomUtils.addChild((Element)body, (String)"start", (String)"");
        JDomUtils.addChild((Element)body, (String)"size", (String)"9999");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return Common.createCommonMsg((String)xmlMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        Element ap = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse response = Common.parseBankResponse((Element)head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element array = body.getChild("array");
        List list = array.getChildren("dto");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        if (list != null && list.size() > 0) {
            for (Element dto : list) {
                DetailInfo detail = new DetailInfo();
                detail.setCurrency(dto.getChildText("currency"));
                String acctNo = dto.getChildTextTrim("acctNo");
                String hostSerialNo = dto.getChildTextTrim("hostSerialNo");
                detail.setAccNo(acctNo);
                detail.setAccName(rqst.getAcnt().getAccName());
                detail.setOppAccNo(dto.getChildText("oppAcctNo"));
                detail.setOppAccName(dto.getChildText("oppAcctName"));
                detail.setOppBankName(dto.getChildText("oppBankName"));
                String balance = dto.getChildText("balance");
                if (!StringUtils.isEmpty((String)balance)) {
                    detail.setBalance(new BigDecimal(balance));
                }
                String date = dto.getChildText("trDate");
                detail.setTransDate(LocalDateUtil.parserDate((String)date));
                String time = dto.getChildText("trTime");
                detail.setTransTime(LocalDateTime.parse(date + time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                String amt = dto.getChildText("amt");
                String drcrFlag = dto.getChildText("drcrFlag");
                if ("C".equals(drcrFlag)) {
                    detail.setCreditAmount(new BigDecimal(amt));
                    detail.setDebitAmount(ParserUtils.ZERO);
                } else if ("D".equals(drcrFlag)) {
                    detail.setCreditAmount(ParserUtils.ZERO);
                    detail.setDebitAmount(new BigDecimal(amt));
                } else {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4e86\u672a\u77e5\u7684\u501f\u8d37\u6807\u5fd7\uff1a%s\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-szsrcb-cmp", (Object[])new Object[0]), drcrFlag));
                }
                detail.setExplanation(dto.getChildText("summary"));
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(dto);
                detail.setJsonMap(jsonStr);
                detail.setBankDetailNo(hostSerialNo);
                String receiptNo = MatchRule.getInstance().getReceiptNo(rqst.getAcnt().getAccNo(), date, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                details.add(detail);
            }
        }
        return new EBBankDetailResponse(details);
    }

    public boolean isSupportPage() {
        return false;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "03020101A0007";
    }

    public String getBizDesc() {
        return null;
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg((String)super.recv(inputStream));
    }
}

