/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.hk.service.balance;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.hk.service.MessageUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SY0002
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        Element root = MessageUtils.packRoot(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cus_ac", (String)((BankAcnt)bankBalanceRequest.getBankAcntList().get(0)).getAccNo());
        JDomUtils.addChild((Element)body, (String)"ccy", (String)bankBalanceRequest.getBankCurrency());
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse bankResponse = MessageUtils.parseRoot(root);
        MessageUtils.checkResponseCode(bankResponse, "0000");
        Element body = root.getChild("body");
        String cus_ac = JDomUtils.getChildText((Element)body, (String)"cus_ac");
        List mdfm78Group1 = body.getChildren("mdfm78_group1");
        if (CollectionUtil.isEmpty((Collection)mdfm78Group1)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u4f59\u989d\u4fe1\u606f\u3002", (String)"SY0002_0", (String)"ebg-aqap-banks-bocom-hk", (Object[])new Object[0]));
        }
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(2);
        for (Element mm : mdfm78Group1) {
            String ccy = mm.getChildText("ccy");
            String ac_bal = mm.getChildText("ac_bal");
            String ava_bal = mm.getChildText("ava_bal");
            BalanceInfo balanceInfo = new BalanceInfo();
            this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), cus_ac);
            this.setCurrentBalance(balanceInfo, ac_bal);
            this.setAvailableBalance(balanceInfo, ava_bal);
            this.setBankCurrency(balanceInfo, ccy);
            this.setBalanceDate(balanceInfo, LocalDate.now());
            balanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "SY0002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u672c\u884cSD/DD/TD\u8d26\u6237\u8d44\u6599\u67e5\u8be2", (String)"SY0002_1", (String)"ebg-aqap-banks-bocom-hk", (Object[])new Object[0]);
    }
}

