/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bocom.hk.service.detail;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bocom.hk.service.MessageUtils;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SY0001
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(SY0001.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = MessageUtils.packRoot(this.getBizCode());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cus_ac", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"ccy", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"inq_sdt", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)body, (String)"inq_edt", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        String currentPage = this.getCurrentPage();
        if ("0".equalsIgnoreCase(currentPage)) {
            this.setCurrentPage("1");
        }
        JDomUtils.addChild((Element)body, (String)"page", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)body, (String)"pageNum", (String)"15");
        String ovl_end_key = RequestContextUtils.getRunningParam((String)"ovl_end_key");
        if (StringUtils.isEmpty((String)ovl_end_key)) {
            ovl_end_key = "";
        }
        JDomUtils.addChild((Element)body, (String)"ovl_end_key", (String)ovl_end_key);
        return JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse bankResponse = MessageUtils.parseRoot(root);
        MessageUtils.checkResponseCode(bankResponse, "0000");
        Element body = root.getChild("body");
        List cbf802Group1 = body.getChildren("cbf802_group1");
        if (CollectionUtil.isEmpty((Collection)cbf802Group1)) {
            new EBBankDetailResponse((List)Lists.newArrayList());
        }
        String end_flg = body.getChildText("end_flg");
        String ovl_end_key = body.getChildText("ovl_end_key");
        if ("N".equalsIgnoreCase(end_flg)) {
            this.setLastPage(false);
            String currentPage = this.getCurrentPage();
            int page = Integer.parseInt(currentPage);
            this.setCurrentPage(page + 1);
            RequestContextUtils.setRunningParam((String)"ovl_end_key", (String)ovl_end_key);
        }
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(8);
        if (cbf802Group1.size() < 15) {
            this.setLastPage(true);
        }
        for (int i = 0; i < cbf802Group1.size(); ++i) {
            Element cbf = (Element)cbf802Group1.get(i);
            try {
                DetailInfo detailInfo = new DetailInfo();
                String cus_ac = cbf.getChildText("cus_ac");
                String seq_9 = cbf.getChildText("seq_9");
                String ccy = cbf.getChildText("ccy");
                String dc_flg = cbf.getChildText("dc_flg");
                String txn_dte = cbf.getChildText("ac_dte");
                String txn_tme = "";
                String amt = cbf.getChildText("vch_cam");
                String opp_ac = cbf.getChildText("opp_ac");
                String opp_ac_nme = cbf.getChildText("opp_ac_nme");
                String opp_bnk_nme = cbf.getChildText("opp_bnk_nme");
                String explanation = cbf.getChildText("vch_mmo");
                detailInfo.setAccNo(cus_ac);
                if ("D".equalsIgnoreCase(dc_flg)) {
                    detailInfo.setDebitAmount(new BigDecimal(amt));
                    detailInfo.setCreditAmount(BigDecimal.ZERO);
                } else if ("C".equalsIgnoreCase(dc_flg)) {
                    detailInfo.setCreditAmount(new BigDecimal(amt));
                    detailInfo.setDebitAmount(BigDecimal.ZERO);
                } else {
                    logger.info("\u501f\u8d37\u6807\u8bc6\u6709\u8bef");
                    continue;
                }
                detailInfo.setCurrency(ccy);
                if (StringUtils.isEmpty((String)txn_tme)) {
                    txn_tme = "000000";
                }
                LocalDateTime transDateTime = LocalDateTime.parse(txn_dte + txn_tme, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                detailInfo.setTransTime(transDateTime);
                detailInfo.setTransDate(transDateTime.toLocalDate());
                detailInfo.setOppAccNo(opp_ac);
                detailInfo.setOppAccName(opp_ac_nme);
                detailInfo.setOppBankName(opp_bnk_nme);
                detailInfo.setExplanation(explanation);
                String json = MatchRule.getInstance().getDetailJsonWithStructuredData(cbf);
                detailInfo.setJsonMap(json);
                detailInfo.setBankDetailNo(seq_9);
                detailInfos.add(detailInfo);
                continue;
            }
            catch (Exception e) {
                logger.info("\u7b2c{}\u6761\u660e\u7ec6\u89e3\u6790\u5f02\u5e38\uff1a{}", new Object[]{i, e.getMessage()});
            }
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "SY0001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u4ea4\u6613\u8bb0\u5f55", (String)"SY0001_0", (String)"ebg-aqap-banks-bocom-hk", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

