/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.constants.CMBReturnFlgState;
import kd.ebg.aqap.banks.cmb.dc.service.CMBEBBankResponse;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.banks.cmb.dc.service.payment.CommonQueryPayImpl;
import kd.ebg.aqap.banks.cmb.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CMB_DC_QueryPayParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CMB_DC_QueryPayParser.class);

    public static void parseQueryBatchPay(List<PaymentInfo> paymentInfos, String rspStr) {
        ArrayList<PaymentInfo> payFailList = new ArrayList<PaymentInfo>(16);
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse response = CMB_DC_Parser.parseINFO((Element)root);
        if ("0".equalsIgnoreCase(response.getResponseCode())) {
            List ntagplstz1 = root.getChildren("NTSTLLSTZ");
            if (null != ntagplstz1 && ntagplstz1.size() > 0) {
                Map<String, BankResponse> detailStatusMap = CMB_DC_QueryPayParser.getDetailStatus(ntagplstz1);
                for (PaymentInfo info : paymentInfos) {
                    String key = PaymentUtil.getYurRef(info);
                    BankResponse bankResponse = detailStatusMap.get(key);
                    if (null == bankResponse) {
                        EBGBusinessUtils.setPaymentWithoutStauts((PaymentInfo)info, (String)response.getResponseCode(), (String)response.getResponseMessage());
                        continue;
                    }
                    if ("FIN".equalsIgnoreCase(bankResponse.getResponseCode())) {
                        String msg = (String)CMBReturnFlgState.flagMaps.get(bankResponse.getResponseMessage());
                        if ("S".equalsIgnoreCase(bankResponse.getResponseMessage())) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CMB_DC_QueryPayParser_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)((String)CMBReturnFlgState.flagMaps.get(bankResponse.getResponseMessage())));
                            continue;
                        }
                        if ("F".equalsIgnoreCase(bankResponse.getResponseMessage()) || "R".equalsIgnoreCase(bankResponse.getResponseMessage())) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CMB_DC_QueryPayParser_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)((String)CMBReturnFlgState.flagMaps.get(bankResponse.getResponseMessage())));
                            payFailList.add(info);
                            continue;
                        }
                        if ("B".equals(bankResponse.getResponseMessage())) {
                            String type = BankBusinessConfig.getRefundState();
                            if ("1".equals(type)) {
                                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u9000\u7968", (String)"CMB_DC_QueryPayParser_3", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)((String)CMBReturnFlgState.flagMaps.get(bankResponse.getResponseMessage())));
                            } else if ("2".equals(type)) {
                                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u9000\u7968", (String)"CMB_DC_QueryPayParser_3", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)((String)CMBReturnFlgState.flagMaps.get(bankResponse.getResponseMessage())));
                            } else if ("3".equals(type)) {
                                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u9000\u7968", (String)"CMB_DC_QueryPayParser_3", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)((String)CMBReturnFlgState.flagMaps.get(bankResponse.getResponseMessage())));
                            }
                            PaymentInfoSysFiled.set((PaymentInfo)info, (String)"refund", (String)info.getBankDetailSeqId());
                            continue;
                        }
                        String bankMessage = (String)CMBReturnFlgState.flagMaps.get(bankResponse.getResponseMessage());
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)(bankMessage == null ? bankResponse.getResponseMessage() : bankMessage));
                        continue;
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                }
            } else {
                EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u5177\u4f53\u4fe1\u606f\u3002", (String)"CMB_DC_QueryPayParser_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002 ", (String)"CMB_DC_QueryPayParser_4", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        try {
            if (BankBusinessConfig.isBatchQueryInterface()) {
                Iterator iterator = payFailList.iterator();
                while (iterator.hasNext()) {
                    PaymentInfo paymentInfo = (PaymentInfo)iterator.next();
                    String reqno = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"REQNUBR");
                    if (!StringUtils.isEmpty((String)reqno)) continue;
                    iterator.remove();
                }
                if (payFailList.size() > 0) {
                    CommonQueryPayImpl commonQueryPay = new CommonQueryPayImpl();
                    BankPayRequest bankPayRequest = new BankPayRequest();
                    bankPayRequest.setPaymentInfos(payFailList);
                    commonQueryPay.doBiz(bankPayRequest);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5931\u8d25\u539f\u56e0\u5f02\u5e38===" + e.getMessage());
        }
    }

    private static Map<String, BankResponse> getDetailStatus(List<Element> ntagprtnzs) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (Element node : ntagprtnzs) {
            String yurref = JDomUtils.getChildText((Element)node, (String)"YURREF");
            String reqsts = JDomUtils.getChildText((Element)node, (String)"REQSTS");
            String rtnflg = JDomUtils.getChildText((Element)node, (String)"RTNFLG");
            BankResponse response = new BankResponse();
            response.setResponseCode(reqsts);
            response.setResponseMessage(rtnflg);
            result.put(yurref, response);
        }
        return result;
    }

    public static void parseQueryIndividualPay(List<PaymentInfo> paymentInfos, String rspStr) {
        PaymentInfo paymentInfo = paymentInfos.get(0);
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse response = CMB_DC_Parser.parseINFO((Element)root);
        if ("0".equalsIgnoreCase(response.getResponseCode())) {
            List ntagcinqz1 = root.getChildren("NTAGCINQZ");
            if (ntagcinqz1 == null || ntagcinqz1.size() == 0) {
                EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u5177\u4f53\u4fe1\u606f\u3002", (String)"CMB_DC_QueryPayParser_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            } else {
                String key;
                Map<String, CMBEBBankResponse> detailStatusMap = CMB_DC_QueryPayParser.getSalaryDetailStatus(ntagcinqz1);
                CMBEBBankResponse bankResponse = detailStatusMap.get(key = "pay_for_salary".equals(paymentInfo.getSubBizType()) && paymentInfo.is2Merge() || BankBusinessConfig.isAgentFailStatusToSuccess() ? PaymentUtil.getYurRefDefaultBankBatchSeqID(paymentInfo) : PaymentUtil.getYurRef(paymentInfo));
                if (null == bankResponse) {
                    EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u65e0\u6cd5\u4ece\u7ed3\u679c\u96c6\u4e2d\u5339\u914d\u8be5\u7b14\u660e\u7ec6\u72b6\u6001\u3002", (String)"CMB_DC_QueryPayParser_5", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                } else if ("FIN".equalsIgnoreCase(bankResponse.getReqSta())) {
                    if ("S".equalsIgnoreCase(bankResponse.getRtnFlg())) {
                        EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)bankResponse.getResponseMessage());
                        PaymentInfoSysFiled.set(paymentInfos, (String)"REQNUBR", (String)bankResponse.getFlowNum());
                    } else if ("F".equalsIgnoreCase(bankResponse.getRtnFlg())) {
                        if ("1".equals(BankBusinessConfig.getPaymentDetail())) {
                            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)bankResponse.getResponseMessage());
                            PaymentInfoSysFiled.set(paymentInfos, (String)"REQNUBR", (String)bankResponse.getFlowNum());
                        } else {
                            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CMB_DC_QueryPayParser_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)bankResponse.getResponseMessage());
                        }
                    } else {
                        String bankMessage = (String)CMBReturnFlgState.flagMaps.get(bankResponse.getRtnFlg());
                        EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"CMB_DC_QueryPayParser_6", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)(bankResponse.getResponseCode() + bankResponse.getResponseMessage()), (String)(bankMessage == null ? bankResponse.getResponseMessage() : bankMessage));
                    }
                } else {
                    EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)response.getResponseCode(), (String)bankResponse.getResponseMessage());
                }
            }
        } else {
            EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002 ", (String)"CMB_DC_QueryPayParser_4", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
    }

    private static Map<String, CMBEBBankResponse> getSalaryDetailStatus(List<Element> ntagprtnzs) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (Element node : ntagprtnzs) {
            String yurref = JDomUtils.getChildText((Element)node, (String)"YURREF");
            String reqsts = JDomUtils.getChildText((Element)node, (String)"REQSTA");
            String rtnflg = JDomUtils.getChildText((Element)node, (String)"RTNFLG");
            String flowNum = JDomUtils.getChildText((Element)node, (String)"REQNBR");
            String errCod = JDomUtils.getChildText((Element)node, (String)"ERRCOD");
            String errDsp = JDomUtils.getChildText((Element)node, (String)"ERRDSP");
            CMBEBBankResponse response = new CMBEBBankResponse();
            response.setReqSta(reqsts);
            response.setRtnFlg(rtnflg);
            response.setFlowNum(flowNum);
            response.setResponseCode(errCod);
            response.setResponseMessage(errDsp);
            result.put(yurref, response);
        }
        return result;
    }

    public static void parseQueryIndividualDetail(List<PaymentInfo> paymentInfos, String rspStr) {
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse response = CMB_DC_Parser.parseINFO((Element)root);
        if ("0".equalsIgnoreCase(response.getResponseCode())) {
            List ntqatdqyz = root.getChildren("NTQATDQYZ");
            if (null != ntqatdqyz && ntqatdqyz.size() > 0) {
                Map<String, CMBEBBankResponse> detailStatusMap = CMB_DC_QueryPayParser.getIndividualDetailStatus(ntqatdqyz);
                for (PaymentInfo info : paymentInfos) {
                    String key = info.getIncomeAccNo() + info.getIncomeAccName() + info.getAmount().toString();
                    CMBEBBankResponse bankResponse = detailStatusMap.get(key);
                    if (null == bankResponse) continue;
                    if ("S".equalsIgnoreCase(bankResponse.getResponseCode())) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CMB_DC_QueryPayParser_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u6210\u529f", (String)"CMB_DC_QueryPayParser_7", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseMessage());
                        continue;
                    }
                    if ("F".equals(bankResponse.getResponseCode())) {
                        if (BankBusinessConfig.isAgentFailStatusToSuccess()) {
                            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CMB_DC_QueryPayParser_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)String.format(ResManager.loadKDString((String)"%s\uff0c\u94f6\u4f01\u5c06\u4ea4\u6613\u5931\u8d25\u4fee\u6539\u4e3a\u4ea4\u6613\u6210\u529f\u3002", (String)"CMB_DC_QueryPayParser_10", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
                            PaymentInfoSysFiled.set((PaymentInfo)info, (String)"refund", (String)info.getBankDetailSeqId());
                            continue;
                        }
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CMB_DC_QueryPayParser_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)bankResponse.getResponseMessage());
                        continue;
                    }
                    if ("I".equalsIgnoreCase(bankResponse.getResponseCode())) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)bankResponse.getResponseMessage());
                        continue;
                    }
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)("C".equals(bankResponse.getResponseCode()) ? ResManager.loadKDString((String)"\u64a4\u9500", (String)"CMB_DC_QueryPayParser_9", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]) : bankResponse.getResponseMessage()));
                }
            } else {
                EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u5177\u4f53\u4fe1\u606f\u3002", (String)"CMB_DC_QueryPayParser_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002 ", (String)"CMB_DC_QueryPayParser_4", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
    }

    private static Map<String, CMBEBBankResponse> getIndividualDetailStatus(List<Element> ntagprtnzs) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (Element node : ntagprtnzs) {
            String accNbr = JDomUtils.getChildText((Element)node, (String)"ACCNBR");
            String cltNam = JDomUtils.getChildText((Element)node, (String)"CLTNAM");
            String trsAmt = JDomUtils.getChildText((Element)node, (String)"TRSAMT");
            String key = accNbr + cltNam + trsAmt;
            String stsCod = JDomUtils.getChildText((Element)node, (String)"STSCOD");
            String errDsp = JDomUtils.getChildText((Element)node, (String)"ERRDSP");
            CMBEBBankResponse response = new CMBEBBankResponse();
            response.setResponseCode(stsCod);
            response.setResponseMessage(errDsp);
            result.put(key, response);
        }
        return result;
    }

    public static void parseQueryBatchIndividualDetail(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse response = CMB_DC_Parser.parseINFO((Element)root);
        if ("0".equalsIgnoreCase(response.getResponseCode())) {
            List ntagcdtlys = root.getChildren("NTAGCDTLY1");
            if (ntagcdtlys.size() < 1 || ntagcdtlys == null) {
                EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u6ca1\u6709\u8fd4\u56de\u5177\u4f53\u4fe1\u606f\u3002", (String)"CMB_DC_QueryPayParser_0", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
            HashMap<String, PaymentInfo> paymentInfoMap = new HashMap<String, PaymentInfo>();
            for (PaymentInfo info : paymentInfos) {
                String key = String.format("%08d", Integer.parseInt(info.getBankSerialNo()));
                paymentInfoMap.put(key, info);
            }
            for (Element node : ntagcdtlys) {
                String trxseq = JDomUtils.getChildText((Element)node, (String)"TRXSEQ");
                String reqsts = JDomUtils.getChildText((Element)node, (String)"STSCOD");
                String rtnflg = JDomUtils.getChildText((Element)node, (String)"ERRDSP");
                String accNo = JDomUtils.getChildText((Element)node, (String)"ACCNBR");
                String accName = JDomUtils.getChildText((Element)node, (String)"ACCNAM");
                String amount = JDomUtils.getChildText((Element)node, (String)"TRSAMT");
                PaymentInfo info = (PaymentInfo)paymentInfoMap.get(trxseq);
                if (info == null) continue;
                if ("S".equalsIgnoreCase(reqsts)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)reqsts, (String)rtnflg);
                } else if ("E".equalsIgnoreCase(reqsts)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)reqsts, (String)rtnflg);
                } else if ("A".equalsIgnoreCase(reqsts) || "I".equalsIgnoreCase(reqsts)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)reqsts, (String)rtnflg);
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)reqsts, (String)rtnflg);
                }
                CommonPayStatusMatchUtil.checkPayStatusWith3Factor((PaymentInfo)info, (String)accNo, (String)accName, (String)amount);
            }
        }
    }
}

