/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.dc.service.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Packer;
import kd.ebg.aqap.banks.cmb.dc.service.CMB_DC_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CashPoolHisDetailImpl
extends AbstractDetailImpl
implements IHisDetail {
    EBGLogger log = EBGLogger.getInstance().getLogger(CashPoolHisDetailImpl.class);

    public String pack(BankDetailRequest request) {
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        String crpseq = BankBusinessConfig.getCRPSEQ(accNo);
        String crscod = BankBusinessConfig.getCRSCOD(accNo);
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        Element root = CMB_DC_Packer.packRoot("SDKNTCASTRS");
        Element nttrxstry = JDomUtils.addChild((Element)root, (String)"NTTRXSTRY");
        JDomUtils.addChild((Element)nttrxstry, (String)"BEGDAT", (String)DateTimeFormatter.ofPattern("yyyyMMdd").format(startDate));
        JDomUtils.addChild((Element)nttrxstry, (String)"ENDDAT", (String)DateTimeFormatter.ofPattern("yyyyMMdd").format(endDate));
        JDomUtils.addChild((Element)nttrxstry, (String)"CRPSEQ", (String)crpseq);
        JDomUtils.addChild((Element)nttrxstry, (String)"CRSCOD", (String)crscod);
        JDomUtils.addChild((Element)nttrxstry, (String)"EACNBR", (String)accNo);
        JDomUtils.addChild((Element)nttrxstry, (String)"TRXTYP", (String)"3");
        JDomUtils.addChild((Element)nttrxstry, (String)"BOKDIR", (String)"0");
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse headRsp = CMB_DC_Parser.parseINFO((Element)root);
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25 :%s\u3002", (String)"CashPoolHisDetailImpl_8", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{headRsp.getResponseCode(), headRsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element info = root.getChild("INFO");
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(1);
        List nttrxstrzs = root.getChildren("NTTRXSTRZ");
        for (int i = 0; i < nttrxstrzs.size(); ++i) {
            Element nttrxstrz = (Element)nttrxstrzs.get(i);
            DetailInfo detail = this.parseEach4TransDetailInUpAcntHistory(nttrxstrz, request.getAcnt());
            if (detail == null) continue;
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u8d75\u4fca\u5cf0", (String)"CashPoolHisDetailImpl_1", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return "SDKNTCASTRS";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b50\u516c\u53f8\u73b0\u91d1\u6c60\u4ea4\u6613\u67e5\u8be2", (String)"CashPoolHisDetailImpl_2", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]);
    }

    private DetailInfo parseEach4TransDetailInUpAcntHistory(Element nttrxstrz, BankAcnt acnt) {
        String actbrn = nttrxstrz.getChildTextTrim("ACTBRN");
        String actseq = nttrxstrz.getChildTextTrim("ACTSEQ");
        String bbknbr = nttrxstrz.getChildTextTrim("BBKNBR");
        String bokdir = nttrxstrz.getChildTextTrim("BOKDIR");
        String rvstag = nttrxstrz.getChildTextTrim("RVSTAG");
        String bankCurrency = nttrxstrz.getChildTextTrim("CCYNBR");
        String ccytyp = nttrxstrz.getChildTextTrim("CCYTYP");
        String cltnbr = nttrxstrz.getChildTextTrim("CLTNBR");
        String crpseq = nttrxstrz.getChildTextTrim("CRPSEQ");
        String crscod = nttrxstrz.getChildTextTrim("CRSCOD");
        String c_ccynbr = nttrxstrz.getChildTextTrim("C_CCYNBR");
        String dtatyp = nttrxstrz.getChildTextTrim("DTATYP");
        String eacnbr = nttrxstrz.getChildTextTrim("EACNBR");
        String etydat = nttrxstrz.getChildTextTrim("ETYDAT");
        String etytim = nttrxstrz.getChildTextTrim("ETYTIM");
        String lgrdat = nttrxstrz.getChildTextTrim("LGRDAT");
        String lgrseq = nttrxstrz.getChildTextTrim("LGRSEQ");
        String lgrtim = nttrxstrz.getChildTextTrim("LGRTIM");
        String onlbal = nttrxstrz.getChildTextTrim("ONLBAL");
        String onllmt = nttrxstrz.getChildTextTrim("ONLLMT");
        String avlamt = nttrxstrz.getChildTextTrim("AVLAMT");
        String rpyacc = nttrxstrz.getChildTextTrim("RPYACC");
        String rpyadr = nttrxstrz.getChildTextTrim("RPYADR");
        String rpybbn = nttrxstrz.getChildTextTrim("RPYBBN");
        String rpybnk = nttrxstrz.getChildTextTrim("RPYBNK");
        String rpynam = nttrxstrz.getChildTextTrim("RPYNAM");
        String trxamt = nttrxstrz.getChildTextTrim("TRXAMT");
        String trxnbr = nttrxstrz.getChildTextTrim("TRXNBR");
        String trxset = nttrxstrz.getChildTextTrim("TRXSET");
        String trxtxt = nttrxstrz.getChildTextTrim("TRXTXT");
        String trxtyp = nttrxstrz.getChildTextTrim("TRXTYP");
        String txtcod = nttrxstrz.getChildTextTrim("TXTCOD");
        String txttag = nttrxstrz.getChildTextTrim("TXTTAG");
        String valdat = nttrxstrz.getChildTextTrim("VALDAT");
        String orgCrscod = BankBusinessConfig.getCRSCOD(acnt.getAccNo());
        if (!orgCrscod.equalsIgnoreCase(crscod)) {
            String error = String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u4fe1\u606f\u4e2d\u7684\u534f\u8bae\u7f16\u53f7%1$s\u4e0e\u8bf7\u6c42\u7684\u534f\u8bae\u7f16\u53f7%2$s\u4e0d\u7b26 \u5ffd\u7565\u672c\u6761\u660e\u7ec6\u3002", (String)"CashPoolHisDetailImpl_9", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), crscod, orgCrscod);
            this.log.info(error);
            return null;
        }
        DetailInfo detail = new DetailInfo();
        detail.setAccName(acnt.getAccName());
        detail.setAccNo(eacnbr);
        this.log.info("\u6bcd\u516c\u53f8\u8d26\u53f7" + eacnbr);
        detail.setOppAccNo(rpyacc);
        this.log.info("\u6536\u4ed8\u65b9\u5e10\u53f7\u5206\u884c\u53f7" + eacnbr);
        detail.setOppAccName(rpynam);
        this.log.info("\u6536\u4ed8\u65b9\u540d\u79f0 " + eacnbr);
        detail.setOppBankName(rpybnk);
        this.log.info("\u6536\u4ed8\u65b9\u5f00\u6237\u884c\u884c\u540d" + eacnbr);
        if (StringUtils.isNotEmpty((String)avlamt)) {
            BigDecimal orgAvlamt = new BigDecimal(avlamt);
            detail.setBalance(orgAvlamt);
        }
        detail.setCurrency(bankCurrency);
        BigDecimal orgTrxamt = new BigDecimal(trxamt);
        if ("R".equalsIgnoreCase(rvstag)) {
            bokdir = "C".equalsIgnoreCase(bokdir) ? "D" : "C";
        }
        if (bokdir.equalsIgnoreCase("C")) {
            detail.setCreditAmount(orgTrxamt);
            detail.setDebitAmount(new BigDecimal(0));
        } else {
            detail.setCreditAmount(new BigDecimal(0));
            detail.setDebitAmount(orgTrxamt.abs());
        }
        try {
            LocalDate date = LocalDate.parse(lgrdat, DateTimeFormatter.ofPattern("yyyyMMdd"));
            detail.setTransDate(date);
            LocalDateTime dateTime = LocalDateTime.parse(etydat + etytim, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detail.setTransTime(dateTime);
        }
        catch (Exception e) {
            this.log.info("\u4ece\u65f6\u95f4\u6233\u5b57\u6bb5\u83b7\u53d6\u4ea4\u6613\u660e\u7ec6\u65f6\u95f4\u53d1\u751f\u5f02\u5e38\u3002\u8bf7\u6ce8\u610f\u68c0\u67e5\u6570\u636e[" + etydat + etytim + "]\u662f\u5426\u6ee1\u8db3\u683c\u5f0f[yyyyMMddHHmmss]");
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u65f6\u95f4\u6233\u5b57\u6bb5\u503c[%1$s%2$s]\u4e0d\u7b26\u5408[yyyyMMddHHmmss]\u683c\u5f0f\u3002", (String)"CashPoolHisDetailImpl_10", (String)"ebg-aqap-banks-cmb-dc", (Object[])new Object[0]), etydat, etytim), (Throwable)e);
        }
        detail.setExplanation(trxtxt);
        return detail;
    }
}

