/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gsnx.dc.service.balance;

import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.CommonPacker;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.CommonParser;
import kd.ebg.aqap.banks.gsnx.dc.service.utils.GSNXConstants;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        JSONObject body = new JSONObject();
        body.put("acc", (Object)request.getAcnt().getAccNo());
        body.put("acc_name", (Object)request.getAcnt().getAccName());
        return CommonPacker.createRootMsg(body, GSNXConstants.BALANCE);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String res) {
        JSONObject body = CommonParser.getRespBody(res);
        String acc = body.getString("acc");
        String currentBal = body.getString("curr_bal");
        String avlBal = body.getString("avl_bal");
        String lastDayBal = body.getString("yday_bal");
        String freezeBal = body.getString("avl_hldbal");
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), acc);
        this.setCurrentBalance(balanceInfo, currentBal);
        this.setAvailableBalance(balanceInfo, avlBal);
        this.setLastDayAvlBalance(balanceInfo, lastDayBal);
        this.setFreezeBalance(balanceInfo, freezeBal);
        balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
        return new EBBankBalanceResponse(Collections.singletonList(balanceInfo));
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return GSNXConstants.BALANCE.getEnName();
    }

    public String getBizDesc() {
        return GSNXConstants.BALANCE.getCnName();
    }
}

