/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jlb.cms.services.detail;

import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jlb.cms.services.Common;
import kd.ebg.aqap.banks.jlb.cms.services.Packer;
import kd.ebg.aqap.banks.jlb.cms.services.proxy.DetailFileDownLoad;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(DetailImpl.class);
    private String baseMsg = ResManager.loadKDString((String)"\u5409\u6797\u94f6\u884c\u73b0\u91d1\u4ea4\u6613\u5e73\u53f0", (String)"DetailImpl_0", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "200110";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u6237\u660e\u7ec6(200110\u4ea4\u6613)", (String)"DetailImpl_1", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]);
    }

    public String pack(BankDetailRequest req) {
        BankAcnt acnt = req.getAcnt();
        String req_no = RequestContextUtils.getRequestContext().getBankRequestSeq();
        String tr_code = "200110";
        Element ap = Packer.createCommonHead((String)tr_code, (String)req_no, (String)"0");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)req.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"start_date", (String)req.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"end_date", (String)req.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)encoding);
        return Common.createCommonMsg((String)xmlMsg);
    }

    public EBBankDetailResponse parse(BankDetailRequest rqst, String rspStr) {
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(8);
        String encoding = RequestContextUtils.getCharset();
        Element ap = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element head = ap.getChild("head");
        Element body = ap.getChild("body");
        BankResponse response = Common.parseBankResponse((Element)head);
        if (!"0_0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"%$1s\u67e5\u8be2\u8d26\u6237\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0\uff1a%2$s\uff0c%3$s\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-jlb-cms", (Object[])new Object[0]), this.baseMsg, response.getResponseCode(), response.getResponseMessage()));
        }
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        int recordNum = -1;
        if (!StringUtils.isEmpty((String)record_num)) {
            recordNum = Integer.parseInt(record_num);
        }
        int fieldNum = -1;
        if (!StringUtils.isEmpty((String)field_num)) {
            fieldNum = Integer.parseInt(field_num);
        }
        if (recordNum <= 0) {
            log.info(this.baseMsg + "\u672c\u6b21\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u4ea4\u6613\u660e\u7ec6\u3002");
            return new EBBankDetailResponse(details);
        }
        String fileFlag = head.getChildTextTrim("file_flag");
        String fileName = body.getChildTextTrim("file_name");
        String content = "";
        content = "1".equals(fileFlag) ? new DetailFileDownLoad().doBiz(fileName) : body.getChildTextTrim("serial_record");
        String[][] r2 = this.parseRecord(content, recordNum, fieldNum);
        for (int k = 0; k < r2.length; ++k) {
            String[] r2_k = r2[k];
            DetailInfo detailInfo = this.parseR2(r2_k);
            details.add(detailInfo);
        }
        log.info("===\u89e3\u6790<\u4ea4\u6613\u660e\u7ec6>\u62a5\u6587\u7ed3\u675f===");
        return new EBBankDetailResponse(details);
    }

    private DetailInfo parseR2(String[] r2_k) {
        String acno = r2_k[1];
        String tr_currency = r2_k[2];
        String tr_acdt = r2_k[3];
        String tr_time = r2_k[4];
        String tranDate = tr_acdt + tr_time;
        String acname = r2_k[7];
        String opp_acno = r2_k[8];
        String opp_acname = r2_k[10];
        String oppBank = r2_k[11];
        String balance = r2_k[25];
        String summary = r2_k[34];
        String rcvamt = r2_k[44];
        String payamt = r2_k[43];
        DetailInfo detailInfo = new DetailInfo();
        detailInfo.setAccNo(acno);
        detailInfo.setAccName(acname);
        detailInfo.setOppAccNo(opp_acno);
        detailInfo.setOppAccName(opp_acname);
        detailInfo.setBankName(oppBank);
        detailInfo.setCurrency(tr_currency);
        detailInfo.setTransTime(LocalDateTime.parse(tranDate, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        detailInfo.setTransDate(detailInfo.getTransTime().toLocalDate());
        if (!StringUtils.isEmpty((String)payamt)) {
            detailInfo.setDebitAmount(new BigDecimal(payamt));
        }
        if (!StringUtils.isEmpty((String)rcvamt)) {
            detailInfo.setCreditAmount(new BigDecimal(rcvamt));
        }
        detailInfo.setExplanation(summary);
        if (!StringUtils.isEmpty((String)balance)) {
            detailInfo.setBalance(new BigDecimal(balance));
        }
        return detailInfo;
    }

    private String[][] parseRecord(String serial_record, int recordNum, int fieldNum) {
        String[] allrecord = StringUtils.split((String)serial_record, (String)"|");
        String[][] r2 = new String[recordNum][fieldNum];
        for (int i = 0; i < recordNum; ++i) {
            for (int j = 0; j < fieldNum; ++j) {
                r2[i][j] = allrecord[(i + 1) * fieldNum + j];
            }
        }
        return r2;
    }

    public String recv(InputStream inputStream) {
        return Common.parseRecvMsg((String)super.recv(inputStream));
    }
}

