/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.balance;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.balance.BankCurrencyMapping;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class FixHisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(FixHisBalanceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = Packer.getHeader((String)token, (String)"b2e0016");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0016-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0016-rq");
            JDomUtils.addChild((Element)rq, (String)"ibknum", (String)acnt.getCnaps());
            JDomUtils.addChild((Element)rq, (String)"actacn", (String)acnt.getAccNo());
            JDomUtils.addChild((Element)rq, (String)"curcde", (String)bankBalanceRequest.getBankCurrency());
            JDomUtils.addChild((Element)rq, (String)"from", (String)bankBalanceRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)rq, (String)"to", (String)bankBalanceRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)rq, (String)"begnum", (String)"");
            JDomUtils.addChild((Element)rq, (String)"recnum", (String)"");
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError((Element)root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0016-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        List list = trn.getChildren("b2e0016-rs");
        int size = list.size();
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        ArrayList<String> balanceList = new ArrayList<String>(size);
        boolean accError = false;
        boolean currencyError = false;
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            String accno = rs.getChildTextTrim("actacn");
            if (!accno.equalsIgnoreCase(bankBalanceRequest.getAcnt().getAccNo())) {
                this.logger.info("\u5b9a\u671f\u6237{}\u4e0e\u8bf7\u6c42\u67e5\u8be2\u8d26\u53f7{}\u4e0d\u4e00\u81f4,\u5ffd\u7565", new Object[]{accno, bankBalanceRequest.getAcnt().getAccNo()});
                accError = true;
                continue;
            }
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if (!"B001".equalsIgnoreCase(another_rspcod)) continue;
            String avabal = rs.getChildTextTrim("avabal");
            String curcde = rs.getChildTextTrim("curcde");
            String newBankCurrency = BankCurrencyMapping.getInstance().getNewBankCurrency(curcde);
            if (!bankBalanceRequest.getBankCurrency().equalsIgnoreCase(newBankCurrency)) {
                this.logger.info("\u5b9a\u671f\u6237{}\u7684\u5e01\u522b{}\u4e0e\u8bf7\u6c42\u67e5\u8be2\u5e01\u522b\u4e0d\u4e00\u81f4,\u5ffd\u7565", new Object[]{accno, newBankCurrency});
                currencyError = true;
                continue;
            }
            if (!StringUtils.isNotEmpty((String)avabal)) continue;
            balanceList.add(avabal);
        }
        BigDecimal balance = new BigDecimal("0.0");
        if (CollectionUtil.isNotEmpty(balanceList)) {
            for (String balanceStr : balanceList) {
                try {
                    balance = balance.add(new BigDecimal(balanceStr));
                }
                catch (NumberFormatException e) {
                    this.logger.info("\u94f6\u884c\u8fd4\u56de\u91d1\u989d{}\u683c\u5f0f\u6709\u8bef\uff0c\u5ffd\u7565", (Object)balanceStr);
                }
            }
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        if (balance.compareTo(BigDecimal.ZERO) == 0 && accError) {
            balanceInfo.setError(BalanceUtils.inconsistentAcc());
        } else if (balance.compareTo(BigDecimal.ZERO) == 0 && currencyError) {
            balanceInfo.setError(BalanceUtils.inconsistentCurrency());
        } else {
            this.setCurrentBalance(balanceInfo, balance.toPlainString());
            balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
        }
        balanceInfo.setBankAcnt(bankBalanceRequest.getAcnt());
        String yyyyMMdd = bankBalanceRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        this.setBalanceDateTime(balanceInfo, yyyyMMdd + "235959", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        balances.add(balanceInfo);
        return new EBBankBalanceResponse(balances);
    }

    public LocalDate limitDate() {
        return null;
    }

    public int queryDays() {
        return 1;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0016";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5b9a\u671f\u8d26\u6237\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"FixHisBalanceImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(BankBalanceRequest request) {
        return BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo());
    }
}

