/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class LargeDepositBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.isLargeDeposit(request.getAcnt().getAccNo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = Packer.getHeader((String)token, (String)"b2e0382");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0382-rq");
            Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0382-rq");
            Element account = JDomUtils.addChild((Element)rq, (String)"account");
            JDomUtils.addChild((Element)account, (String)"actacn", (String)acnt.getAccNo());
            JDomUtils.addChild((Element)rq, (String)"saveno", (String)"");
            Element datescope = JDomUtils.addChild((Element)rq, (String)"datescope");
            JDomUtils.addChild((Element)datescope, (String)"from", (String)"");
            JDomUtils.addChild((Element)datescope, (String)"to", (String)"");
            JDomUtils.addChild((Element)rq, (String)"querystatus", (String)"");
            JDomUtils.addChild((Element)rq, (String)"funcoption", (String)"");
            JDomUtils.addChild((Element)rq, (String)"pageinfo", (String)"");
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError((Element)root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0382-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        List list = trn.getChildren("b2e0382-rs");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        ArrayList<String> balanceList = new ArrayList<String>(list.size());
        for (Object rs : list) {
            String bokbal;
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            if (!"B001".equalsIgnoreCase(another_rspcod) || !StringUtils.isNotEmpty((String)(bokbal = rs.getChildTextTrim("bokbal")))) continue;
            balanceList.add(bokbal);
        }
        BigDecimal balance = new BigDecimal("0.0");
        if (CollectionUtil.isNotEmpty(balanceList)) {
            for (String balanceStr : balanceList) {
                balance = balance.add(new BigDecimal(balanceStr));
            }
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        if (balance.compareTo(BigDecimal.ZERO) > 0) {
            balanceInfo.setLargeDepositBalance(balance);
            balances.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0382";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5927\u989d\u5b58\u5355\u8d26\u6237\u4fe1\u606f\u67e5\u8be2", (String)"LargeDepositBalanceImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }
}

