/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.balance;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.service.CashPoolHelper;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.balance.HisBalanceImpl;
import kd.ebg.aqap.banks.boc.net.service.balance.LargeDepositBalanceImpl;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    EBGLogger log = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }

    public boolean match(BankBalanceRequest request) {
        return !CashPoolHelper.isCashPoolAcnt((String)request.getHeader().getAcnt().getAccNo()) && !BankPropertyConfig.isFixedAcnt((String)request.getAcnt().getAccNo()) && !BankBusinessConfig.isAggregatorsAcnt(request.getAcnt().getAccNo());
    }

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        EBBankBalanceResponse ebBankBalanceResponse = new EBBankBalanceResponse();
        ArrayList balanceInfos = new ArrayList(1);
        EBBankBalanceResponse response = this.doBiz(request);
        balanceInfos.addAll(response.getBalances());
        ebBankBalanceResponse.setBalances(balanceInfos);
        return ebBankBalanceResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest request) {
        List bankAcntList = request.getBankAcntList();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = Packer.getHeader((String)token, (String)"b2e0005");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0005-rq");
            for (BankAcnt acnt : bankAcntList) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0005-rq");
                Element account = JDomUtils.addChild((Element)rq, (String)"account");
                JDomUtils.addChild((Element)account, (String)"ibknum", (String)acnt.getCnaps());
                JDomUtils.addChild((Element)account, (String)"actacn", (String)acnt.getAccNo());
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        BalanceInfo largeDeposit;
        BankAcnt acnt = request.getHeader().getAcnt();
        if (CashPoolHelper.isCashPoolAcnt((String)acnt.getAccNo())) {
            // empty if block
        }
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError((Element)root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0005-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        Element rs = trn.getChild("b2e0005-rs");
        Element another_status = rs.getChild("status");
        String another_rspcod = another_status.getChildTextTrim("rspcod");
        String another_rspmsg = another_status.getChildTextTrim("rspmsg");
        if (!"B001".equalsIgnoreCase(another_rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)another_rspcod, (String)another_rspmsg));
        }
        Element account = rs.getChild("account");
        String actacn = account.getChildTextTrim("actacn");
        this.log.info("\u89e3\u6790\u5230\u4e2d\u884c\u8fd4\u56de\u7684'\u8d26\u53f7'\u4e3a" + actacn);
        String acntname = account.getChildTextTrim("actname");
        this.log.info("\u89e3\u6790\u5230\u4e2d\u884c\u8fd4\u56de\u7684'\u8d26\u6237\u540d\u79f0'\u4e3a" + acntname);
        String curcde = account.getChildTextTrim("curcde");
        this.log.info("\u89e3\u6790\u5230\u4e2d\u884c\u8fd4\u56de\u7684'\u4f59\u989d\u5e01\u79cd'\u4e3a" + curcde);
        Element balance = rs.getChild("balance");
        String bokbal = balance.getChildTextTrim("bokbal");
        String frzamt = balance.getChildTextTrim("frzamt");
        String avabal = (String)StringUtils.defaultIfBlank((CharSequence)balance.getChildTextTrim("avabal"), (CharSequence)"0.00");
        this.log.info("\u89e3\u6790\u5230\u4e2d\u884c\u8fd4\u56de\u7684'\u5f53\u524d\u4f59\u989d'\u4e3a" + bokbal);
        this.log.info("\u89e3\u6790\u5230\u4e2d\u884c\u8fd4\u56de\u7684'\u53ef\u7528\u4f59\u989d'\u4e3a" + avabal);
        String baldat = rs.getChildTextTrim("baldat");
        this.log.info("\u89e3\u6790\u5230\u4e2d\u884c\u8fd4\u56de\u7684'\u4f59\u989d\u65e5\u671f'\u4e3a" + baldat + "");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        balances.add(balanceInfo);
        this.setCurrentBalance(balanceInfo, bokbal);
        this.setAvailableBalance(balanceInfo, avabal);
        this.setFreezeBalance(balanceInfo, frzamt);
        BankAcnt bankAcnt = new BankAcnt();
        balanceInfo.setBankAcnt(bankAcnt);
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        bankAcnt.setAccNo(actacn);
        this.setBankCurrency(balanceInfo, request.getCurrency(), curcde);
        try {
            BalanceInfo lastDayBalance = this.getLastDayBalance(request);
            balanceInfo.setLastDayAvlBalance(lastDayBalance.getAvailableBalance());
        }
        catch (Exception e) {
            balanceInfo.setLastDayAvlBalance(BigDecimal.valueOf(0.0));
        }
        if (BankBusinessConfig.isLargeDeposit(acnt.getAccNo()) && (largeDeposit = this.getLargeDeposit(request)).getLargeDepositBalance() != null) {
            balanceInfo.setLargeDepositBalance(largeDeposit.getLargeDepositBalance());
        }
        return new EBBankBalanceResponse(balances);
    }

    private BalanceInfo getLargeDeposit(BankBalanceRequest request) {
        BalanceInfo largeDepositBalance = new BalanceInfo();
        try {
            EBBankBalanceResponse ebBankBalanceResponse = new LargeDepositBalanceImpl().balance(request);
            List balances = ebBankBalanceResponse.getBalances();
            if (CollectionUtil.isNotEmpty((Collection)balances)) {
                largeDepositBalance.setLargeDepositBalance(((BalanceInfo)balances.get(0)).getLargeDepositBalance());
            }
        }
        catch (Throwable t) {
            this.log.error("\u67e5\u8be2\u4e2d\u884c\u5927\u989d\u5b58\u5355\u4f59\u989d\u5f02\u5e38", t);
        }
        return largeDepositBalance;
    }

    private BalanceInfo getLastDayBalance(BankBalanceRequest rqst) {
        BalanceInfo lastDayBalance = new BalanceInfo();
        try {
            LocalDate yesterday = LocalDate.now().minusDays(1L);
            BankBalanceRequest bankHisBalanceRequest = new BankBalanceRequest();
            bankHisBalanceRequest.setBankAcntList(rqst.getBankAcntList());
            bankHisBalanceRequest.setCurrency(rqst.getCurrency());
            bankHisBalanceRequest.setStartDate(yesterday);
            bankHisBalanceRequest.setEndDate(yesterday);
            bankHisBalanceRequest.setExtData(rqst.getExtData());
            bankHisBalanceRequest.setHeader(rqst.getHeader());
            EBBankBalanceResponse hisBalance = new HisBalanceImpl().hisBalance(bankHisBalanceRequest);
            List balances = hisBalance.getBalances();
            if (null != balances && balances.size() > 0) {
                lastDayBalance.setAvailableBalance(((BalanceInfo)balances.get(0)).getAvailableBalance());
                this.log.info("\u4e2d\u884c\u4e0a\u65e5\u4f59\u989d:" + ((BalanceInfo)balances.get(0)).getAvailableBalance());
            }
        }
        catch (Throwable t) {
            this.log.info("\u67e5\u8be2\u4e2d\u884c\u4e0a\u65e5\u4f59\u989d\u51fa\u9519.", (Object)t);
        }
        return lastDayBalance;
    }

    public String getDeveloper() {
        return "lei luo";
    }

    public String getBizCode() {
        return "b2e0005";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eca\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }
}

