/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.oversea;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.kit.FailCode;
import kd.ebg.aqap.banks.boc.net.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.service.payment.oversea.QueryOverseaPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.AttachmentUploadUtil;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OverseaPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryOverseaPayImpl.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest bankPayRequest) {
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            List paymentInfos = bankPayRequest.getPaymentInfos();
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0200");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            BankAcnt acnt = RequestContextUtils.getRequestContext().getBankAcnt();
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0200-rq");
            for (int i = 0; i < paymentInfos.size(); ++i) {
                PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
                JDomUtils.addChild((Element)trn, (String)"TRANS_TYPE", (String)"");
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0200-rq");
                JDomUtils.addChild((Element)rq, (String)"OBSS_ID", (String)"");
                JDomUtils.addChild((Element)rq, (String)"AUTH_EXPIRY_DT", (String)"");
                JDomUtils.addChild((Element)rq, (String)"REM_MODE", (String)"S");
                if (info.is2Urgent()) {
                    JDomUtils.addChild((Element)rq, (String)"RET_LVL", (String)"2");
                } else {
                    JDomUtils.addChild((Element)rq, (String)"RET_LVL", (String)"1");
                }
                boolean diffCurrency = info.isDiffCurrency();
                if (diffCurrency) {
                    JDomUtils.addChild((Element)rq, (String)"TRN_AMT", (String)info.getAmount().toPlainString());
                    JDomUtils.addChild((Element)rq, (String)"CEX_AMT", (String)"");
                    JDomUtils.addChild((Element)rq, (String)"CEX_ACNO", (String)"");
                    JDomUtils.addChild((Element)rq, (String)"PUR_AMT", (String)info.getAmount().toPlainString());
                    JDomUtils.addChild((Element)rq, (String)"PUR_ACNO", (String)info.getAccNo());
                } else {
                    JDomUtils.addChild((Element)rq, (String)"TRN_AMT", (String)info.getAmount().toPlainString());
                    JDomUtils.addChild((Element)rq, (String)"CEX_AMT", (String)info.getAmount().toPlainString());
                    JDomUtils.addChild((Element)rq, (String)"CEX_ACNO", (String)info.getAccNo());
                    JDomUtils.addChild((Element)rq, (String)"PUR_AMT", (String)"");
                    JDomUtils.addChild((Element)rq, (String)"PUR_ACNO", (String)"");
                }
                JDomUtils.addChild((Element)rq, (String)"TRN_CUR", (String)info.getPayCurrency());
                JDomUtils.addChild((Element)rq, (String)"OTR_AMT", (String)"");
                JDomUtils.addChild((Element)rq, (String)"OTR_ACNO", (String)"");
                JDomUtils.addChild((Element)rq, (String)"FEE_ACNO", (String)info.getPayerFeeAccNo());
                String accName = info.getAccName();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"aqap_bank_acnt", (String)"number,en_accname", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)info.getAccNo())});
                if (dynamicObject != null) {
                    accName = dynamicObject.getString("en_accname");
                }
                JDomUtils.addChild((Element)rq, (String)"FRN_NAME_50A", (String)accName);
                JDomUtils.addChild((Element)rq, (String)"FRN_ADDRESS_50A", (String)info.getPayerAddress());
                String payerProvince = info.getPayerProvince();
                if (StringUtils.isEmpty((String)payerProvince)) {
                    payerProvince = info.getAccProvince();
                }
                JDomUtils.addChild((Element)rq, (String)"FRN_PROVINCE_50A", (String)payerProvince);
                String payerCity = info.getPayerCity();
                if (StringUtils.isEmpty((String)payerCity)) {
                    payerCity = info.getAccCity();
                }
                JDomUtils.addChild((Element)rq, (String)"FRN_CITY_50A", (String)payerCity);
                CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(info.getAccCountry());
                if (code == null) {
                    code = ISOCountryUtils.getInstance().getCountryInfo(info.getAccCountry());
                }
                JDomUtils.addChild((Element)rq, (String)"FRN_COUNTRY_50A", (String)code.geteChart2());
                String bocNetOrgCode = BankBusinessConfig.getBocNetOrgCode(info.getAccNo());
                JDomUtils.addChild((Element)rq, (String)"ORG_CDE", (String)(StringUtils.isNotEmpty((String)bocNetOrgCode) ? bocNetOrgCode : RequestContextUtils.getBankParameterValue((String)"orgid")));
                JDomUtils.addChild((Element)rq, (String)"BEDL_NAME_56A", (String)"");
                JDomUtils.addChild((Element)rq, (String)"BEDL_ADDRESS_56A", (String)"");
                JDomUtils.addChild((Element)rq, (String)"BDL_ACT_57A", (String)"");
                JDomUtils.addChild((Element)rq, (String)"BEAK_NAME", (String)info.getIncomeBankName());
                JDomUtils.addChild((Element)rq, (String)"BEAK_ADDRESS", (String)info.getIncomeBankAddress());
                JDomUtils.addChild((Element)rq, (String)"TO_ACT_ACN_59A", (String)info.getIncomeAccNo());
                JDomUtils.addChild((Element)rq, (String)"TO_NAME_59A", (String)info.getIncomeAccName());
                JDomUtils.addChild((Element)rq, (String)"TO_ADDRESS_59A", (String)info.getIncomeAddress());
                CountryISOCode incomeCountry = ISOCountryUtils.getInstance().getCountryInfoByName(info.getIncomeCountry());
                if (incomeCountry == null) {
                    incomeCountry = ISOCountryUtils.getInstance().getCountryInfo(info.getIncomeCountry());
                }
                JDomUtils.addChild((Element)rq, (String)"TO_COUNTRY_59A", (String)incomeCountry.geteChart2());
                JDomUtils.addChild((Element)rq, (String)"TO_CITY_59A", (String)info.getIncomeCity());
                JDomUtils.addChild((Element)rq, (String)"POSTSCRIPTMT", (String)info.getExplanation());
                String feeMode = "OUR";
                if ("02".equalsIgnoreCase(info.getPayerFeeType())) {
                    feeMode = "BEN";
                } else if ("03".equalsIgnoreCase(info.getPayerFeeType())) {
                    feeMode = "SHA";
                }
                JDomUtils.addChild((Element)rq, (String)"FEE_MODE", (String)feeMode);
                JDomUtils.addChild((Element)rq, (String)"COU_CDE", (String)incomeCountry.getNumberCode());
                String pay_type = "4";
                if ("1".equalsIgnoreCase(info.getPayProperty())) {
                    pay_type = "2";
                } else if ("0".equalsIgnoreCase(info.getPayProperty())) {
                    pay_type = "1";
                } else if ("2".equalsIgnoreCase(info.getPayProperty())) {
                    pay_type = "3";
                }
                JDomUtils.addChild((Element)rq, (String)"PAY_TYPE", (String)pay_type);
                JDomUtils.addChild((Element)rq, (String)"TRN_CD1", (String)info.getTxCode());
                JDomUtils.addChild((Element)rq, (String)"TRN_CUR1", (String)info.getPayCurrency());
                JDomUtils.addChild((Element)rq, (String)"TRN_AMT1", (String)info.getTxAmount());
                JDomUtils.addChild((Element)rq, (String)"TRN_RE1", (String)info.getTxPostscript());
                JDomUtils.addChild((Element)rq, (String)"TRN_CD2", (String)"");
                JDomUtils.addChild((Element)rq, (String)"TRN_CUR2", (String)"");
                JDomUtils.addChild((Element)rq, (String)"TRN_AMT2", (String)"");
                JDomUtils.addChild((Element)rq, (String)"TRN_RE2", (String)"");
                JDomUtils.addChild((Element)rq, (String)"IS_BGD_PAY", (String)(info.isBondGoodsFlag() ? "1" : "0"));
                JDomUtils.addChild((Element)rq, (String)"COM_NUM", (String)info.getContractNo());
                JDomUtils.addChild((Element)rq, (String)"INV_NUM", (String)info.getInvoiceNo());
                JDomUtils.addChild((Element)rq, (String)"WHB_NUM", (String)"");
                JDomUtils.addChild((Element)rq, (String)"PER_NAME", (String)info.getApplyName());
                JDomUtils.addChild((Element)rq, (String)"PER_TEL", (String)info.getApplyPhone());
                JDomUtils.addChild((Element)rq, (String)"ERP_REF", (String)info.getBankDetailSeqID());
                JDomUtils.addChild((Element)rq, (String)"REM_TYP", (String)"1");
                JDomUtils.addChild((Element)rq, (String)"FEE_PAY_TYPE", (String)"");
                JDomUtils.addChild((Element)rq, (String)"IBK_NUM", (String)"");
                JDomUtils.addChild((Element)rq, (String)"CUS_FLAG", (String)"BN");
                JDomUtils.addChild((Element)rq, (String)"REMARK1", (String)"");
                JDomUtils.addChild((Element)rq, (String)"REMARK2", (String)"");
                JDomUtils.addChild((Element)rq, (String)"BED_BIC_57A", (String)info.getIncomeSwiftCode());
                JDomUtils.addChild((Element)rq, (String)"TRF_DATE", (String)"");
                JDomUtils.addChild((Element)rq, (String)"waitImage", (String)(StringUtils.isEmpty((String)info.getFileList()) ? "0" : "1"));
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String responseStr) {
        List paymentInfos;
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        boolean isError = Parser.parserB2eError((Element)root, (List)(paymentInfos = bankPayRequest.getPaymentInfos()));
        if (isError) {
            return new EBBankPayResponse(paymentInfos);
        }
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0200-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u4e0d\u786e\u5b9a\u72b6\u6001\u7801\u8bf7\u8054\u7cfb\u94f6\u884c\u5904\u7406\u3002", (String)"OverseaPayImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)rspcod, (String)rspmsg);
            return new EBBankPayResponse(paymentInfos);
        }
        List list = trn.getChildren("b2e0200-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            String erp_ref = rs.getChildTextTrim("ERP_REF");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)BocNetUtils.getSeqIdFromInsid((String)erp_ref));
            if (null == info) continue;
            String obss_id = rs.getChildText("OBSS_ID");
            info.setBankRefID(obss_id);
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            if ("B001".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)"", (String)another_rspcod, (String)another_rspmsg);
                EBContext context = EBContext.getContext();
                AttachmentUploadUtil.async((String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID(), (String)context.getLogger_batch_no());
                continue;
            }
            if ("1014".equalsIgnoreCase(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            if (FailCode.getInstance().isFail(another_rspcod)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)another_rspcod, (String)another_rspmsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\uff0c\u8bf7\u54a8\u8be2\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"OverseaPayImpl_1", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)another_rspcod, (String)another_rspmsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0200";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u5883\u6c47\u6b3e\u7533\u8bf7(b2e0200)", (String)"OverseaPayImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "overseaPay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }
}

