/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.payment.oversea;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.service.BocNetUtils;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.banks.boc.net.service.payment.oversea.FrontProxy;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryOverseaPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryOverseaPayImpl.class);

    public int getBatchSize() {
        return 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = BocNetUtils.createRoot();
            Element head = JDomUtils.addChild((Element)root, (String)"head");
            JDomUtils.addChild((Element)head, (String)"termid", (String)RequestContextUtils.getBankParameterValue((String)"termid"));
            JDomUtils.addChild((Element)head, (String)"trnid", (String)Packer.getTrnid());
            JDomUtils.addChild((Element)head, (String)"custid", (String)RequestContextUtils.getBankParameterValue((String)"custid"));
            JDomUtils.addChild((Element)head, (String)"cusopr", (String)RequestContextUtils.getBankParameterValue((String)"cusopr"));
            JDomUtils.addChild((Element)head, (String)"trncod", (String)"b2e0204");
            JDomUtils.addChild((Element)head, (String)"token", (String)token);
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0204-rq");
            int size = paymentInfos.size();
            for (int i = 0; i < size; ++i) {
                PaymentInfo info = (PaymentInfo)paymentInfos.get(i);
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0204-rq");
                JDomUtils.addChild((Element)rq, (String)"ERP_REF", (String)info.getBankDetailSeqID());
                JDomUtils.addChild((Element)rq, (String)"OBSS_ID", (String)"");
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception exception) {}
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError((Element)root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0204-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equalsIgnoreCase(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u652f\u4ed8\u7ed3\u679c\u67e5\u8be2\u5931\u8d25\uff1a%s", (String)"QueryOverseaPayImpl_6", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), rspcod + rspmsg));
        }
        List list = trn.getChildren("b2e0204-rs");
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Element rs = (Element)list.get(i);
            String erp_ref = rs.getChildTextTrim("ERP_REF");
            PaymentInfo info = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)BocNetUtils.getSeqIdFromInsid((String)erp_ref));
            if (null == info) continue;
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            String apply_state = rs.getChildText("APPLY_STATE");
            String fail_reason = rs.getChildText("FAIL_REASON");
            if ("0".equalsIgnoreCase(apply_state)) {
                if (BankBusinessConfig.isNeedProxyQueryOversea()) {
                    String s = this.packProxy(info);
                    FrontProxy frontProxy = new FrontProxy();
                    String responseStr = frontProxy.sendAndRecvMsg(s);
                    this.paserProxy(info, responseStr);
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)apply_state, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryOverseaPayImpl_5", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
                continue;
            }
            if ("1".equalsIgnoreCase(apply_state)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)"", (String)apply_state, (String)fail_reason);
                continue;
            }
            if ("2".equalsIgnoreCase(apply_state)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\u8bf7\u7a0d\u540e\u3002", (String)"QueryOverseaPayImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]), (String)apply_state, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\u8bf7\u7a0d\u540e\u3002", (String)"QueryOverseaPayImpl_2", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)apply_state, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u5b9e\u9645\u4ea4\u6613\u7ed3\u679c\u8bf7\u4eba\u5de5\u627e\u94f6\u884c\u786e\u8ba4\u3002", (String)"QueryOverseaPayImpl_3", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    private void paserProxy(PaymentInfo info, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element head = JDomUtils.getChildElement((Element)root, (String)"head");
        String rspcode = JDomUtils.getChildText((Element)head, (String)"rspcode");
        if ("BIZ_FAIL".equals(rspcode)) {
            this.logger.info("\u8bf7\u6c42\u4ee3\u7406\u7a0b\u5e8f\u83b7\u53d6\u901a\u77e5\u7ed3\u679c\u5931\u8d25\uff0c\u4e0d\u6539\u53d8\u4ed8\u6b3e\u72b6\u6001\u3002");
            return;
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        Element rspPara = JDomUtils.getChildElement((Element)body, (String)"rspPara");
        String status = JDomUtils.getChildText((Element)rspPara, (String)"status");
        String code = JDomUtils.getChildText((Element)rspPara, (String)"code");
        String msg = JDomUtils.getChildText((Element)rspPara, (String)"msg");
        if ("RECORD_IS_NOT_EXIST".equals(code) || "BIZ_OPERATION_EXCEPTION".equals(code)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\uff0c\u5b9e\u9645\u4ea4\u6613\u7ed3\u679c\u8bf7\u4eba\u5de5\u627e\u94f6\u884c\u786e\u8ba4\u3002", (String)"QueryOverseaPayImpl_3", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
            return;
        }
        String out_ref = JDomUtils.getChildText((Element)rspPara, (String)"out_ref");
        String actual_amount = JDomUtils.getChildText((Element)rspPara, (String)"actual_amount");
        String sell_quote_price = JDomUtils.getChildText((Element)rspPara, (String)"sell_quote_price");
        String fee_amt = JDomUtils.getChildText((Element)rspPara, (String)"fee_amt");
        String fee_cur = JDomUtils.getChildText((Element)rspPara, (String)"fee_cur");
        info.setRemitNo(out_ref);
        if (StringUtils.isNotEmpty((String)actual_amount)) {
            info.setActualAmount(new BigDecimal(actual_amount));
        }
        info.setExchangeRate(sell_quote_price);
        info.setPayerFeeAmount(fee_amt);
        info.setPayerFeeCurrency(fee_cur);
        EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)"", (String)"", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryOverseaPayImpl_5", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]));
    }

    private String packProxy(PaymentInfo info) {
        Element simulator = new Element("simulator");
        Element head = new Element("head");
        JDomUtils.addChild((Element)head, (String)"reqDate", (String)DateTimeUtils.formatDate((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"reqTime", (String)DateTimeUtils.formatTime((Date)new Date()));
        JDomUtils.addChild((Element)head, (String)"token", (String)"");
        JDomUtils.addChild((Element)head, (String)"sequence", (String)info.getBankDetailSeqID());
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"itemSequence", (String)info.getBankDetailSeqId());
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0204";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u5883\u6c47\u6b3e\u7533\u8bf7\u72b6\u6001\u67e5\u8be2(b2e0204)", (String)"QueryOverseaPayImpl_4", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }
}

