/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.ICBC_CMP_ResultMap;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.ZipUtils;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ICBC_CMP_QueryPayParser {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_CMP_QueryPayParser.class);

    public static void parseQueryPay(List<PaymentInfo> paymentInfos, String rspStr) {
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp((String)rspStr, (boolean)true);
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String simplifyRspCode4Cpic = parameter.getBankParameter("simplifyRspCode4Cpic");
        boolean cpic = "true".equalsIgnoreCase(simplifyRspCode4Cpic);
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader((Element)pub);
        String bankStatus = "";
        bankStatus = cpic ? headRsp.getResponseCode() : "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        String bankMsg = headRsp.getResponseMessage();
        if ("A0001".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"ICBC_CMP_QueryPayParser_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)bankMsg);
            return;
        }
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u62a5\u6587\u5934\u8fd4\u56de\u9519\u8bef\u7801\u65e0\u6cd5\u786e\u8ba4\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"ICBC_CMP_QueryPayParser_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)bankMsg);
            return;
        }
        Element out = eb.getChild("out");
        String qryfSeqno = out.getChildText("QryfSeqno");
        List list = out.getChildren("rd");
        ICBC_CMP_QueryPayParser.parseQueryPayRd(paymentInfos, cpic, qryfSeqno, list);
    }

    public static void parseQueryPayNew(List<PaymentInfo> paymentInfos, String rspStr) {
        String retMsgDecoded = ICBC_CMP_Parser.decodeRsp((String)rspStr, (boolean)true);
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String simplifyRspCode4Cpic = parameter.getBankParameter("simplifyRspCode4Cpic");
        boolean cpic = "true".equalsIgnoreCase(simplifyRspCode4Cpic);
        String encoding = context.getCharsetName();
        Element root = JDomUtils.string2Root((String)retMsgDecoded, (String)encoding);
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader((Element)pub);
        String bankStatus = "";
        bankStatus = cpic ? headRsp.getResponseCode() : "<RetCode>" + headRsp.getResponseCode() + "</RetCode>";
        String bankMsg = headRsp.getResponseMessage();
        if ("A0001".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"ICBC_CMP_QueryPayParser_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)bankMsg);
            return;
        }
        if (!"0".equalsIgnoreCase(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentsWithoutStauts(paymentInfos, (String)ResManager.loadKDString((String)"\u94f6\u884c\u62a5\u6587\u5934\u8fd4\u56de\u9519\u8bef\u7801\u65e0\u6cd5\u786e\u8ba4\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"ICBC_CMP_QueryPayParser_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)bankMsg);
            return;
        }
        Element out = eb.getChild("out");
        String qryfSeqno = out.getChildText("QryfSeqno");
        String qrySerialNo = out.getChildText("QrySerialNo");
        List list = null;
        String zipStr = out.getChildText("zip");
        if (zipStr != null) {
            try {
                byte[] zipByte = ZipUtils.unZipandUnbase64((String)zipStr);
                String zipContent = new String(zipByte, EBContext.getContext().getCharsetName());
                zipContent = "<zip>" + zipContent + "</zip>";
                logger.info("\u89e3\u538b\u7f29\u94f6\u884c\u8fd4\u56de\u660e\u6587\uff1a" + zipContent);
                Element zip = JDomUtils.string2Root((String)zipContent, (String)EBContext.getContext().getCharsetName());
                list = zip.getChildren("rd");
            }
            catch (IOException e) {
                EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u89e3\u538b\u7f29zip\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\u3002", (String)"ICBC_CMP_QueryPayParser_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)bankMsg);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u538b\u7f29zip\u5185\u5bb9\u51fa\u73b0\u5f02\u5e38\u3002", (String)"ICBC_CMP_QueryPayParser_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (Throwable)e);
            }
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u5de5\u884c\u63a5\u6536\u4e86\u6279\u91cf\u4ed8\u6b3e\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u72b6\u6001\u3002", (String)"ICBC_CMP_QueryPayParser_3", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (String)bankStatus, (String)bankMsg);
            return;
        }
        if (list == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u538b\u7f29zip\u5185\u5bb9\uff0c\u5f97\u5230\u7684rd\u8282\u70b9\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u77e5\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"ICBC_CMP_QueryPayParser_4", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
        }
        ICBC_CMP_QueryPayParser.parseQueryPayRd(paymentInfos, cpic, qryfSeqno, list);
    }

    private static void parseQueryPayRd(List<PaymentInfo> paymentInfos, boolean cpic, String qryfSeqno, List list) {
        for (int i = 0; i < list.size(); ++i) {
            Element rd = (Element)list.get(i);
            String qryiSeqno = rd.getChildTextTrim("QryiSeqno");
            String instrRetCode = rd.getChildTextTrim("instrRetCode");
            String instrRetMsg = rd.getChildTextTrim("instrRetMsg");
            String iRetCode = rd.getChildTextTrim("iRetCode");
            String iRetMsg = rd.getChildTextTrim("iRetMsg");
            String result = rd.getChildText("Result");
            String recAccNo = rd.getChildText("RecAccNo");
            String recAccNameCN = rd.getChildText("RecAccNameCN");
            String payAmt = rd.getChildText("PayAmt");
            if (StringUtils.isNotEmpty((String)payAmt)) {
                payAmt = new BigDecimal(payAmt).divide(new BigDecimal(100)).toPlainString();
            }
            BankResponse recordRsp = new BankResponse();
            if (null != instrRetCode) {
                recordRsp.setResponseCode(instrRetCode);
                recordRsp.setResponseMessage(instrRetMsg);
            } else {
                recordRsp.setResponseCode(iRetCode);
                recordRsp.setResponseMessage(iRetMsg);
            }
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo(paymentInfos, (String)qryfSeqno, (String)qryiSeqno);
            if (null == paymentInfo) continue;
            if (cpic) {
                paymentInfo.setBankStatus(recordRsp.getResponseCode());
            } else if (null != instrRetCode) {
                paymentInfo.setBankStatus("<instrRetCode>" + recordRsp.getResponseCode() + "</instrRetCode> <Result>" + result + "</Result>");
            } else {
                paymentInfo.setBankStatus("<iRetCode>" + recordRsp.getResponseCode() + "</iRetCode> <Result>" + result + "</Result>");
            }
            if (StringUtils.isEmpty((String)recordRsp.getResponseMessage())) {
                paymentInfo.setStatusMsg(ICBC_CMP_ResultMap.convertResult2Advice((String)result));
            } else {
                paymentInfo.setBankMsg(recordRsp.getResponseMessage());
            }
            if ("7".equalsIgnoreCase(result)) {
                paymentInfo.setBackStatus(paymentInfo.getStatus());
                paymentInfo.setStatus(Integer.valueOf(PaymentState.SUCCESS.getId()));
                paymentInfo.setStatusName(PaymentState.SUCCESS.getEnName());
                paymentInfo.setStatusMsg(PaymentState.SUCCESS.getCnName());
            } else if ("6".equalsIgnoreCase(result) || "8".equalsIgnoreCase(result) || "11".equalsIgnoreCase(result)) {
                paymentInfo.setBackStatus(paymentInfo.getStatus());
                paymentInfo.setStatus(Integer.valueOf(PaymentState.FAIL.getId()));
                paymentInfo.setStatusName(PaymentState.FAIL.getEnName());
                paymentInfo.setStatusMsg(PaymentState.FAIL.getCnName());
                if ("B0083".equalsIgnoreCase(recordRsp.getResponseCode())) {
                    paymentInfo.setStatusMsg(ResManager.loadKDString((String)"\u94f6\u4f01\u4e2d\u95f4\u4ef6\u5efa\u8bae\u60a8\u68c0\u67e5\u6536\u6b3e\u8d26\u53f7,\u4ed8\u6b3e\u5931\u8d25\u7684\u539f\u56e0\u53ef\u80fd\u662f:\u5de5\u884c\u7684\u540c\u884c\u652f\u4ed8\u65f6,\u6536\u6b3e\u8d26\u53f7\u586b\u5199\u9519\u8bef", (String)"ICBC_CMP_QueryPayParser_5", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
                }
            } else {
                paymentInfo.setBackStatus(paymentInfo.getStatus());
                paymentInfo.setStatus(Integer.valueOf(PaymentState.SUBMITED.getId()));
                paymentInfo.setStatusName(PaymentState.SUBMITED.getEnName());
                paymentInfo.setStatusMsg(PaymentState.SUBMITED.getCnName());
            }
            CommonPayStatusMatchUtil.checkPayStatusWith3Factor((PaymentInfo)paymentInfo, (String)recAccNo, (String)recAccNameCN, (String)payAmt, (boolean)BankBusinessConfig.isUseCheckWith3Factor());
        }
    }
}

