/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Packer;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.banks.icbc.cmp.service.balance.QFACCTMEASImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.utils.CommonUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBatchBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance {
    String transCode = "QACCBAL";
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBatchBalanceImpl.class);

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "QACCBAL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u6279\u91cf\u4f59\u989d\u67e5\u8be2", (String)"TodayBatchBalanceImpl_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        return LocalDate.now().equals(request.getStartDate());
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        List bankAccountList = bankBalanceRequest.getBankAcntList();
        String inputBankCurrency = bankBalanceRequest.getBankCurrency();
        Element root = ICBC_CMP_Packer.createICBCCMPRoot((String)this.transCode);
        Element eb = root.getChild("eb");
        Element in = JDomUtils.addChild((Element)eb, (String)"in");
        JDomUtils.addChild((Element)in, (String)"TotalNum", (String)String.valueOf(bankAccountList.size()));
        JDomUtils.addChild((Element)in, (String)"BLFlag", (String)"0");
        if (bankAccountList.size() == 1) {
            JDomUtils.addChild((Element)in, (String)"SynFlag", (String)"0");
        } else {
            JDomUtils.addChild((Element)in, (String)"SynFlag", (String)"1");
        }
        for (int i = 0; i < bankAccountList.size(); ++i) {
            String accNo = ((BankAcnt)bankAccountList.get(i)).getAccNo();
            Element rd = JDomUtils.addChild((Element)in, (String)"rd");
            JDomUtils.addChild((Element)rd, (String)"iSeqno", (String)Sequence.gen18Sequence());
            JDomUtils.addChild((Element)rd, (String)"AccNo", (String)accNo);
            JDomUtils.addChild((Element)rd, (String)"CurrType", (String)inputBankCurrency);
            JDomUtils.addChild((Element)rd, (String)"ReqReserved3", (String)"");
            JDomUtils.addChild((Element)rd, (String)"AcctSeq", (String)"");
        }
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        return ICBC_CMP_Packer.createMessageWithHead((String)requestMessage, (String)this.transCode, (String)"0.0.1.0");
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        String encoding;
        String retMsg = ICBC_CMP_Parser.decodeRsp((String)rspStr, (boolean)true);
        Element root = JDomUtils.string2Root((String)retMsg, (String)(encoding = RequestContextUtils.getCharset()));
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader((Element)pub);
        if (!"0".equals(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"TodayBatchBalanceImpl_8", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{headRsp.getResponseCode(), headRsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element out = eb.getChild("out");
        List list = out.getChildren("rd");
        ArrayList<BalanceInfo> bList = new ArrayList<BalanceInfo>(16);
        BalanceInfo info = null;
        BankAcnt bankAcnt = null;
        if (list == null || list.size() == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5de5\u884c\u4f59\u989d\u67e5\u8be2\u8fd4\u56de\u62a5\u6587\u683c\u5f0f\u9519\u8bef,\u4e0d\u542brd\u5143\u7d20", (String)"TodayBatchBalanceImpl_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
        }
        for (int i = 0; i < list.size(); ++i) {
            Element rd = (Element)list.get(i);
            info = new BalanceInfo();
            String accNo = rd.getChildTextTrim("AccNo");
            String CurrType = rd.getChildTextTrim("CurrType");
            bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(accNo);
            info.setBankAcnt(bankAcnt);
            info.setBankCurrency(CurrType);
            info.setBalanceDateTime(LocalDateTime.now());
            bList.add(info);
            String balance = rd.getChildTextTrim("Balance");
            String usableBalance = rd.getChildTextTrim("UsableBalance");
            String accBalance = rd.getChildTextTrim("AccBalance");
            String iRetMsg = rd.getChildTextTrim("iRetMsg");
            String freezeBal = rd.getChildTextTrim("FrzAmt");
            try {
                this.logger.info("\u89e3\u6790\u5230\u5de5\u884c\u5e10\u53f7" + accNo + "\u8fd4\u56de\u7684'\u5f53\u524d\u4f59\u989d'\u4e3a" + balance + "\u5206");
                this.setCurrentBalance(info, balance, 100);
                if (!StringUtils.isEmpty((String)accBalance)) {
                    this.logger.info("\u89e3\u6790\u5230\u5de5\u884c\u5e10\u53f7" + accNo + "\u8fd4\u56de\u7684'\u4e0a\u65e5\u4f59\u989d'\u4e3a" + accBalance + "\u5206");
                    info.setLastDayAvlBalance(ParserUtils.convertCentStr2Yuan((String)accBalance));
                }
                if (!StringUtils.isEmpty((String)usableBalance)) {
                    this.logger.info("\u89e3\u6790\u5230\u5de5\u884c\u5e10\u53f7" + accNo + "\u8fd4\u56de\u7684'\u53ef\u7528\u4f59\u989d'\u4e3a" + usableBalance + "\u5206");
                    info.setAvailableBalance(ParserUtils.convertCentStr2Yuan((String)usableBalance));
                }
                if (CommonUtils.isCashPoolAcnt((String)accNo)) {
                    new QFACCTMEASImpl().queryAvailableBalance(info, accNo);
                }
                if (!StringUtils.isNotEmpty((String)freezeBal)) continue;
                info.setFreezeBalance(ParserUtils.convertCentStr2Yuan((String)freezeBal));
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u6279\u91cf\u67e5\u8be2\u4f59\u989d\u62a5\u9519", (Throwable)e);
                info.setError(e.getMessage());
            }
        }
        return new EBBankBalanceResponse(bList);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public int limit() {
        return 10;
    }
}

