/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.area.ICBCArea;
import kd.ebg.aqap.banks.icbc.cmp.card.Card2AreaContext;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.ICBCUseConvertor;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.allocation.AllocationPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.company.CompanyPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.company.SinglePaymentImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.companynew.CompanyNewPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.individual.PAYPERIndividualPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.individualnew.IndividualNewPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.individualnew.PAYPERIndividualNewPayImpl;
import kd.ebg.aqap.banks.icbc.cmp.service.payment.reservefund.ReserveFundPayment;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.MatchTypeEnum;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBBaseException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(PretreatmentImpl.class);

    public void appendData(PaymentInfo paymentInfo) throws EBBaseException {
        paymentInfo = this.pretreatPaymentInfo(paymentInfo);
        this.getBusiImplInfo(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    private PaymentInfo pretreatPaymentInfo(PaymentInfo paymentInfo) throws EBBaseException {
        ICBCUseConvertor.checkUse((PaymentInfo)paymentInfo);
        if (paymentInfo.is2SameBank()) {
            paymentInfo = this.setIncomeAcntAreaInfo(paymentInfo);
        }
        if ("pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType())) {
            paymentInfo.setIndividual(Boolean.valueOf(false));
        }
        return paymentInfo;
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        if (this.isPay_for_agentPay(paymentInfo)) {
            this.set2Company(paymentInfo);
        } else if (this.isPay_for_capital_allocation(paymentInfo)) {
            this.set2Allocation(paymentInfo);
        } else if (this.isPay_for_linkPay(paymentInfo)) {
            this.set2LinkPay(paymentInfo);
        } else if (this.isPay_for_salary(paymentInfo)) {
            this.set2Individual(paymentInfo);
        } else if (this.isPay(paymentInfo)) {
            String reserveFundAccountPool = BankBusinessConfig.getReserveFundAccountPool();
            if (StringUtils.isNotEmpty((String)reserveFundAccountPool) && reserveFundAccountPool.contains(paymentInfo.getIncomeAccNo())) {
                this.setImplClassName(paymentInfo, ReserveFundPayment.class.getName());
            } else if (this.isIndividual(paymentInfo) && this.isIndividualNotToCompany()) {
                this.set2Individual(paymentInfo);
            } else {
                this.set2Company(paymentInfo);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getSubBizTypeCheckMsg((String)paymentInfo.getSubBizType()));
        }
        return busiImplInfo;
    }

    private boolean isIndividualNotToCompany() {
        return this.assertBusinessConfig("icbc_cmp_isIndividualToCompany", "false");
    }

    private PaymentInfo setIncomeAcntAreaInfo(PaymentInfo paymentInfo) throws EBBaseException {
        String incomeAccNo = paymentInfo.getIncomeAccNo();
        Card2AreaContext context = new Card2AreaContext(incomeAccNo);
        try {
            ICBCArea area = context.getICBCArea();
            paymentInfo.setIncomeBankAddress(area.getName());
            paymentInfo.setIncomeCity(area.getName());
            paymentInfo.setIncomeAreaCode(area.getAreaCode());
        }
        catch (Throwable t) {
            log.info(paymentInfo.getIncomeAccNo() + "\u5e94\u8be5\u662f\u975e\u6cd5\u7684\u8d26\u53f7", (Object)t);
        }
        return paymentInfo;
    }

    private boolean isSinglePay() {
        return this.assertBusinessConfig("icbc_cmp_isSinglePay", "true");
    }

    private boolean isPaymetByPerdis() {
        try {
            return BankBusinessConfig.isPaymetByPerdis();
        }
        catch (Exception e) {
            log.error("isPaymetByPerdis fail:", (Throwable)e);
            return false;
        }
    }

    private boolean isUseZipInterface() {
        return this.assertBusinessConfig("icbc_cmp_payment_zip", "true");
    }

    private boolean islinkpayToCommonPay() {
        try {
            return BankBusinessConfig.islinkpayToCommonPay();
        }
        catch (Exception e) {
            log.error("islinkpayToCommonPay fail:", (Throwable)e);
            return false;
        }
    }

    private boolean isLoanAcountTransaction(PaymentInfo paymentInfo) {
        boolean loanAccountPool = BankBusinessConfig.isLoanAccountPool(paymentInfo.getAccNo(), paymentInfo.getIncomeAccNo());
        if (loanAccountPool) {
            this.addRoute(true, "icbc_cmp_LoanAccount_Pool", MatchTypeEnum.CONTAINS.getDesc(), paymentInfo.getAccNo());
            this.addRoute(true, "icbc_cmp_LoanAccount_Pool", MatchTypeEnum.CONTAINS.getDesc(), paymentInfo.getIncomeAccNo());
        }
        return loanAccountPool;
    }

    private void set2Allocation(PaymentInfo paymentInfo) {
        if (this.isLoanAcountTransaction(paymentInfo)) {
            this.set2AllocationDetail(paymentInfo);
        } else {
            this.set2Company(paymentInfo);
        }
    }

    private void set2LinkPay(PaymentInfo paymentInfo) {
        if (this.isIndividual(paymentInfo)) {
            this.set2Individual(paymentInfo);
        } else {
            this.set2Company(paymentInfo);
        }
    }

    private void set2Individual(PaymentInfo paymentInfo) {
        if (this.isIndividualToCompany()) {
            this.set2Company(paymentInfo);
        } else {
            this.set2IndividualDetail(paymentInfo);
        }
    }

    private boolean isIndividualToCompany() {
        return this.assertBusinessConfig("icbc_cmp_isIndividualToCompany", "true");
    }

    private void set2Company(PaymentInfo paymentInfo) {
        this.set2CompanyDetail(paymentInfo);
    }

    private void set2AllocationDetail(PaymentInfo paymentInfo) {
        this.getAllocationImplInfo(paymentInfo);
    }

    private void set2LinkPayDetail(PaymentInfo paymentInfo) {
        this.getLinkPayImplInfo(paymentInfo);
    }

    private void set2IndividualDetail(PaymentInfo paymentInfo) {
        if (this.isSummary()) {
            if (this.isUseZipInterface()) {
                this.getPAYPERCOLIndividualZipImplInfo(paymentInfo);
            } else {
                this.getPAYPERCOLIndividualImplInfo(paymentInfo);
            }
        } else if (this.isFinance()) {
            if (this.isUseZipInterface()) {
                this.getIndividualZipImplInfo(paymentInfo);
            } else {
                this.getIndividualImplInfo(paymentInfo);
            }
        } else if (this.isMerge(paymentInfo)) {
            if (this.isUseZipInterface()) {
                this.getPAYPERCOLIndividualZipImplInfo(paymentInfo);
            } else {
                this.getPAYPERCOLIndividualImplInfo(paymentInfo);
            }
        } else if (this.isUseZipInterface()) {
            this.getIndividualZipImplInfo(paymentInfo);
        } else {
            this.getIndividualImplInfo(paymentInfo);
        }
    }

    private boolean isSummary() {
        return this.assertBusinessConfig("icbc_cmp_isMerge", "summary");
    }

    private boolean isFinance() {
        return this.assertBusinessConfig("icbc_cmp_isMerge", "finance");
    }

    private void set2CompanyDetail(PaymentInfo paymentInfo) {
        if (this.isSinglePay()) {
            this.getSingleCompanyImplInfo(paymentInfo);
        } else if (this.isUseZipInterface()) {
            this.getCompanyZipImplInfo(paymentInfo);
        } else {
            this.getCompanyImplInfo(paymentInfo);
        }
    }

    private void getAllocationImplInfo(PaymentInfo paymentInfo) {
        this.setImplClassName(paymentInfo, AllocationPayImpl.class.getName());
    }

    private void getPAYPERCOLIndividualImplInfo(PaymentInfo paymentInfo) {
        this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
    }

    private void getPAYPERCOLIndividualZipImplInfo(PaymentInfo paymentInfo) {
        this.setImplClassName(paymentInfo, IndividualNewPayImpl.class.getName());
    }

    private void getLinkPayImplInfo(PaymentInfo paymentInfo) {
        this.setImplClassName(paymentInfo, null);
    }

    private void getIndividualImplInfo(PaymentInfo paymentInfo) {
        this.setImplClassName(paymentInfo, PAYPERIndividualPayImpl.class.getName());
    }

    private void getIndividualZipImplInfo(PaymentInfo paymentInfo) {
        this.setImplClassName(paymentInfo, PAYPERIndividualNewPayImpl.class.getName());
    }

    private void getSingleCompanyImplInfo(PaymentInfo paymentInfo) {
        this.setImplClassName(paymentInfo, SinglePaymentImpl.class.getName());
    }

    private void getCompanyImplInfo(PaymentInfo paymentInfo) {
        this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
    }

    private void getCompanyZipImplInfo(PaymentInfo paymentInfo) {
        this.setImplClassName(paymentInfo, CompanyNewPayImpl.class.getName());
    }

    private StringBuilder getCommonPackageKey(PaymentInfo paymentInfo) {
        StringBuilder packageKey = new StringBuilder();
        packageKey.append(paymentInfo.getPackageKey());
        packageKey.append("batch_seq_id=").append(paymentInfo.getBatchSeqId());
        packageKey.append(";");
        return packageKey;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        return null;
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u738b\u6dbf", (String)"PretreatmentImpl_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u6570\u636e\u9884\u5904\u7406\u3002", (String)"PretreatmentImpl_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }
}

