/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ncb.dc.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ncb.dc.helper.Packer;
import kd.ebg.aqap.banks.ncb.dc.helper.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    private static final int PAGE_SIZE = 10;

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/i2sc-client/ClientServlet/client.do");
    }

    public String getDeveloper() {
        return "ychiu";
    }

    public String getBizCode() {
        return "0002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_0", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]);
    }

    public String pack(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = Packer.buildHead((String)"0002", (String)Sequence.gen18Sequence());
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        LinkedHashMap<String, String> parameterMap = new LinkedHashMap<String, String>();
        parameterMap.put("AcctNo", accNo);
        parameterMap.put("AcctCurr", request.getBankCurrency());
        parameterMap.put("StartDate", LocalDateUtil.formatDate((LocalDate)request.getStartDate()));
        parameterMap.put("EndDate", LocalDateUtil.formatDate((LocalDate)request.getEndDate()));
        if ("0".equals(this.getCurrentPage())) {
            this.setCurrentPage("1");
        }
        parameterMap.put("CurrentCount", this.getCurrentPage());
        Packer.buildBody((Element)body, parameterMap);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String rspStr) {
        String currentPage;
        int currentCount;
        this.setLastPage(true);
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserCommonInfo((Element)root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"body");
        String accNo = JDomUtils.getChildText((Element)resBody, (String)"accountNo");
        String currency = JDomUtils.getChildText((Element)resBody, (String)"acct_curr");
        String totalCount = JDomUtils.getChildText((Element)resBody, (String)"total_count");
        Element list = JDomUtils.getChildElement((Element)resBody, (String)"tran_record_list");
        List records = list.getChildren("record");
        if (records.size() == 10 && (currentCount = Integer.parseInt(currentPage = this.getCurrentPage()) + 10) <= Integer.parseInt(totalCount)) {
            this.setLastPage(false);
            this.setCurrentPage(currentCount);
        }
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        for (Element record : records) {
            String balance = record.getChildText("Balance");
            String date = record.getChildText("Date");
            BalanceInfo balanceInfo = new BalanceInfo();
            this.setBankCurrency(balanceInfo, request.getBankCurrency(), currency);
            this.setBankAcnt(balanceInfo, request.getBankAcntList(), accNo);
            this.setCurrentBalance(balanceInfo, balance);
            balanceInfos.add(balanceInfo);
            this.setBalanceDateTime(balanceInfo, date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public LocalDate limitDate() {
        return null;
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        return true;
    }
}

