/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ncb.dc.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ncb.dc.detail.DetailPacker;
import kd.ebg.aqap.banks.ncb.dc.helper.Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/i2sc-client/ClientServlet/client.do");
    }

    public String getDeveloper() {
        return "lwc";
    }

    public String getBizCode() {
        return "0003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        String pageTag = this.getCurrentPage();
        if ("0".equals(pageTag)) {
            pageTag = "1";
            this.setCurrentPage(pageTag);
        }
        return new DetailPacker().packHisDetail(bankDetailRequest, pageTag);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return new EBBankDetailResponse(this.parseDetail(bankDetailRequest, s));
    }

    public boolean isSupportPage() {
        return true;
    }

    public List<DetailInfo> parseDetail(BankDetailRequest request, String rspStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>();
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parserCommonInfo((Element)root);
        if (!this.isLastPage(bankResponse, root)) {
            int nextPageTag = Integer.parseInt(this.getCurrentPage()) + 10;
            this.setCurrentPage(nextPageTag);
        } else {
            this.setLastPage(true);
        }
        if ("000000".equals(bankResponse.getResponseCode())) {
            Element resBody = JDomUtils.getChildElement((Element)root, (String)"body");
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
            Element list = JDomUtils.getChildElement((Element)resBody, (String)"tran_record_list");
            List records = list.getChildren("record");
            String accNo = JDomUtils.getChildText((Element)resBody, (String)"acct_no");
            String accName = JDomUtils.getChildText((Element)resBody, (String)"acct_name");
            for (int i = 0; i < records.size(); ++i) {
                Element record = (Element)records.get(i);
                DetailInfo detail = new DetailInfo();
                try {
                    detail.setCurrency(request.getBankCurrency());
                    detail.setOppAccNo(JDomUtils.getChildText((Element)record, (String)"payee_account_no"));
                    detail.setOppAccName(JDomUtils.getChildText((Element)record, (String)"payee_account_name"));
                    detail.setAccName(accName);
                    detail.setAccNo(accNo);
                    String core_seq_no = JDomUtils.getChildText((Element)record, (String)"core_seq_no");
                    String transferDate = JDomUtils.getChildText((Element)record, (String)"tran_date");
                    String transferTime = JDomUtils.getChildText((Element)record, (String)"tran_time");
                    try {
                        detail.setTransTime(LocalDateTime.parse(transferDate + " " + transferTime, DateTimeFormatter.ofPattern("yyyyMMdd HHmmss")));
                        detail.setTransDate(LocalDateUtil.parserDate((String)transferDate));
                    }
                    catch (Exception e) {
                        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u65f6\u95f4\u8f6c\u6362\u683c\u5f0f\u9519\u8bef\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]), (Throwable)e);
                    }
                    BigDecimal amount = new BigDecimal(JDomUtils.getChildText((Element)record, (String)"tran_amount"));
                    String CDFlag = record.getChildTextTrim("cd_flag");
                    if (CDFlag.equalsIgnoreCase("D")) {
                        detail.setDebitAmount(amount);
                        detail.setCreditAmount(new BigDecimal(0));
                    } else if (CDFlag.equalsIgnoreCase("C")) {
                        detail.setDebitAmount(new BigDecimal(0));
                        detail.setCreditAmount(amount);
                    } else {
                        throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getDetailCDFlagErrorTips((String)CDFlag));
                    }
                    BigDecimal balance = BigDecimalHelper.str2BigDecimalForBalance((String)record.getChildTextTrim("curbal"), (Boolean)true);
                    detail.setBalance(balance);
                    detail.setUseCn(JDomUtils.getChildText((Element)record, (String)"pay_usage"));
                    detail.setExplanation(JDomUtils.getChildText((Element)record, (String)"remark"));
                    String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(record);
                    detail.setJsonMap(jsonStr);
                    detail.setBankDetailNo(core_seq_no);
                    String transDate = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
                    String receiptNo = MatchRule.getInstance().getReceiptNo(request.getAcnt().getAccNo(), transDate, jsonStr);
                    if (countMap.containsKey(receiptNo)) {
                        int count = (Integer)countMap.get(receiptNo) + 1;
                        countMap.put(receiptNo, count);
                        receiptNo = receiptNo + "-" + String.format("%04d", count);
                    } else {
                        countMap.put(receiptNo, 0);
                    }
                    detail.setReceiptNo(receiptNo);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                    continue;
                }
                detailList.add(detail);
            }
        } else if (!"SE50043".equals(bankResponse.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%1$s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-ncb-dc", (Object[])new Object[0]), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        return detailList;
    }

    public boolean isLastPage(BankResponse bankResponse, Element root) {
        if (!"000000".equals(bankResponse.getResponseCode())) {
            this.logger.info("\u6700\u540e\u4e00\u9875\uff1a\u8fd4\u56de\u7801\u4e0d\u662f\u6210\u529f\u7801");
            return true;
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        int currentCount = Integer.parseInt(body.getChildText("current_count"));
        int totalCount = Integer.parseInt(body.getChildText("total_count"));
        Element list = JDomUtils.getChildElement((Element)body, (String)"tran_record_list");
        if (list == null) {
            return true;
        }
        List records = list.getChildren("record");
        if (records == null) {
            return true;
        }
        if (records.size() < 10) {
            this.logger.info("\u5f53\u524d\u7b14\u6570\u5c0f\u4e8e10\uff0c\u4e3a\u6700\u540e\u4e00\u9875");
            return true;
        }
        int currentTotalCount = currentCount - 1 + 10;
        if (currentTotalCount >= totalCount) {
            return true;
        }
        this.logger.info("*****\u5b58\u5728\u4e0b\u4e00\u9875******");
        return false;
    }
}

