/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.apply;

import com.google.common.base.Preconditions;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.apply.atomic.IApply;
import kd.ebg.aqap.business.apply.bank.BankApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankApplyResponse;
import kd.ebg.aqap.business.apply.utils.ApplyConvert;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.entity.biz.apply.CancelApplyRequest;
import kd.ebg.aqap.common.entity.biz.apply.CancelApplyResponse;
import kd.ebg.aqap.common.entity.biz.apply.CancelApplyResponseBody;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import org.slf4j.MDC;

public class CancelApplyMethod
implements EBServiceMethod<CancelApplyRequest, CancelApplyResponse> {
    private BankAcntRepository bankAcntRepository;

    public CancelApplyResponse executeClientRequest(CancelApplyRequest request, EBContext ebContext) {
        CancelApplyResponse response = new CancelApplyResponse();
        Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getAccNo()), (Object)MultiLang.getAccountEmptyTip());
        this.bankAcntRepository = (BankAcntRepository)SpringContextUtil.getBean(BankAcntRepository.class);
        String customID = request.getHeader().getCustomId();
        BankAcnt bankAcnt = this.bankAcntRepository.findByAccNoAndCustomID(request.getBody().getAccNo(), customID);
        if (bankAcnt == null) {
            throw EBExceiptionUtil.preCheckException((String)MultiLang.getAccountIsEmptyTip());
        }
        String bankVersionID = bankAcnt.getBankVersionId();
        if (!("PAB_OPA".equals(bankVersionID) || "GDB_OPA".equals(bankVersionID) || "BOCOM_OPA".equals(bankVersionID))) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u6682\u4e0d\u652f\u6301\u5728\u7ebf\u89e3\u7ea6\u3002", (String)"CancelApplyMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        this.apply(bankVersionID, bankAcnt.getBankLoginId(), request, ebContext, "D");
        CancelApplyResponseBody body = new CancelApplyResponseBody();
        body.setSuccess(true);
        response.setBody(body);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankApplyResponse apply(String bankVersionID, String bankLoginID, CancelApplyRequest request, EBContext context, String applyType) {
        IApply apply = (IApply)BankBundleManager.getInstance().getImpl(bankVersionID, IApply.class, (Object)request);
        context.setBankVersionID(bankVersionID);
        context.setBankLoginID(bankLoginID);
        context.initParameter();
        BankApplyRequest bankApplyRequest = ApplyConvert.convert(request);
        bankApplyRequest.setApplyType(applyType);
        MDC.put((String)"bussiness_type", (String)"bussiness_bank");
        try {
            EBBankApplyResponse eBBankApplyResponse = apply.apply(bankApplyRequest);
            return eBBankApplyResponse;
        }
        finally {
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
        }
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "cancelApply";
    }
}

