/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.apply;

import com.google.common.base.Preconditions;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.apply.atomic.IQueryApply;
import kd.ebg.aqap.business.apply.bank.BankQueryApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankQueryApplyResponse;
import kd.ebg.aqap.business.apply.utils.QueryApplyConvert;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.entity.biz.apply.QueryApplyRequest;
import kd.ebg.aqap.common.entity.biz.apply.QueryApplyResponse;
import kd.ebg.aqap.common.entity.biz.apply.QueryApplyResponseBody;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.utils.file.FieldUtils;
import org.slf4j.MDC;

public class QueryApplyMethod
implements EBServiceMethod<QueryApplyRequest, QueryApplyResponse> {
    private BankAcntRepository bankAcntRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryApplyResponse executeClientRequest(QueryApplyRequest request, EBContext context) {
        EBBankQueryApplyResponse result;
        QueryApplyResponse response = new QueryApplyResponse();
        Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getAccNo()), (Object)MultiLang.getAccountEmptyTip());
        Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getThirdVoucher()), (Object)ResManager.loadKDString((String)"\u7b7e\u7ea6\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryApplyMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        this.bankAcntRepository = (BankAcntRepository)SpringContextUtil.getBean(BankAcntRepository.class);
        BankAcnt bankAcnt = this.bankAcntRepository.findByAccNoAndCustomID(request.getBody().getAccNo(), request.getHeader().getCustomId());
        if (bankAcnt == null) {
            throw EBExceiptionUtil.preCheckException((String)MultiLang.getAccountIsEmptyTip());
        }
        IQueryApply queryApply = (IQueryApply)BankBundleManager.getInstance().getImpl(bankAcnt.getBankVersionId(), IQueryApply.class, (Object)request);
        BankQueryApplyRequest bankQueryApplyRequest = QueryApplyConvert.convert(request);
        context.initParameter();
        MDC.put((String)"bussiness_type", (String)"bussiness_bank");
        try {
            result = queryApply.queryApply(bankQueryApplyRequest);
        }
        finally {
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
        }
        QueryApplyResponseBody responseBody = new QueryApplyResponseBody();
        response.setBody(responseBody);
        FieldUtils.fieldsCopy((Object)((Object)result), (Object)responseBody);
        return response;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "queryApply";
    }
}

