/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balance.atomic;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.atomic.IBalanceTransfer;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.codeless.packer.PackerUtil;
import kd.ebg.aqap.business.codeless.parser.ParseAqapUtil;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.egf.common.codeless.PageUtil.PageLogicUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.bank.impl.AbstractBankXmlImpl;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.service.codeless.CodeLessService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.codeless.CodeLess;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public abstract class AbstractCodelessBalanceImpl
extends AbstractBankXmlImpl
implements IBalanceTransfer,
IBankService<BankBalanceRequest, EBBankBalanceResponse, BankBalanceRequest> {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractCodelessBalanceImpl.class);

    boolean async() {
        return false;
    }

    public EBBankBalanceResponse doBiz(BankBalanceRequest request) {
        EBBankBalanceResponse response;
        if (this.isSupportPage(request)) {
            this.doBizWithPagePre(request);
            response = this.doBizWithPage(request);
        } else {
            response = this.process(request);
        }
        return response;
    }

    public EBBankBalanceResponse doBizWithPage(BankBalanceRequest request) {
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(16);
        String responseStr = null;
        if (this.canDoIt()) {
            String pageTag = this.getFirstPageTag();
            try {
                do {
                    String requestStr = this.packerUtil(request, pageTag);
                    responseStr = this.doBusiness(requestStr);
                    EBContext.getContext().setProcessFlag(PROCESS_PARSE);
                    EBBankBalanceResponse response = this.parserUtil(request, responseStr);
                    pageTag = this.getNextPageTag(responseStr, pageTag);
                    if (!CollectionUtil.isNotEmpty(response.getBalances())) continue;
                    balances.addAll(response.getBalances());
                } while (!this.isLastPage(responseStr, pageTag));
                return new EBBankBalanceResponse(balances);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)MultiLang.getLimitRateTip(this.getBankInterval()));
    }

    public void doBizWithPagePre(BankBalanceRequest request) {
        this.setCurrentPage("0");
        this.setLastPage(false);
    }

    public EBBankBalanceResponse process(BankBalanceRequest request) {
        if (this.canDoIt()) {
            try {
                String requestStr = this.packerUtil(request, null);
                String responseStr = this.doBusiness(requestStr);
                EBContext.getContext().setProcessFlag(PROCESS_PARSE);
                return this.parserUtil(request, responseStr);
            }
            catch (Exception e) {
                EBContext.getContext().setExceptionMsg(e);
                String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"AbstractBalanceImpl_0", (String)"ebg-aqap-business", (Object[])new Object[0]);
                throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
            }
        }
        throw EBExceiptionUtil.serviceException((String)MultiLang.getLimitRateTip(this.getBankInterval()));
    }

    public boolean match(BankBalanceRequest request) {
        return true;
    }

    public long getBankInterval() {
        return 0L;
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        return false;
    }

    public void setCurrentBalance(BalanceInfo balanceInfo, String value) {
        if (!StringUtils.isNotEmpty((String)value)) {
            String errorMsg = ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u62a5\u6587\uff0c\u5f53\u65e5\u4f59\u989d\u5b57\u6bb5\u4e3a\u7a7a\u503c\u3002", (String)"AbstractBalanceImpl_1", (String)"ebg-aqap-business", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        balanceInfo.setCurrentBalance(new BigDecimal(value));
    }

    public void setAvailableBalance(BalanceInfo balanceInfo, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            balanceInfo.setAvailableBalance(new BigDecimal(value));
        }
    }

    public void setLastDayAvlBalance(BalanceInfo balanceInfo, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            balanceInfo.setLastDayAvlBalance(new BigDecimal(value));
        }
    }

    public String doBusiness(String requestStr) {
        String responseStr = null;
        try {
            EBContext.getContext().setProcessFlag(PROCESS_PACK);
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTION);
            Preconditions.checkNotNull((Object)requestStr, (Object)MultiLang.getBankRequestDataEmptyTip());
            ConnectionFactory factory = this.getConnectionFactory();
            IConnection connection = this.getConnection(factory);
            this.openConnection(connection);
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
            try (OutputStream outputStream = this.getOutputStream(connection);){
                this.send(outputStream, requestStr);
                try (InputStream inputStream = this.getInputStream(connection);){
                    responseStr = this.recv(inputStream);
                    EBContext.getContext().setProcessFlag(PROCESS_PARSE);
                }
            }
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            String errorMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u51fa\u73b0\u5f02\u5e38\u3002", (String)"AbstractBalanceImpl_0", (String)"ebg-aqap-business", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
        return responseStr;
    }

    public String getNextPageTag(String rspStr, String pageTag) {
        CodeLess codeless;
        Boolean isPage;
        EBContext context = EBContext.getContext();
        if (context.getCodeLess() == null) {
            String bankVersion = context.getBankVersionID();
            CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCode(bankVersion, "notePayable", this.getBizCode());
            context.setCodeLess(codeLess);
        }
        if (Boolean.TRUE.equals(isPage = (codeless = context.getCodeLess()).getNeedPage())) {
            String nextPage = PageLogicUtil.getNextPage((CodeLess)codeless, (String)rspStr, (String)pageTag);
            return nextPage;
        }
        return "";
    }

    public boolean isLastPage(String rspStr, String pageTag) {
        CodeLess codeless;
        Boolean isPage;
        EBContext context = EBContext.getContext();
        if (context.getCodeLess() == null) {
            String bankVersion = context.getBankVersionID();
            CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCode(bankVersion, "notePayable", this.getBizCode());
            context.setCodeLess(codeLess);
        }
        if (Boolean.TRUE.equals(isPage = (codeless = context.getCodeLess()).getNeedPage())) {
            return PageLogicUtil.isLastPage((CodeLess)codeless, (String)rspStr, (String)pageTag);
        }
        return true;
    }

    public String getFirstPageTag() {
        CodeLess codeless;
        Boolean isPage;
        EBContext context = EBContext.getContext();
        if (context.getCodeLess() == null) {
            String bankVersion = context.getBankVersionID();
            CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCode(bankVersion, "notePayable", this.getBizCode());
            context.setCodeLess(codeLess);
        }
        if (Boolean.TRUE.equals(isPage = (codeless = context.getCodeLess()).getNeedPage())) {
            return codeless.getFirstPage();
        }
        return "0";
    }

    public String packerUtil(BankBalanceRequest request, String pageTag) {
        if (this.isPackerAuto()) {
            String structId = this.getStructIdPacker();
            String rsp = this.packerAuto(request, pageTag, structId);
            return this.getSendMsg(rsp);
        }
        return this.pack(request);
    }

    public String packerAuto(BankBalanceRequest request, String pageTag, String structId) {
        Map map = this.getStructMapPacker();
        map.put("pageTag", pageTag);
        String dateStr = this.getDateStr();
        return PackerUtil.packerBalance(request, map, structId, dateStr);
    }

    public EBBankBalanceResponse parserUtil(BankBalanceRequest request, String responStr) {
        EBBankBalanceResponse response;
        responStr = this.getReceiveMsg(responStr);
        try {
            if (this.isParserAuto()) {
                String structId = this.getStructIdPacker();
                response = new EBBankBalanceResponse(this.parserAuto(request, structId, responStr));
            } else {
                response = this.parse(request, responStr);
            }
        }
        catch (Exception e) {
            logger.error("codeless parser  error :", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)"codeless parser  error :", (Throwable)e);
        }
        if (response != null) {
            String errorMsg = ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"AbstractCodelessBalanceImpl_1", (String)"ebg-aqap-business", (Object[])new Object[0]);
            for (BalanceInfo balanceInfo : response.getBalances()) {
                if (balanceInfo.getCurrentBalance() != null) continue;
                throw EBExceiptionUtil.serviceException((String)errorMsg);
            }
        }
        return response;
    }

    public List<BalanceInfo> parserAuto(BankBalanceRequest request, String structId, String responStr) throws Exception {
        EBContext context = EBContext.getContext();
        if (context.getCodeLess() == null) {
            String bankVersion = context.getBankVersionID();
            CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCode(bankVersion, "notePayable", structId);
            context.setCodeLess(codeLess);
        }
        String dateStr = this.getDateStr();
        return ParseAqapUtil.parseBalance(request, responStr, dateStr, this.isNeedRequestAccn());
    }

    public boolean isNeedRequestAccn() {
        return false;
    }

    public boolean isPackerAuto() {
        return true;
    }

    public boolean isParserAuto() {
        return true;
    }
}

