/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balance.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.entity.biz.balance.Balance;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceRequest;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceResponse;
import kd.ebg.aqap.common.entity.biz.balance.BatchBalanceResponseBody;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBPreCheckException;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class BalanceConvert {
    public static BankBalanceRequest convert(BatchBalanceRequest batchBalanceRequest) {
        String bankCurrency;
        BankBalanceRequest request = new BankBalanceRequest();
        BankHeader header = new BankHeader();
        request.setHeader(header);
        String accNo = batchBalanceRequest.getHeader().getAccNo();
        List accNos = batchBalanceRequest.getBody().getAccNos();
        BankAcnt mainAcnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
        if (accNos.size() == 1 && accNo.equals(accNos.get(0)) && CollectionUtil.isNotEmpty((Collection)batchBalanceRequest.getBody().getPrdSeqs())) {
            mainAcnt.setPrdSeq((String)batchBalanceRequest.getBody().getPrdSeqs().get(0));
        }
        header.setAcnt(mainAcnt);
        header.setBankLoginID(mainAcnt.getBankLoginId());
        header.setBankVersionID(mainAcnt.getBankVersionId());
        header.setBizType(batchBalanceRequest.getHeader().getBizType());
        header.setBizSeqID(batchBalanceRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(batchBalanceRequest.getHeader().getCustomId());
        header.setSubBizType(batchBalanceRequest.getHeader().getSubBizType());
        header.setClientName(batchBalanceRequest.getHeader().getClientName());
        header.setClientVersion(batchBalanceRequest.getHeader().getClientVersion());
        String isoCurrency = batchBalanceRequest.getHeader().getCurrency();
        if (StringUtils.isEmpty((String)isoCurrency)) {
            isoCurrency = mainAcnt.getCurrency();
        }
        if (StringUtils.isEmpty((String)(bankCurrency = CurrencyUtils.convert2Bank((String)isoCurrency)))) {
            throw new EBPreCheckException(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230:%s\u5bf9\u5e94\u7684\u94f6\u884c\u5e01\u79cd\uff0c\u8bf7\u5728\u5e01\u79cd\u7ba1\u7406\u754c\u9762\u7ef4\u62a4\u3002", (String)"BalanceConvert_2", (String)"ebg-aqap-business", (Object[])new Object[0]), isoCurrency));
        }
        header.setBankCurrency(bankCurrency);
        header.setExtData(batchBalanceRequest.getHeader().getExtData());
        String startDateStr = batchBalanceRequest.getBody().getStartDate();
        String endDateStr = batchBalanceRequest.getBody().getEndDate();
        LocalDate startDate = LocalDate.parse(startDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate endDate = LocalDate.parse(endDateStr, DateTimeFormatter.BASIC_ISO_DATE);
        request.setStartDate(startDate);
        request.setEndDate(endDate);
        request.setCurrency(bankCurrency);
        request.setExtData(batchBalanceRequest.getBody().getExtData());
        return request;
    }

    public static BatchBalanceResponse convert(EBBankBalanceResponse bankBalanceResponse) {
        BatchBalanceResponse response = new BatchBalanceResponse();
        BatchBalanceResponseBody body = new BatchBalanceResponseBody();
        response.setBody(body);
        List<BalanceInfo> balances = bankBalanceResponse.getBalances();
        response.setExtData(bankBalanceResponse.getExtData());
        body.setBalances(balances.stream().map(BalanceConvert::convert).collect(Collectors.toList()));
        return response;
    }

    public static Balance convert(BalanceInfo info) {
        Balance balance = new Balance();
        balance.setAccNo(info.getBankAcnt().getAccNo());
        balance.setBalanceDateTime(info.getBalanceDateTime().toString());
        balance.setBalanceID(info.getBalanceID());
        balance.setCurrency(CurrencyUtils.convert2Iso((String)info.getBankCurrency()));
        if (BalanceConvert.isNotNull(info.getCurrentBalance())) {
            balance.setCurrentBalance(String.valueOf(info.getCurrentBalance()));
        }
        if (BalanceConvert.isNotNull(info.getAvailableBalance())) {
            balance.setAvailableBalance(String.valueOf(info.getAvailableBalance()));
        }
        if (BalanceConvert.isNotNull(info.getLastDayAvlBalance())) {
            balance.setLastDayAvailableBalance(String.valueOf(info.getLastDayAvlBalance()));
        }
        if (BalanceConvert.isNotNull(info.getFreezeBalance())) {
            balance.setFreezeBalance(String.valueOf(info.getFreezeBalance()));
        }
        if (BalanceConvert.isNotNull(info.getDepositBalance())) {
            balance.setDepositBalance(String.valueOf(info.getDepositBalance()));
        }
        if (BalanceConvert.isNotNull(info.getLargeDepositBalance())) {
            balance.setLargeDepositBalance(info.getLargeDepositBalance().toPlainString());
        }
        balance.setError(info.getError());
        if (StringUtils.isNotEmpty((String)info.getExtraBankAcnt())) {
            balance.setExtraAccNo(info.getExtraBankAcnt());
        }
        return balance;
    }

    private static boolean isNotNull(BigDecimal obj) {
        return obj != null;
    }
}

