/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balance.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import kd.ebg.aqap.business.balance.atomic.IBatchBalance;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class QueryBalSplitDaysUnit {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryBalSplitDaysUnit.class);
    private static QueryBalSplitDaysUnit instance;

    public static synchronized QueryBalSplitDaysUnit getInstance() {
        if (instance == null) {
            instance = new QueryBalSplitDaysUnit();
        }
        return instance;
    }

    public EBBankBalanceResponse batchBalance(BankBalanceRequest request, IBatchBalance batchBalanceImpl) {
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        bankBalanceResponse.setHeader(request.getHeader());
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(1);
        int queryDays = batchBalanceImpl.queryDays();
        List<BankBalanceRequest> bankBalanceRequests = this.process(request, queryDays);
        for (BankBalanceRequest subBalanceRequest : bankBalanceRequests) {
            try {
                EBBankBalanceResponse response = batchBalanceImpl.batchBalance(subBalanceRequest);
                this.filterBalanceDateTime(subBalanceRequest, response);
                balanceInfoList.addAll(response.getBalances());
            }
            catch (Throwable t) {
                balanceInfoList.addAll(this.dealErrorBalance(subBalanceRequest, t));
            }
        }
        bankBalanceResponse.setBalances(balanceInfoList);
        return bankBalanceResponse;
    }

    public EBBankBalanceResponse hisBalance(BankBalanceRequest request, IHisBalance hisBalanceImpl) {
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        bankBalanceResponse.setHeader(request.getHeader());
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(1);
        int queryDays = hisBalanceImpl.queryDays();
        List<BankBalanceRequest> bankBalanceRequests = this.process(request, queryDays);
        for (BankBalanceRequest subBalanceRequest : bankBalanceRequests) {
            try {
                EBBankBalanceResponse response = hisBalanceImpl.hisBalance(subBalanceRequest);
                this.filterBalanceDateTime(subBalanceRequest, response);
                balanceInfoList.addAll(response.getBalances());
            }
            catch (Throwable t) {
                balanceInfoList.addAll(this.dealErrorBalance(subBalanceRequest, t));
            }
        }
        bankBalanceResponse.setBalances(balanceInfoList);
        return bankBalanceResponse;
    }

    private void filterBalanceDateTime(BankBalanceRequest request, EBBankBalanceResponse response) {
        LocalDateTime startDateTime = request.getStartDate().atTime(LocalTime.MIDNIGHT);
        LocalDateTime endDateTime = request.getEndDate().atTime(LocalTime.MAX);
        ListIterator<BalanceInfo> infoIterator = response.getBalances().listIterator();
        while (infoIterator.hasNext()) {
            BalanceInfo balanceInfo = (BalanceInfo)infoIterator.next();
            if (!balanceInfo.getBalanceDateTime().isBefore(startDateTime) && !balanceInfo.getBalanceDateTime().isAfter(endDateTime)) continue;
            infoIterator.remove();
        }
    }

    private List<BalanceInfo> dealErrorBalance(BankBalanceRequest subBalanceRequest, Throwable t) {
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(1);
        this.logger.error("", t);
        for (BankAcnt bankAcnt : subBalanceRequest.getBankAcntList()) {
            LocalDate date = subBalanceRequest.getStartDate();
            while (!date.isAfter(subBalanceRequest.getEndDate())) {
                BalanceInfo balanceInfo = new BalanceInfo();
                balanceInfo.setBankAcnt(bankAcnt);
                balanceInfo.setBankCurrency(subBalanceRequest.getHeader().getBankCurrency());
                balanceInfo.setBalanceDateTime(date.atTime(LocalTime.MIDNIGHT));
                balanceInfo.setError(EBExceiptionUtil.identifyYEException((Throwable)t));
                balanceInfoList.add(balanceInfo);
                date = date.plusDays(1L);
            }
        }
        return balanceInfoList;
    }

    private List<BankBalanceRequest> process(BankBalanceRequest request, int queryDays) {
        ArrayList<BankBalanceRequest> result = new ArrayList<BankBalanceRequest>(1);
        LocalDate startDate = request.getStartDate();
        LocalDate endDate = request.getEndDate();
        List<LocalDate> splitDays = this.splitByInterval(startDate, endDate, queryDays);
        for (int i = 0; i < splitDays.size() / 2; ++i) {
            BankBalanceRequest subBalanceRequest = new BankBalanceRequest();
            subBalanceRequest.setHeader(request.getHeader());
            subBalanceRequest.setCurrency(request.getCurrency());
            subBalanceRequest.setBankAcntList(request.getBankAcntList());
            subBalanceRequest.setStartDate(splitDays.get(i * 2));
            subBalanceRequest.setEndDate(splitDays.get(i * 2 + 1));
            result.add(subBalanceRequest);
        }
        return result;
    }

    private List<LocalDate> splitByInterval(LocalDate startDate, LocalDate endDate, int intervalInDays) {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(1);
        if (intervalInDays > 0) {
            while (!startDate.isAfter(endDate)) {
                LocalDate currentEndDate = startDate.plusDays(intervalInDays - 1);
                if (currentEndDate.isAfter(endDate)) {
                    currentEndDate = endDate;
                }
                dates.add(startDate);
                dates.add(currentEndDate);
                startDate = currentEndDate.plusDays(1L);
            }
        } else {
            dates.add(startDate);
            dates.add(endDate);
        }
        return dates;
    }
}

