/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balancereconciliation;

import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.CollectionUtils;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.utils.MonthUtil;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationSyncPeriod;
import kd.ebg.aqap.business.balancereconciliation.utils.StatementUtil;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceStatement;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceStatementRequest;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceStatementResponse;
import kd.ebg.aqap.common.entity.biz.balancereconciliation.BalanceStatementResponseBody;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.aqap.common.model.BalanceReconciliationRecord;
import kd.ebg.aqap.common.model.repository.BalanceReconciliationDetailRepository;
import kd.ebg.aqap.common.model.repository.BalanceReconciliationRecordRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BalanceStatementMethod
implements EBServiceMethod<BalanceStatementRequest, BalanceStatementResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceStatementMethod.class);
    private BalanceReconciliationRecordRepository balanceRecordRepository = (BalanceReconciliationRecordRepository)SpringContextUtil.getBean(BalanceReconciliationRecordRepository.class);
    private BalanceReconciliationDetailRepository balanceDetailRepository = (BalanceReconciliationDetailRepository)SpringContextUtil.getBean(BalanceReconciliationDetailRepository.class);

    public BalanceStatementRequest mappingCurrency(BalanceStatementRequest request) {
        String currency = request.getBody().getCurrency();
        currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(currency);
        request.getBody().setCurrency(currency);
        return request;
    }

    public BalanceStatementResponse mappingCurrency(BalanceStatementResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getBalanceStatements();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.stream().forEach(item -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    public BalanceStatementResponse executeClientRequest(BalanceStatementRequest request, EBContext context) {
        AccessUtils.checkQueryAllowed(context);
        this.checkMonth(request);
        List accNos = request.getBody().getAccNos();
        if (CollectionUtils.isEmpty((Collection)accNos)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u5217\u8868\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BalanceStatementMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (accNos.size() > 1000) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u7b14\u6570\u4e0d\u80fd\u8d85\u8fc71000\u3002", (String)"BalanceStatementMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        String currency = request.getBody().getCurrency();
        if (StringUtils.isEmpty((String)currency)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5e01\u79cd\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"BalanceStatementMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (request.getBody().isQueryFromBank()) {
            this.logger.info("\u672c\u6b21\u8bf7\u6c42\u4e3a\u5f3a\u5236\u67e5\u8be2\u94f6\u884c");
        }
        ArrayList<BalanceStatement> balanceStatements = new ArrayList<BalanceStatement>(16);
        LocalDate startMonth = MonthUtil.parserMonth(request.getBody().getStartMonth());
        LocalDate endMonth = MonthUtil.parserMonth(request.getBody().getEndMonth());
        List<BankAcnt> acnts = this.checkBankAcnts(accNos, balanceStatements, currency, startMonth, endMonth);
        String bankVersionID = acnts.get(0).getBankVersionId();
        context.setBankVersionID(bankVersionID);
        IBalanceStatement statement = (IBalanceStatement)BankBundleManager.getInstance().getImpl(context.getBankVersionID(), IBalanceStatement.class, null);
        if (statement == null) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u4e0d\u652f\u6301\u67e5\u8be2\u5f85\u7ecf\u529e\u4f59\u989d\u5bf9\u8d26\u4e1a\u52a1\u3002", (String)"BalanceStatementMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        int monthSpan = statement.getMonthSpan();
        List details = this.balanceDetailRepository.findByCurrencyAndMonthBetweenAndAccNosIn(currency, startMonth, endMonth, accNos);
        Map<String, List<LocalDate>> errorGroupMap = this.transBalanceStatements(details, balanceStatements, request.getBody().isQueryFromBank());
        Map<String, String> accNoBankLoginMap = this.getAccNoBankLoginMap(acnts);
        HashMap<String, List<ReconciliationSyncPeriod>> bankLoginGroupMap = new HashMap<String, List<ReconciliationSyncPeriod>>();
        for (String accNo : accNos) {
            List<ReconciliationSyncPeriod> syncPeriods;
            Set<LocalDate> skipLocalDateSet;
            if (request.getBody().isQueryFromBank()) {
                skipLocalDateSet = this.getSkipLocalDateSet(errorGroupMap.get(accNo));
            } else {
                List records = this.balanceRecordRepository.findByAccNoAndCurrencyAndMonthBetween(accNo, currency, startMonth, endMonth);
                skipLocalDateSet = this.getRecordLocalDateSet(records);
            }
            if (!CollectionUtils.isNotEmpty(syncPeriods = this.getSyncPeriods(monthSpan, accNo, currency, startMonth, endMonth, skipLocalDateSet))) continue;
            String bankLoginId = accNoBankLoginMap.get(accNo);
            if (bankLoginGroupMap.get(bankLoginId) != null) {
                ((List)bankLoginGroupMap.get(bankLoginId)).addAll(syncPeriods);
                continue;
            }
            ArrayList<ReconciliationSyncPeriod> recods = new ArrayList<ReconciliationSyncPeriod>(1);
            recods.addAll(syncPeriods);
            bankLoginGroupMap.put(bankLoginId, recods);
        }
        new StatementUtil().async(bankLoginGroupMap, bankVersionID, currency);
        BalanceStatementResponseBody body = new BalanceStatementResponseBody();
        body.setBalanceStatements(balanceStatements);
        return new BalanceStatementResponse(body);
    }

    Map<String, String> getAccNoBankLoginMap(List<BankAcnt> acnts) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)acnts.size());
        for (BankAcnt bankAcnt : acnts) {
            map.put(bankAcnt.getAccNo(), bankAcnt.getBankLoginId());
        }
        return map;
    }

    private Map<String, List<LocalDate>> transBalanceStatements(List<BalanceReconciliationDetail> details, List<BalanceStatement> balanceStatements, boolean isQueryFromBank) {
        HashMap<String, List<LocalDate>> errorGroupMap = new HashMap<String, List<LocalDate>>();
        if (CollectionUtils.isNotEmpty(details)) {
            for (BalanceReconciliationDetail detail : details) {
                BalanceStatement balanceStatement = new BalanceStatement();
                balanceStatement.setAccNo(detail.getAccNo());
                balanceStatement.setCurrency(detail.getCurrency());
                String monthStr = LocalDateUtil.formatDate((LocalDate)detail.getSyncDate(), (String)"yyyyMM");
                balanceStatement.setMonth(monthStr);
                balanceStatements.add(balanceStatement);
                if (isQueryFromBank && "1".equals(detail.getHandleStatus())) {
                    if (errorGroupMap.get(detail.getAccNo()) != null) {
                        ((List)errorGroupMap.get(detail.getAccNo())).add(detail.getSyncDate());
                    } else {
                        ArrayList<LocalDate> localDates = new ArrayList<LocalDate>(1);
                        localDates.add(detail.getSyncDate());
                        errorGroupMap.put(detail.getAccNo(), localDates);
                    }
                    balanceStatement.setError(String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728\u5e01\u79cd%2$s\u6708\u4efd%3$s\u5df2\u53cd\u9988\uff0c\u4e0d\u5141\u8bb8\u5f3a\u5236\u67e5\u8be2\u94f6\u884c\u3002", (String)"BalanceStatementMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]), detail.getAccNo(), detail.getCurrency(), monthStr));
                    this.logger.info("\u68c0\u6d4b\u5230\u8d26\u53f7{}\u5728\u5e01\u79cd{}\u6708\u4efd{}\u5df2\u53cd\u9988\uff0c\u6b64\u65f6\u8981\u6c42\u5f3a\u5236\u67e5\u8be2\uff0c\u8fd4\u56deerror", new Object[]{detail.getAccNo(), detail.getCurrency(), monthStr});
                    continue;
                }
                balanceStatement.setBalance(detail.getBalance());
                balanceStatement.setFlag(Integer.valueOf(StringUtils.isEmpty((String)detail.getFlag()) ? 0 : Integer.parseInt(detail.getFlag())));
                balanceStatement.setFilePath(detail.getFilePath());
                balanceStatement.setHandleStatus(Integer.valueOf(Integer.parseInt(detail.getHandleStatus())));
                balanceStatement.setStatementNo(detail.getStatementNo());
                balanceStatement.setReserved1(detail.getReserved1());
                balanceStatement.setReserved2(detail.getReserved2());
                balanceStatement.setReserved3(detail.getReserved3());
            }
        }
        return errorGroupMap;
    }

    List<BankAcnt> checkBankAcnts(List<String> accNos, List<BalanceStatement> balanceStatements, String currency, LocalDate startMonth, LocalDate endMonth) {
        ArrayList<BankAcnt> bankAcnts = new ArrayList<BankAcnt>(1);
        Iterator<String> iterator = accNos.iterator();
        while (iterator.hasNext()) {
            String accNo = iterator.next();
            BankAcnt acnt = BankAcntService.getInstance().selectEnableByCustomIDAndAccNo(accNo, EBContext.getContext().getCustomID());
            if (null == acnt) {
                balanceStatements.addAll(this.getBalanceStatement(accNo, currency, startMonth, endMonth, ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u53f7\u672a\u5728\u94f6\u4f01\u4e91\u7ef4\u62a4\u6216\u5df2\u5220\u9664\u3002", (String)"BalanceStatementMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0])));
                this.logger.info("\u68c0\u67e5\u5230\u672a\u7ef4\u62a4\u7684\u94f6\u884c\u8d26\u53f7{}\uff0c\u8fd4\u56deerror", (Object)accNo);
                iterator.remove();
                continue;
            }
            bankAcnts.add(acnt);
        }
        if (bankAcnts.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u4f20\u5165\u7684\u8d26\u53f7\u5217\u8868\u5728\u94f6\u4f01\u4e91\u91cc\u5747\u4e0d\u5b58\u5728\u3002", (String)"BalanceStatementMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        return bankAcnts;
    }

    private List<BalanceStatement> getBalanceStatement(String accNo, String currency, LocalDate startMonth, LocalDate endMonth, String error) {
        ArrayList<BalanceStatement> result = new ArrayList<BalanceStatement>(16);
        LocalDate tempMonth = startMonth;
        while (tempMonth.isBefore(endMonth) || tempMonth.isEqual(endMonth)) {
            BalanceStatement balanceStatement = new BalanceStatement();
            balanceStatement.setAccNo(accNo);
            balanceStatement.setCurrency(currency);
            balanceStatement.setMonth(LocalDateUtil.formatDate((LocalDate)startMonth, (String)"yyyyMM"));
            balanceStatement.setError(error);
            tempMonth = tempMonth.plusMonths(1L);
            result.add(balanceStatement);
        }
        return result;
    }

    public List<ReconciliationSyncPeriod> getSyncPeriods(int monthSpan, String accNo, String currency, LocalDate startDate, LocalDate endDate, Set<LocalDate> skipLocalDateSet) {
        ArrayList<ReconciliationSyncPeriod> result = new ArrayList<ReconciliationSyncPeriod>(16);
        if (monthSpan == 0) {
            monthSpan = 1;
        }
        int bankSize = monthSpan;
        int count = 0;
        LocalDate tempDate = startDate;
        ReconciliationSyncPeriod syncPeriod = new ReconciliationSyncPeriod();
        syncPeriod.setAccNo(accNo);
        syncPeriod.setCurrency(currency);
        while (tempDate.isBefore(endDate) || tempDate.isEqual(endDate)) {
            if (!skipLocalDateSet.contains(tempDate) && count < bankSize) {
                if (count == 0) {
                    syncPeriod = new ReconciliationSyncPeriod();
                    syncPeriod.setAccNo(accNo);
                    syncPeriod.setCurrency(currency);
                    syncPeriod.setStartDate(tempDate);
                    result.add(syncPeriod);
                }
                syncPeriod.setEndDate(tempDate);
                ++count;
            } else if (skipLocalDateSet.contains(tempDate)) {
                count = 0;
            } else if (count >= bankSize) {
                syncPeriod = new ReconciliationSyncPeriod();
                syncPeriod.setAccNo(accNo);
                syncPeriod.setCurrency(currency);
                syncPeriod.setStartDate(tempDate);
                syncPeriod.setEndDate(tempDate);
                result.add(syncPeriod);
                count = 1;
            }
            tempDate = tempDate.plusMonths(1L);
        }
        return result;
    }

    Set<LocalDate> getRecordLocalDateSet(List<BalanceReconciliationRecord> records) {
        HashSet<LocalDate> result = new HashSet<LocalDate>(1);
        if (CollectionUtils.isNotEmpty(records)) {
            for (BalanceReconciliationRecord record : records) {
                result.add(record.getSyncDate());
                this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5e01\u79cd{}\u65e5\u671f{}\u5df2\u7ecf\u67e5\u8be2\u8fc7\u94f6\u884c\uff0c\u672c\u6b21\u4e0d\u5728\u67e5\u8be2", new Object[]{record.getAccNo(), record.getCurrency(), LocalDateUtil.formatDate((LocalDate)record.getSyncDate(), (String)"yyyyMM")});
            }
        }
        return result;
    }

    Set<LocalDate> getSkipLocalDateSet(List<LocalDate> records) {
        HashSet<LocalDate> result = new HashSet<LocalDate>(1);
        if (CollectionUtils.isNotEmpty(records)) {
            for (LocalDate record : records) {
                result.add(record);
            }
        }
        return result;
    }

    void checkMonth(BalanceStatementRequest request) {
        LocalDate endLocalDate;
        LocalDate startLocalDate;
        String startMonth = request.getBody().getStartMonth();
        String endMonth = request.getBody().getEndMonth();
        if (StringUtils.isEmpty((String)startMonth)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5f00\u59cb\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceStatementMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)endMonth)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u7ed3\u675f\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalanceStatementMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        try {
            startLocalDate = MonthUtil.parserMonth(startMonth);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5f00\u59cb\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"BalanceStatementMethod_9", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        try {
            endLocalDate = MonthUtil.parserMonth(endMonth);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u7ed3\u675f\u6708\u4efd\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"BalanceStatementMethod_10", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (startLocalDate.isAfter(endLocalDate)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u5f00\u59cb\u6708\u4efd\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u6708\u4efd\u3002", (String)"BalanceStatementMethod_11", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (endLocalDate.getYear() >= LocalDate.now().getYear() && endLocalDate.getMonthValue() >= LocalDate.now().getMonthValue()) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u7ed3\u675f\u6708\u4efd\u5fc5\u987b\u5c0f\u4e8e\u5f53\u524d\u6708\u4efd\u3002", (String)"BalanceStatementMethod_12", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if (!startLocalDate.plusMonths(12L).isAfter(endLocalDate)) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u6708\u4efd\u8de8\u5ea6\u4e0d\u80fd\u5927\u4e8e12\u3002", (String)"BalanceStatementMethod_13", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "balanceStatement";
    }
}

