/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balancereconciliation.task;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationUtil;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.aqap.common.model.repository.BalanceReconciliationDetailRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import org.slf4j.MDC;

public class BalanceReconciliationTask
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceReconciliationTask.class);
    private BalanceReconciliationDetailRepository balanceDetailRepository = (BalanceReconciliationDetailRepository)SpringContextUtil.getBean(BalanceReconciliationDetailRepository.class);
    private List<BankBalanceReconciliationRequest> requests;
    private EBContext context;

    public BalanceReconciliationTask(List<BankBalanceReconciliationRequest> requests, EBContext context) {
        this.requests = requests;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doBiz() {
        EBContext.setContext((EBContext)this.context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)this.context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        MDC.put((String)"bankVersionID", (String)this.context.getBankVersionID());
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5904\u7406\u4f59\u989d\u53cd\u9988\u5f00\u59cb\uff0ccustomID={},bankLoginID={}", new Object[]{this.context.getCustomID(), this.context.getBankLoginID()});
        String isoCurrency = this.requests.get(0).getDetail().getCurrency();
        if (CollectionUtil.isNotEmpty(this.requests)) {
            String month = LocalDateUtil.formatDate((LocalDate)this.requests.get(0).getDetail().getSyncDate(), (String)"yyyyMM");
            for (BankBalanceReconciliationRequest request : this.requests) {
                try {
                    request.getDetail().setCurrency(request.getHeader().getBankCurrency());
                    this.handle(request, month, isoCurrency);
                }
                catch (Throwable ex) {
                    this.logger.info(ex.getMessage());
                }
                finally {
                    CosmicCache.delete((String)ReconciliationUtil.getCacheKey(request.getDetail().getAccNo(), isoCurrency, month));
                }
            }
        }
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5904\u7406\u4f59\u989d\u53cd\u9988\u7ed3\u675f\uff0ccustomID={},bankLoginID={}", new Object[]{this.context.getCustomID(), this.context.getBankLoginID()});
        return null;
    }

    private void handle(BankBalanceReconciliationRequest request, String month, String isoCurrency) {
        EBBankBalanceReconciliationResponse response;
        BalanceReconciliationDetail detail = request.getDetail();
        this.logger.info("\u5f00\u59cb\u53cd\u9988\u8d26\u53f7{}\u5728\u5e01\u79cd{}\u6708\u4efd{}\u7684\u4f59\u989d\u5bf9\u8d26", new Object[]{detail.getAccNo(), isoCurrency, month});
        EBContext.setContext((EBContext)this.context);
        EBContext.initParameter();
        MDC.put((String)"subBizName", (String)"balanceReconciliation");
        IBalanceReconciliation reconciliation = (IBalanceReconciliation)BankBundleManager.getInstance().getImpl(this.context.getBankVersionID(), IBalanceReconciliation.class, (Object)request);
        FEPAccess access = null;
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            access = FEPAccessUtil.access((String)this.context.getBankVersionID(), (String)this.context.getBankLoginID());
            response = reconciliation.handle(request);
        }
        catch (Throwable ex) {
            try {
                this.logger.info("\u53cd\u9988\u8d26\u53f7{}\u5728\u5e01\u79cd{}\u6708\u4efd{}\u7684\u4f59\u989d\u5bf9\u8d26\u64cd\u4f5c\u5f02\u5e38\uff0c\u7f6e\u4e3a\u4ea4\u6613\u5f02\u5e38\u72b6\u6001\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{detail.getAccNo(), isoCurrency, month, ex.getMessage()});
                this.updateStatusUnknown(request.getDetail(), isoCurrency);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u53cd\u9988\u8d26\u53f7%1$s\u5728\u5e01\u79cd%2$s\u6708\u4efd%3$s\u7684\u4f59\u989d\u5bf9\u8d26\u64cd\u4f5c\u5f02\u5e38\u3002", (String)"BalanceReconciliationTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]), detail.getAccNo(), isoCurrency, month), (Throwable)ex);
            }
            catch (Throwable throwable) {
                FEPAccessUtil.release(access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                throw throwable;
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        BalanceReconciliationDetail detail1 = response.getDetail();
        detail.setCurrency(isoCurrency);
        this.balanceDetailRepository.updateAll(Collections.singletonList(detail1));
    }

    private void updateStatusUnknown(BalanceReconciliationDetail detail, String isoCurrency) {
        ReconciliationBusinessUtil.updateBalanceReconciliationState(detail, BalanceReconciliationState.UNKNOWN);
        detail.setCurrency(isoCurrency);
        this.balanceDetailRepository.updateAll(Collections.singletonList(detail));
    }
}

