/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balancereconciliation.task;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceStatement;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationSyncPeriod;
import kd.ebg.aqap.business.balancereconciliation.utils.StatementUtil;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.BalanceReconciliationService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import org.slf4j.MDC;

public class BalanceStatementTask
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceStatementTask.class);
    private BalanceReconciliationService balanceReconciliationService = (BalanceReconciliationService)SpringContextUtil.getBean(BalanceReconciliationService.class);
    private List<ReconciliationSyncPeriod> details;
    private EBContext context;
    private static String bizType = "balanceStatement";

    public BalanceStatementTask(List<ReconciliationSyncPeriod> details, EBContext context) {
        this.details = details;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doBiz() {
        EBContext.setContext((EBContext)this.context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)this.context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        MDC.put((String)"bankVersionID", (String)this.context.getBankVersionID());
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5904\u7406\u67e5\u8be2\u4f59\u989d\u5bf9\u8d26\u5f85\u529e\u8bb0\u5f55\u5f00\u59cb\uff0ccustomID={},bankLoginID={}", new Object[]{this.context.getCustomID(), this.context.getBankLoginID()});
        String isoCurrency = this.details.get(0).getCurrency();
        String bankCurrency = CurrencyUtils.convert2Bank((String)isoCurrency, (String)this.context.getBankVersionID(), (String)this.context.getCustomID());
        if (CollectionUtil.isNotEmpty(this.details)) {
            for (ReconciliationSyncPeriod detail : this.details) {
                BankBalanceStatementRequest request = this.buildBankBalanceStatementRequest(detail, bankCurrency);
                String key = StatementUtil.getCacheKey(request.getAccNo(), isoCurrency, request.getStartMonth(), request.getEndMonth());
                if (CosmicCache.get((String)key) != null) {
                    this.logger.info("\u68c0\u67e5\u5230\u8d26\u53f7{}\u5e01\u79cd{}\u5728{}-{}\u6b63\u5728\u5904\u7406\u4e2d\uff08\u4e0a\u6b21\u5904\u7406\u65f6\u95f4\u4e3a\uff1a{}\uff09\uff0c\u4e3a\u907f\u514d\u91cd\u590d\u6267\u884c\uff0c\u8df3\u8fc7\u672c\u6b21\u67e5\u8be2", new Object[]{request.getAccNo(), isoCurrency, request.getStartMonth(), request.getEndMonth(), CosmicCache.get((String)key)});
                    continue;
                }
                String timeStr = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS"));
                CosmicCache.putIfAbsentWithExpire((String)key, (String)timeStr, (int)10, (TimeUnit)TimeUnit.MINUTES);
                try {
                    this.handle(request, isoCurrency, bankCurrency);
                }
                catch (Exception ex) {
                    this.logger.error(ex.toString(), (Throwable)ex);
                }
                finally {
                    CosmicCache.delete((String)key);
                }
            }
        }
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5904\u7406\u67e5\u8be2\u4f59\u989d\u5bf9\u8d26\u5f85\u529e\u8bb0\u5f55\u7ed3\u675f\uff0ccustomID={},bankLoginID={}", new Object[]{this.context.getCustomID(), this.context.getBankLoginID()});
        return null;
    }

    BankBalanceStatementRequest buildBankBalanceStatementRequest(ReconciliationSyncPeriod syncPeriod, String bankCurrency) {
        BankBalanceStatementRequest request = new BankBalanceStatementRequest();
        request.setAccNo(syncPeriod.getAccNo());
        request.setCurrency(bankCurrency);
        request.setStartMonth(LocalDateUtil.formatDate((LocalDate)syncPeriod.getStartDate(), (String)"yyyyMM"));
        request.setEndMonth(LocalDateUtil.formatDate((LocalDate)syncPeriod.getEndDate(), (String)"yyyyMM"));
        BankHeader header = new BankHeader();
        header.setBizType(bizType);
        header.setSubBizType(bizType);
        header.setBankCurrency(bankCurrency);
        header.setCustomerID(this.context.getCustomID());
        request.setHeader(header);
        return request;
    }

    private void handle(BankBalanceStatementRequest request, String isoCurrency, String bankCurrency) {
        EBBankBalanceStatementResponse response;
        this.logger.info("\u5f00\u59cb\u67e5\u8be2\u8d26\u53f7{}\u5728\u5e01\u522b{}\u6708\u4efd{}-{}\u7684\u5f85\u7ecf\u529e\u4f59\u989d\u5bf9\u8d26\u8bb0\u5f55", new Object[]{request.getAccNo(), isoCurrency, request.getStartMonth(), request.getEndMonth()});
        EBContext.setContext((EBContext)this.context);
        EBContext.initParameter();
        MDC.put((String)"subBizName", (String)bizType);
        IBalanceStatement statement = (IBalanceStatement)BankBundleManager.getInstance().getImpl(this.context.getBankVersionID(), IBalanceStatement.class, (Object)request);
        FEPAccess access = null;
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            access = FEPAccessUtil.access((String)this.context.getBankVersionID(), (String)this.context.getBankLoginID());
            response = statement.handle(request);
        }
        catch (Exception ex) {
            try {
                this.logger.info("\u67e5\u8be2\u8d26\u53f7{}\u5728\u5e01\u79cd{}\u6708\u4efd{}-{}\u7684\u5f85\u7ecf\u529e\u4f59\u989d\u5bf9\u8d26\u8bb0\u5f55\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", new Object[]{request.getAccNo(), isoCurrency, request.getStartMonth(), request.getEndMonth(), ex.getMessage()});
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u8d26\u53f7%1$s\u5728\u5e01\u79cd%2$s\u6708\u4efd%3$s-%4$s\u7684\u5f85\u7ecf\u529e\u4f59\u989d\u5bf9\u8d26\u8bb0\u5f55\u5f02\u5e38\u3002", (String)"BalanceStatementTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]), request.getAccNo(), isoCurrency, request.getStartMonth(), request.getEndMonth()), (Throwable)ex);
            }
            catch (Throwable throwable) {
                FEPAccessUtil.release(access);
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                throw throwable;
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        List<Object> details = response.getDetails();
        this.logger.info("\u5e01\u522b\u8fc7\u6ee4\u524d\u540c\u6b65\u5230 : {} \u6761\u4f59\u989d\u5bf9\u8d26\u8bb0\u5f55 ", (Object)details.size());
        details = details.stream().filter(d -> bankCurrency.equals(d.getCurrency())).collect(Collectors.toList());
        this.logger.info("\u5e01\u522b\u8fc7\u6ee4\u540e\u540c\u6b65\u5230 : {} \u6761\u4f59\u989d\u5bf9\u8d26\u8bb0\u5f55 ", (Object)details.size());
        if (CollectionUtil.isNotEmpty(details)) {
            for (BalanceReconciliationDetail balanceReconciliationDetail : details) {
                balanceReconciliationDetail.setCurrency(isoCurrency);
                balanceReconciliationDetail.setHandleStatus("0");
                balanceReconciliationDetail.setBankVersionID(this.context.getBankVersionID());
                balanceReconciliationDetail.setBankLoginID(this.context.getBankLoginID());
                balanceReconciliationDetail.setCustomID(this.context.getCustomID());
            }
        }
        Map<String, List<BalanceReconciliationDetail>> collect = details.stream().collect(Collectors.groupingBy(BalanceReconciliationDetail::getAccNo));
        for (Map.Entry<String, List<BalanceReconciliationDetail>> map : collect.entrySet()) {
            List<BalanceReconciliationDetail> detailList = map.getValue();
            this.balanceReconciliationService.insertOrUpdate(request.getStartMonth(), request.getEndMonth(), detailList);
        }
    }
}

