/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balancereconciliation.task;

import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balancereconciliation.atomic.IQueryBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankQueryBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankQueryBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.aqap.common.model.repository.BalanceReconciliationDetailRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import org.slf4j.MDC;

public class QueryBalanceReconciliationTask
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryBalanceReconciliationTask.class);
    private BalanceReconciliationDetailRepository balanceDetailRepository = (BalanceReconciliationDetailRepository)SpringContextUtil.getBean(BalanceReconciliationDetailRepository.class);
    private List<BankQueryBalanceReconciliationRequest> requests;
    private EBContext context;

    public QueryBalanceReconciliationTask(List<BankQueryBalanceReconciliationRequest> requests, EBContext context) {
        this.requests = requests;
        this.context = context;
    }

    public Object doBiz() {
        EBContext.setContext((EBContext)this.context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)this.context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        MDC.put((String)"bankVersionID", (String)this.context.getBankVersionID());
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5904\u7406\u540c\u6b65\u53cd\u9988\u4f59\u989d\u5bf9\u8d26\u7ed3\u679c\u5f00\u59cb\uff0ccustomID={},bankLoginID={}", new Object[]{this.context.getCustomID(), this.context.getBankLoginID()});
        String isoCurrency = this.requests.get(0).getDetail().getCurrency();
        if (CollectionUtil.isNotEmpty(this.requests)) {
            String month = LocalDateUtil.formatDate((LocalDate)this.requests.get(0).getDetail().getSyncDate(), (String)"yyyyMM");
            for (BankQueryBalanceReconciliationRequest request : this.requests) {
                try {
                    request.getDetail().setCurrency(request.getHeader().getBankCurrency());
                    this.handle(request, month, isoCurrency);
                }
                catch (Exception ex) {
                    this.logger.info(ex.getMessage());
                }
            }
        }
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5904\u7406\u540c\u6b65\u53cd\u9988\u4f59\u989d\u5bf9\u8d26\u7ed3\u679c\u7ed3\u675f\uff0ccustomID={},bankLoginID={}", new Object[]{this.context.getCustomID(), this.context.getBankLoginID()});
        return null;
    }

    private void handle(BankQueryBalanceReconciliationRequest request, String month, String isoCurrency) {
        BalanceReconciliationDetail result;
        FEPAccess access;
        block5: {
            BalanceReconciliationDetail detail = request.getDetail();
            this.logger.info("\u5f00\u59cb\u8d26\u53f7{}\u5728\u5e01\u79cd{}\u6708\u4efd{}\u7684\u540c\u6b65\u4f59\u989d\u5bf9\u8d26\u7ed3\u679c", new Object[]{detail.getAccNo(), isoCurrency, month});
            EBContext.setContext((EBContext)this.context);
            EBContext.initParameter();
            MDC.put((String)"subBizName", (String)"queryBalanceReconciliation");
            IQueryBalanceReconciliation reconciliation = (IQueryBalanceReconciliation)BankBundleManager.getInstance().getImpl(this.context.getBankVersionID(), IQueryBalanceReconciliation.class, (Object)request);
            access = null;
            result = detail;
            try {
                MDC.put((String)"bussiness_type", (String)"bussiness_bank");
                access = FEPAccessUtil.access((String)this.context.getBankVersionID(), (String)this.context.getBankLoginID());
                EBBankQueryBalanceReconciliationResponse response = reconciliation.handle(request);
                if (EBContext.getContext().getThrowableAfterSend() != null) {
                    Throwable t = EBContext.getContext().getThrowableAfterSend();
                    ReconciliationBusinessUtil.setBalanceReconciliationState(result, BalanceReconciliationState.UNKNOWN, "", t.getMessage());
                    break block5;
                }
                result = response.getDetail();
            }
            catch (Exception ex) {
                try {
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8d26\u53f7%1$s\u5728\u5e01\u79cd%2$s\u6708\u4efd%3$s\u7684\u540c\u6b65\u4f59\u989d\u5bf9\u8d26\u5f02\u5e38\u3002", (String)"QueryBalanceReconciliationTask_0", (String)"ebg-aqap-business", (Object[])new Object[0]), detail.getAccNo(), isoCurrency, month), (Throwable)ex);
                }
                catch (Throwable throwable) {
                    FEPAccessUtil.release(access);
                    MDC.put((String)"bussiness_type", (String)"bussiness_process");
                    this.save(result, isoCurrency);
                    throw throwable;
                }
            }
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.save(result, isoCurrency);
    }

    private void save(BalanceReconciliationDetail detail, String isoCurrency) {
        detail.setCurrency(isoCurrency);
        detail.setQueryNum(Integer.valueOf(detail.getQueryNum() + 1));
        this.balanceDetailRepository.updateAll(Collections.singletonList(detail));
    }
}

