/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.balancereconciliation.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.task.BalanceReconciliationTask;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ReconciliationUtil {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(ReconciliationUtil.class);
    private static String CACHE_PREFIX = "balance_rec";

    public static String getCacheKey(String accNo, String currency, String monthStr) {
        return CACHE_PREFIX + "_" + accNo + "_" + currency + "_" + monthStr;
    }

    public void async(Map<String, List<BalanceReconciliationDetail>> groupMap) {
        if (!groupMap.isEmpty()) {
            logger.info("\u5f53\u524d\u6709{}\u4e2a\u524d\u7f6e\u673a\u5b58\u5728\u8d26\u53f7\u9700\u53cd\u9988\u4f59\u989d\u5bf9\u8d26", (Object)groupMap.size());
            for (Map.Entry<String, List<BalanceReconciliationDetail>> entry : groupMap.entrySet()) {
                this.submit(entry.getKey(), entry.getValue());
            }
        }
    }

    private void submit(String bankLoginID, List<BalanceReconciliationDetail> details) {
        String bizType = "balanceReconciliation";
        String customId = RequestContext.get().getTenantId();
        String traceId = RequestContext.get().getTraceId();
        if (StringUtils.isEmpty((String)traceId)) {
            traceId = String.valueOf(System.currentTimeMillis());
        }
        logger.info("\u5f53\u524d\u8282\u70b9\u5904\u7406\u53cd\u9988\u4f59\u989d\u5bf9\u8d26traceId\u4e3a" + traceId);
        EBContext oldContext = EBContext.getContext();
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customId).requestSeqID("").bizName(bizType).subBizName(bizType).bankVersionID(details.get(0).getBankVersionID()).bankLoginID(bankLoginID).bizSeqID(oldContext.getBizSeqID()).requestSeqID(oldContext.getRequestSeqID()).logBizSeqID(oldContext.getLogBizSeqID()).logRequestSeqID(oldContext.getLogRequestSeqID()).loggerBatchNo(oldContext.getLogger_batch_no()).loggerDetailNo(oldContext.getLogger_detail_no()).loggerBankNo(oldContext.getLogger_bank_no()).schedule(true).build();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo("");
        context.setBankAcnt(bankAcnt);
        BankHeader header = new BankHeader();
        header.setBizType(bizType);
        header.setSubBizType(bizType);
        String bankCurrency = CurrencyUtils.convert2Bank((String)details.get(0).getCurrency(), (String)context.getBankVersionID(), (String)context.getCustomID());
        header.setBankCurrency(bankCurrency);
        header.setCustomerID(customId);
        List<BankBalanceReconciliationRequest> requests = this.buildBankBalanceReconciliationRequests(details, header);
        logger.info(String.format("\u53cd\u9988\u4f59\u989d\u5bf9\u8d26\u63d0\u4ea4\u7ebf\u7a0b\u6c60\uff08%s,%s\uff09", customId, bankLoginID));
        EBThreadPools.getBalanceReconciliationThreadPool(customId, bankLoginID).submit((Callable)((Object)new BalanceReconciliationTask(requests, context)));
        logger.info("\u63d0\u4ea4\u53cd\u9988\u4f59\u989d\u5bf9\u8d26\u7ebf\u7a0b\u6c60\u6210\u529f\uff08{},{}\uff09", new Object[]{customId, bankLoginID});
    }

    List<BankBalanceReconciliationRequest> buildBankBalanceReconciliationRequests(List<BalanceReconciliationDetail> details, BankHeader header) {
        ArrayList<BankBalanceReconciliationRequest> result = new ArrayList<BankBalanceReconciliationRequest>(details.size());
        for (BalanceReconciliationDetail detail : details) {
            BankBalanceReconciliationRequest request = new BankBalanceReconciliationRequest();
            result.add(request);
            request.setHeader(header);
            request.setDetail(detail);
        }
        return result;
    }
}

