/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.codeless.parser;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.codeless.packer.BussinessToMap;
import kd.ebg.aqap.business.codeless.parser.ParserUtil;
import kd.ebg.egf.common.codeless.PackerUtil.CodeLessUtil;
import kd.ebg.egf.common.codeless.PackerUtil.ResponseCode;
import kd.ebg.egf.common.codeless.ParserUtil.MapToObjectUtil;
import kd.ebg.egf.common.codeless.dateUtil.LocalDateTimeUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;

public class ParseBalanceUtil {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ParseBalanceUtil.class);

    public static List<BalanceInfo> parseBalance(BankBalanceRequest request, String rspStr, String dateStr, boolean isRequestAccno) throws Exception {
        String outResult = ParserUtil.getOuterResultError(rspStr, "QUERY");
        if ("MIDDLE".equals(outResult)) {
            return ParseBalanceUtil.getInnerResult(request, rspStr, dateStr, isRequestAccno);
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s", (String)"ParseCreditUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]), outResult));
    }

    public static List<BalanceInfo> getInnerResult(BankBalanceRequest request, String rspStr, String dateStr, boolean isRequestAccno) throws Exception {
        ResponseCode responseCode;
        String outResult;
        logger.info("\u4f4e\u4ee3\u7801\u5e73\u53f0\u6279\u91cf\u89e3\u6790\u5f00\u59cb");
        boolean isneedInnr = ParserUtil.isNeedInner();
        if (isneedInnr && "FAIL".equals(outResult = (responseCode = ParserUtil.getInnerCode(rspStr, "QUERY")).getResult())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7684\u4ea4\u6613\u72b6\u6001\uff1a%s", (String)"ParseCreditUtil_0", (String)"ebg-aqap-business", (Object[])new Object[0]), outResult));
        }
        List<Map<String, Object>> eachData = ParserUtil.getRepeaterDataWithAttr(rspStr);
        ArrayList<BalanceInfo> details = new ArrayList<BalanceInfo>(1);
        if (eachData == null || eachData.size() == 0) {
            return details;
        }
        List<Map<String, String>> sourceDate = BussinessToMap.getMapBalance(request, "yyyyMMdd");
        Map map = CodeLessUtil.getNeedParam();
        List<Map<String, String>> requestDate = BussinessToMap.getMapBalance(request, dateStr);
        for (Map<String, Object> objectMap : eachData) {
            boolean isPasss = ParserUtil.isPassing(objectMap, sourceDate.get(0));
            if (isPasss) continue;
            BalanceInfo detail = new BalanceInfo();
            ParseBalanceUtil.reloadData(detail, objectMap, map, sourceDate.get(0));
            if (isRequestAccno) {
                detail.setBankAcnt(request.getAcnt());
            }
            details.add(detail);
        }
        return details;
    }

    private static BalanceInfo reloadData(BalanceInfo balanceInfo, Map eachData, Map reflect, Map request) throws Exception {
        Map result = MapToObjectUtil.coventMap((Map)eachData, (Map)reflect);
        Map<String, String> judge = ParserUtil.getParseResultMap(eachData, request);
        result.putAll(judge);
        ParseBalanceUtil.reloadData(balanceInfo, result);
        return balanceInfo;
    }

    private static BalanceInfo reloadData(BalanceInfo balanceInfo, Map eachData) {
        Set set2 = eachData.keySet();
        set2.stream().forEach(key -> {
            String value;
            if ("currentBalance".equals(key)) {
                String value2 = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value2)) {
                    balanceInfo.setCurrentBalance(new BigDecimal(value2));
                }
            } else if ("availableBalance".equals(key)) {
                String value3 = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value3)) {
                    balanceInfo.setAvailableBalance(new BigDecimal(value3));
                }
            } else if ("balanceDateTime".equals(key)) {
                String value4 = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value4)) {
                    value4 = value4.replaceAll("-", "");
                    balanceInfo.setBalanceDateTime(LocalDateTimeUtil.tryParse((String)value4));
                }
            } else if ("accNo".equals(key)) {
                String value5 = (String)eachData.get(key);
                if (!StringUtils.isEmpty((String)value5)) {
                    BankAcnt acnt = new BankAcnt();
                    acnt.setAccNo(value5);
                    balanceInfo.setBankAcnt(acnt);
                }
            } else if ("currency".equals(key) && !StringUtils.isEmpty((String)(value = (String)eachData.get(key)))) {
                balanceInfo.setBankCurrency(value);
            }
        });
        return balanceInfo;
    }
}

