/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.credit;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.codeless.CodeLessRouteAqapUtil;
import kd.ebg.aqap.business.credit.openCredit.util.OpenCreditConvert;
import kd.ebg.aqap.business.credit.openCredit.util.OpenCreditUtil;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.business.payment.cache.CachePayStorage;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.common.entity.biz.credit.openCredit.OpenCreditRequest;
import kd.ebg.aqap.common.entity.biz.credit.openCredit.OpenCreditResponse;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.framework.services.OpenCreditService;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.file.PayAttachmentService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.codeless.CodeLessRoute;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class OpenCreditMethod
implements EBServiceMethod<OpenCreditRequest, OpenCreditResponse> {
    EBGLogger logger = EBGLogger.getInstance().getLogger(OpenCreditMethod.class);

    public OpenCreditRequest mappingCurrency(OpenCreditRequest request) {
        List list = request.getBody().getDetails();
        HashMap currencyMap = new HashMap(16);
        list.stream().forEach(item -> {
            String currency = item.getCurrency();
            currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(currency, currencyMap);
            item.setCurrency(currency);
        });
        return request;
    }

    public OpenCreditResponse executeClientRequest(OpenCreditRequest request, EBContext context) throws MalformedURLException {
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        AccessUtils.checkQueryAllowed(context);
        String dky = "";
        Set<List<OpenCreditDetail>> set = null;
        List<OpenCreditDetail> openCreditDetails = null;
        try {
            this.logger.info("\u6570\u636e\u6821\u9a8c\u5f00\u59cb");
            this.checkStructure(request);
            String batchSeqID = request.getBody().getBatchSeqId();
            dky = request.getHeader().getCustomId() + "_" + batchSeqID;
            this.logger.info("\u8bbf\u95ee\u6570\u636e\u5e93");
            this.checkBatchSeqIDUnique(batchSeqID);
            this.logger.info("\u6570\u636e\u6821\u9a8c\u5b8c\u6210");
            openCreditDetails = OpenCreditConvert.convertPay(request);
            String subBizType = request.getHeader().getSubBizType();
            String bankVersionId = EBContext.getContext().getBankVersionID();
            CodeLessRoute codeLessRoute = CodeLessRouteAqapUtil.getCodelessRouteCredit(bankVersionId, subBizType);
            this.logger.info("\u9884\u5904\u7406\u6570\u636e");
            if (CodeLessRouteAqapUtil.isCodeless(codeLessRoute)) {
                OpenCreditUtil.preTreatmentCodeless(openCreditDetails, codeLessRoute);
            } else {
                OpenCreditUtil.preTreatment(openCreditDetails);
            }
            set = OpenCreditConvert.packagePay(openCreditDetails, codeLessRoute);
            OpenCreditConvert.reloadData(set);
            this.logger.info("\u63d2\u5165\u6570\u636e");
            this.handlePayAttachment(openCreditDetails);
            OpenCreditUtil.insertPay(openCreditDetails);
        }
        catch (Throwable t) {
            this.logger.error("\u5f00\u8bc1\u5f02\u5e38", t);
            throw EBExceiptionUtil.preCheckException((String)t.getMessage(), (Throwable)t);
        }
        try {
            OpenCreditUtil.async(set, (EBRequest)request, context.getAcnt());
            OpenCreditResponse t = OpenCreditConvert.convertToResponse(openCreditDetails, request);
            return t;
        }
        catch (Throwable t) {
            this.logger.error("service\u5f02\u5e38", t);
            throw EBExceiptionUtil.serviceException((String)t.getMessage(), (Throwable)t);
        }
        finally {
            CachePayStorage.release(dky);
        }
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "openCredit";
    }

    private void checkStructure(OpenCreditRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (String)"OpenCreditMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u4e0d\u80fd\u4e3a\u7a7a", (String)"OpenCreditMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42 body \u4e0d\u80fd\u4e3a\u7a7a", (String)"OpenCreditMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u5f00\u8bc1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"OpenCreditMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)MultiLang.getBatchNotEmptyTip());
        Preconditions.checkState((!OpenCreditService.getInstance().batchSeqIDExist(batchSeqID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"batchSeqID \u5df2\u7ecf\u5b58\u5728\u3002", (String)"OpenCreditMethod_5", (String)"ebg-aqap-business", (Object[])new Object[0]));
    }

    private void handlePayAttachment(List<OpenCreditDetail> openCreditDetails) {
        for (int i = 0; i < openCreditDetails.size(); ++i) {
            ArrayList<PayAttachment> attachments = new ArrayList<PayAttachment>(openCreditDetails.size());
            OpenCreditDetail paymentInfo = openCreditDetails.get(i);
            String fileList = paymentInfo.getFileList();
            if (StringUtils.isNotEmpty((String)fileList)) {
                String[] fileLists;
                for (String fileUrl : fileLists = fileList.split(";")) {
                    PayAttachment payAttachment = new PayAttachment();
                    payAttachment.setCustomID(paymentInfo.getCustomID());
                    payAttachment.setBankVersionID(paymentInfo.getBankVersionID());
                    payAttachment.setBankLoginID(paymentInfo.getBankLoginID());
                    payAttachment.setBankBatchSeqID(paymentInfo.getBankBatchSeqId());
                    payAttachment.setBankDetailSeqID(paymentInfo.getBankDetailSeqId());
                    try {
                        fileUrl = URLDecoder.decode(fileUrl, "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                    payAttachment.setDownloadUrl(fileUrl);
                    String path = fileUrl.substring(fileUrl.lastIndexOf("path=/") + 6);
                    payAttachment.setFilePath(path);
                    payAttachment.setFileName(path.substring(path.lastIndexOf("/") + 1));
                    payAttachment.setStatus(Integer.valueOf(AttachmentState.INITIAL.getId()));
                    payAttachment.setStatusName(AttachmentState.INITIAL.getEnName());
                    payAttachment.setStatusMsg(AttachmentState.INITIAL.getCnName());
                    payAttachment.setEnable(Integer.valueOf(Integer.parseInt("1")));
                    payAttachment.setQueryImplClassName("");
                    payAttachment.setInsertTime(LocalDateTime.now());
                    payAttachment.setUpdateTime(LocalDateTime.now());
                    attachments.add(payAttachment);
                }
            }
            if (attachments.size() <= 0) continue;
            PayAttachmentService attachmentService = (PayAttachmentService)SpringContextUtil.getBean(PayAttachmentService.class);
            attachmentService.saveAttachments(attachments);
        }
    }
}

