/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.credit;

import java.net.MalformedURLException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.codeless.CodeLessRouteAqapUtil;
import kd.ebg.aqap.business.credit.queryCredit.QueryCreditTypeUtil;
import kd.ebg.aqap.business.credit.queryCredit.atomic.CodelessCreditQueryImpl;
import kd.ebg.aqap.business.credit.queryCredit.atomic.ICreditDetail;
import kd.ebg.aqap.business.credit.queryCredit.atomic.ICreditDetailPretreat;
import kd.ebg.aqap.business.credit.queryCredit.bank.BankQueryCreditDetailRequest;
import kd.ebg.aqap.business.credit.queryCredit.bank.BankQueryCreditDetailResponse;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.common.entity.biz.credit.Credit;
import kd.ebg.aqap.common.entity.biz.credit.QueryCreditRequest;
import kd.ebg.aqap.common.entity.biz.credit.QueryCreditResponse;
import kd.ebg.aqap.common.entity.biz.credit.QueryCreditResponseBody;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.codeless.CodeLessRoute;
import kd.ebg.egf.common.model.codeless.RouteBody;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class QueryCreditMethod
implements EBServiceMethod<QueryCreditRequest, QueryCreditResponse> {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QueryCreditMethod.class);

    public QueryCreditResponse mappingCurrency(QueryCreditResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getCredits();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.stream().forEach(item -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    public QueryCreditResponse executeClientRequest(QueryCreditRequest request, EBContext context) throws MalformedURLException {
        AccessUtils.checkQueryAllowed(context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        EBContext.initParameter();
        String subBizType = request.getHeader().getSubBizType();
        String bizType = QueryCreditTypeUtil.INSTANCE.convertCodelessType(subBizType);
        String bankVersionId = EBContext.getContext().getBankVersionID();
        CodeLessRoute codeLessRoute = CodeLessRouteAqapUtil.getCodelessRouteCredit(bankVersionId, bizType);
        if (CodeLessRouteAqapUtil.isCodeless(codeLessRoute)) {
            return this.doCodelessRoute(request, context, codeLessRoute);
        }
        return this.doCustomBusiness(request, context);
    }

    private QueryCreditResponse doCodelessRoute(QueryCreditRequest request, EBContext context, CodeLessRoute codeLessRoute) {
        log.info("\u4f7f\u7528\u65e0\u4ee3\u7801\u8def\u7531\u65b9\u6848\u5904\u7406\u4e1a\u52a1\uff0c\u8def\u7531\u7f16\u53f7\uff1a" + codeLessRoute.getNumber());
        CodelessCreditQueryImpl impl = new CodelessCreditQueryImpl();
        List routeBodies = codeLessRoute.getRouteBodies();
        if (routeBodies == null || routeBodies.size() == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u8def\u7531\u7ed3\u6784\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5", (String)"QueryCreditMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        FEPAccess access = null;
        BankQueryCreditDetailResponse response = null;
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
            response = impl.doBiz(this.buildRequest(context.getAcnt(), request), (RouteBody)routeBodies.get(0));
        }
        catch (Throwable e) {
            try {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                log.error("\u4fe1\u7528\u8bc1\u67e5\u8be2\u5f02\u5e38", e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u67e5\u8be2\u5f02\u5e38,", (String)"QueryCreditMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                FEPAccessUtil.release(access);
                throw throwable;
            }
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        FEPAccessUtil.release((FEPAccess)access);
        return this.buildResponse(response);
    }

    private QueryCreditResponse doCustomBusiness(QueryCreditRequest request, EBContext context) {
        FEPAccess access = null;
        ICreditDetail detail = null;
        String bankVersionId = EBContext.getContext().getBankVersionID();
        ICreditDetailPretreat pretreat = (ICreditDetailPretreat)BankBundleManager.getInstance().getImpl(bankVersionId, ICreditDetailPretreat.class, (Object)request);
        if (pretreat == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u627e\u5230ICreditDetailPretreat\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\u5b9e\u73b0", (String)"QueryCreditMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        pretreat.appendData(request);
        String implClassName = request.getImplClassName();
        detail = (ICreditDetail)BankBundleManager.getInstance().getImplByClassName(bankVersionId, ICreditDetail.class, implClassName);
        if (detail == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u672a\u627e\u5230ICreditDetail\u5b9e\u73b0\u7c7b\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\u5b9e\u73b0", (String)"QueryCreditMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        BankQueryCreditDetailResponse response = null;
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
            response = detail.detail(this.buildRequest(context.getAcnt(), request));
        }
        catch (Throwable e) {
            try {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                log.error("\u4fe1\u7528\u8bc1\u67e5\u8be2\u5f02\u5e38", e);
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4fe1\u7528\u8bc1\u67e5\u8be2\u5f02\u5e38,", (String)"QueryCreditMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                FEPAccessUtil.release(access);
                throw throwable;
            }
        }
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        FEPAccessUtil.release((FEPAccess)access);
        return this.buildResponse(response);
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "queryCredit";
    }

    private BankQueryCreditDetailRequest buildRequest(BankAcnt acnt, QueryCreditRequest detailRequest) {
        BankQueryCreditDetailRequest request = new BankQueryCreditDetailRequest();
        request.setCurrency(detailRequest.getHeader().getCurrency());
        BankHeader header = new BankHeader();
        request.setHeader(header);
        header.setAcnt(acnt);
        header.setBizType(detailRequest.getHeader().getBizType());
        header.setSubBizType(detailRequest.getHeader().getSubBizType());
        header.setClientName(detailRequest.getHeader().getClientName());
        header.setClientVersion(detailRequest.getHeader().getClientVersion());
        header.setExtData(detailRequest.getHeader().getExtData());
        header.setBankVersionID(acnt.getBankVersionId());
        header.setBankLoginID(acnt.getBankLoginId());
        header.setBizSeqID(detailRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(detailRequest.getHeader().getCustomId());
        request.setCreditNo(detailRequest.getBody().getCreditNo());
        request.setApplicantCreditNum(detailRequest.getBody().getApplicantCreditNum());
        request.setBatchSeqId(detailRequest.getBody().getBatchSeqId());
        if (!StringUtils.isEmpty((String)detailRequest.getBody().getStartDate())) {
            request.setStartDate(LocalDate.parse(detailRequest.getBody().getStartDate(), DateTimeFormatter.ofPattern("yyyyMMdd").withLocale(Locale.CHINA)));
        }
        if (!StringUtils.isEmpty((String)detailRequest.getBody().getEndDate())) {
            request.setEndDate(LocalDate.parse(detailRequest.getBody().getEndDate(), DateTimeFormatter.ofPattern("yyyyMMdd").withLocale(Locale.CHINA)));
        }
        request.setPageNum(detailRequest.getBody().getPageNum());
        return request;
    }

    private QueryCreditResponse buildResponse(BankQueryCreditDetailResponse ebBankDetailResponse) {
        QueryCreditResponse detailResponse = new QueryCreditResponse();
        QueryCreditResponseBody detailResponseBody = new QueryCreditResponseBody();
        detailResponse.setBody(detailResponseBody);
        detailResponseBody.setBatchSeqId(ebBankDetailResponse.getBatchSeqId());
        if (ebBankDetailResponse.getCredits() != null) {
            detailResponseBody.setPagesTotalCount(ebBankDetailResponse.getCredits().size());
        } else {
            detailResponseBody.setPagesTotalCount(0);
        }
        List<Credit> credits = ebBankDetailResponse.getCredits();
        for (Credit credit : credits) {
            String value;
            String bankCurrency = "";
            if (StringUtils.isNotEmpty((String)credit.getCurrency())) {
                bankCurrency = CurrencyUtils.convert2Iso((String)credit.getCurrency());
                credit.setCurrency(bankCurrency);
            }
            if (StringUtils.isNotEmpty((String)credit.getCharCurrency())) {
                bankCurrency = CurrencyUtils.convert2Iso((String)credit.getCharCurrency());
                credit.setCharCurrency(bankCurrency);
            }
            if (StringUtils.isNotEmpty((String)credit.getOpenDate())) {
                value = credit.getOpenDate();
                value = value.replaceAll("-", "");
                credit.setOpenDate(value);
            }
            if (!StringUtils.isNotEmpty((String)credit.getDueDate())) continue;
            value = credit.getDueDate();
            value = value.replaceAll("-", "");
            credit.setDueDate(value);
        }
        detailResponseBody.setCredits(credits);
        detailResponseBody.setKeepFlag(ebBankDetailResponse.getKeepFlag());
        detailResponseBody.setPageNum(ebBankDetailResponse.getPageNum() + "");
        return detailResponse;
    }
}

