/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.credit;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.credit.openCredit.util.OpenCreditConvert;
import kd.ebg.aqap.business.credit.openCredit.util.QueryOpenCreditUtil;
import kd.ebg.aqap.business.payment.cache.CacheQueryPayStorage;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.common.entity.biz.credit.queryOpenCredit.QueryOpenCreditRequest;
import kd.ebg.aqap.common.entity.biz.credit.queryOpenCredit.QueryOpenCreditResponse;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.services.OpenCreditService;
import kd.ebg.aqap.common.model.OpenCreditDetail;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.slf4j.MDC;

public class QueryOpenCreditMethod
implements EBServiceMethod<QueryOpenCreditRequest, QueryOpenCreditResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryOpenCreditMethod.class);

    public QueryOpenCreditResponse executeClientRequest(QueryOpenCreditRequest request, EBContext context) throws MalformedURLException {
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        AccessUtils.checkQueryAllowed(context);
        String batchSeqID = request.getBody().getBatchSeqId();
        String forceQuery = request.getBody().getForceQuery();
        this.logger.info("\u540c\u6b65\u6279\u6b21\u53f7\uff1a" + batchSeqID);
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)ResManager.loadKDString((String)"\u6279\u6b21\u6d41\u6c34\u53f7 \u4e0d\u80fd\u4e3a\u7a7a", (String)"QueryOpenCreditMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        List infos = OpenCreditService.getInstance().selectByBatchSeqID(batchSeqID);
        if (infos.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)"unknown_batch", (String)String.format(ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u6279\u6b21\u53f7: %s", (String)"QueryOpenCreditMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]), batchSeqID));
        }
        String customId = request.getHeader().getCustomId();
        String key = customId + batchSeqID;
        boolean isHasSubmitting = infos.stream().anyMatch(info -> info.getStatus().intValue() == PaymentState.SUBMITTING.getId());
        if (!CacheQueryPayStorage.checkRepeat(key)) {
            if (isHasSubmitting) {
                this.logger.info("\u4ed8\u6b3e\u72b6\u6001\u63d0\u4ea4\u4e2d\uff0c\u7279\u6b8a\u5904\u7406");
                LocalDateTime submitSuccessTime = ((OpenCreditDetail)infos.get(0)).getSubmitSuccessTime();
                Duration duration = Duration.between(submitSuccessTime, LocalDateTime.now());
                long minutes = duration.toMinutes();
                if (minutes > 20L) {
                    for (OpenCreditDetail info2 : infos) {
                        if (info2.getStatus().intValue() != PaymentState.SUBMITTING.getId()) continue;
                        info2.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                        info2.setStatusName(PaymentState.UNKNOWN.getEnName());
                        info2.setStatusMsg(String.format(ResManager.loadKDString((String)"%s,\u63d0\u4ea4\u4e2d\u72b6\u6001\u6301\u7eed\u5df2\u8d85\u8fc720\u5206\u949f", (String)"QueryOpenCreditMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]), PaymentState.UNKNOWN.getCnName()));
                    }
                    this.logger.info("\u4ed8\u6b3e\u72b6\u6001\u63d0\u4ea4\u4e2d\u8d85\u8fc720\u5206\u949f\uff0c\u7279\u6b8a\u5904\u7406");
                    Set<List<OpenCreditDetail>> paymentInfoSet = QueryOpenCreditUtil.setOfPay(infos);
                    QueryOpenCreditUtil.async(paymentInfoSet, (EBRequest)request, context.getAcnt(), forceQuery);
                }
            } else if (((OpenCreditDetail)infos.get(0)).getStatus().intValue() == PaymentState.PACKAGED.getId()) {
                this.logger.info("\u8be5\u7b14\u5904\u4e8e\u6253\u5305\u72b6\u6001\uff0c\u65e0\u6cd5\u540c\u6b65");
            } else if (!this.isNeedQuery(infos)) {
                if ("1".equals(forceQuery)) {
                    Set<List<OpenCreditDetail>> paymentInfoSet = QueryOpenCreditUtil.setOfPay(infos);
                    QueryOpenCreditUtil.async(paymentInfoSet, (EBRequest)request, context.getAcnt(), forceQuery);
                }
            } else {
                this.logger.info("\u5524\u9192\u540c\u6b65\u7ebf\u7a0b\u8fdb\u884c\u540c\u6b65");
                Set<List<OpenCreditDetail>> paymentInfoSet = QueryOpenCreditUtil.setOfPay(infos);
                QueryOpenCreditUtil.async(paymentInfoSet, (EBRequest)request, context.getAcnt(), forceQuery);
            }
        } else {
            if ("1".equals(forceQuery)) {
                Set<List<OpenCreditDetail>> paymentInfoSet = QueryOpenCreditUtil.setOfPay(infos);
                QueryOpenCreditUtil.async(paymentInfoSet, (EBRequest)request, context.getAcnt(), forceQuery);
            }
            this.logger.info("\u5f53\u524d\u6279\u6b21\u5df2\u7ecf\u5b58\u5728\u540c\u6b65\u67e5\u8be2\u7684\u8bf7\u6c42\uff0c\u672c\u6b21\u8bf7\u6c42\u4e0d\u751f\u6548");
        }
        return OpenCreditConvert.convertToQueryResponse(infos, request);
    }

    boolean isNeedQuery(List<OpenCreditDetail> infos) {
        for (OpenCreditDetail info : infos) {
            if (info.getStatus().intValue() == PaymentState.SUCCESS.getId() || info.getStatus().intValue() == PaymentState.FAIL.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "openCreditQuery";
    }
}

