/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.currentandfixed;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.business.currentandfixed.CurAndFixedBizType;
import kd.ebg.aqap.business.currentandfixed.cache.CacheCafStorage;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.business.currentandfixed.util.CheckUtil;
import kd.ebg.aqap.business.currentandfixed.util.CurAndFixedConvert;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurAndFixedRespDetail;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurrentAndFixedRequest;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurrentAndFixedResponse;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.withdraw.CurrentAndFixedExRequest;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.withdraw.CurrentAndFixedExResponse;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.withdraw.CurrentAndFixedReqBody;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.withdraw.CurrentAndFixedRespBody;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.withdraw.WithdrawFromNAccReqDetail;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.withdraw.WithdrawFromNAccRespDetail;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.services.CurAndFixedService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBDuplicateException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class CafWithdrawNAccMethod
implements EBServiceMethod<CurrentAndFixedExRequest, CurrentAndFixedExResponse> {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CafWithdrawNAccMethod.class);

    public CurrentAndFixedExRequest mappingCurrency(CurrentAndFixedExRequest request) {
        List list = request.getBody().getDetails();
        HashMap currencyMap = new HashMap(16);
        list.stream().forEach(item -> {
            String currency = item.getCurrency();
            currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(currency, currencyMap);
            item.setCurrency(currency);
        });
        return request;
    }

    public CurrentAndFixedExResponse mappingCurrency(CurrentAndFixedExResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getDetails();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.stream().forEach(item -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CurrentAndFixedExResponse executeClientRequest(CurrentAndFixedExRequest currentAndFixedExRequest, EBContext ebContext) throws MalformedURLException {
        String bankVersionID = ebContext.getBankVersionID();
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        String batchSeqID = "";
        String dbk = "";
        try {
            try {
                this.checkStructure(currentAndFixedExRequest);
                batchSeqID = currentAndFixedExRequest.getBody().getBatchSeqId();
                this.checkBatchSeqIDUnique(batchSeqID);
                this.checkBizNo(currentAndFixedExRequest);
            }
            catch (IllegalArgumentException e) {
                throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
            }
            catch (EBDuplicateException e) {
                throw EBExceiptionUtil.duplicateException((String)e.getMessage(), (Throwable)e);
            }
            CurAndFixedService service = CurAndFixedService.getInstance();
            List bizReqDetails = currentAndFixedExRequest.getBody().getDetails();
            WithdrawFromNAccReqDetail bizReqDetail = (WithdrawFromNAccReqDetail)bizReqDetails.get(0);
            String reqNbr = bizReqDetail.getReqNbr();
            Preconditions.checkArgument((!StringUtils.isEmpty((String)reqNbr) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"reqNbr\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CafWithdrawNAccMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
            currentAndFixedExRequest.getHeader().setBankVersion(bankVersionID);
            List<CurAndFixedInfo> curAndFixedInfos = this.transform(bizReqDetails, currentAndFixedExRequest);
            CurAndFixedInfo reqCafInfo = curAndFixedInfos.get(0);
            List pre = service.findByReqNbr(reqNbr, CurAndFixedBizType.CURRENT_TO_NOTICE.getName());
            Preconditions.checkArgument((pre.size() == 1 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u6d3b\u8f6c\u901a\u77e5\u8bb0\u5f55\u3002", (String)"CafWithdrawNAccMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
            CurAndFixedInfo p = (CurAndFixedInfo)pre.get(0);
            reqCafInfo.setFixedAcntBankNo(p.getFixedAcntBankNo());
            reqCafInfo.setFixedAcntBank(p.getFixedAcntBank());
            CAFUtil.preTreatment(curAndFixedInfos, bankVersionID);
            Set<List<CurAndFixedInfo>> set = CAFUtil.packageCaf(curAndFixedInfos);
            String key = currentAndFixedExRequest.getHeader().getCustomId() + "_" + batchSeqID;
            if (!CacheCafStorage.checkRepeat(key)) {
                CAFUtil.insertAll(curAndFixedInfos);
                CurrentAndFixedRequest r = new CurrentAndFixedRequest();
                r.setHeader(currentAndFixedExRequest.getHeader());
                CAFUtil.async(set, (EBRequest)r);
            } else {
                this.logger.error("\u63a5\u53e3\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u4e1a\u52a1\u6279\u6b21\u53f7\uff1a ", new Object[]{batchSeqID});
            }
            CurrentAndFixedExResponse currentAndFixedExResponse = CafWithdrawNAccMethod.convert(CurAndFixedConvert.convertToResponse(curAndFixedInfos, currentAndFixedExRequest.getHeader()));
            return currentAndFixedExResponse;
        }
        finally {
            CacheCafStorage.release(dbk);
        }
    }

    public static CurrentAndFixedExResponse convert(CurrentAndFixedResponse response) {
        CurrentAndFixedExResponse res = new CurrentAndFixedExResponse();
        res.setHeader(response.getHeader());
        List details = response.getBody().getDetails();
        CurrentAndFixedRespBody body = new CurrentAndFixedRespBody();
        ArrayList<WithdrawFromNAccRespDetail> lists = new ArrayList<WithdrawFromNAccRespDetail>(1);
        body.setDetails(lists);
        for (CurAndFixedRespDetail detail : details) {
            WithdrawFromNAccRespDetail wfar = new WithdrawFromNAccRespDetail();
            wfar.setAccNo(detail.getAccNo());
            wfar.setAccName(detail.getAccName());
            wfar.setFixedAccNo(detail.getFixedAccNo());
            wfar.setAcntBank(detail.getAcntBank());
            wfar.setAcntBankNo(detail.getAcntBankNo());
            wfar.setFixedAccName(detail.getFixedAccName());
            wfar.setFixedAcntBank(detail.getFixedAcntBank());
            wfar.setFixedAcntBankNo(detail.getFixedAcntBankNo());
            wfar.setCurrency(detail.getCurrency());
            wfar.setTranDate(detail.getTranDate());
            wfar.setEndIntDate(detail.getEndIntDate());
            wfar.setEndDate(detail.getEndDate());
            wfar.setRate(detail.getRate());
            wfar.setFixTaxInt(detail.getFixTaxInt());
            wfar.setFixActInt(detail.getFixActInt());
            wfar.setStatus(detail.getStatus());
            wfar.setStatusMsg(detail.getStatusMsg());
            wfar.setBankStatus(detail.getBankStatus());
            wfar.setBankStatusMsg(detail.getBankStatusMsg());
            wfar.setAccBal(detail.getAccBal());
            wfar.setAmount(detail.getAmount());
            wfar.setDetailSeqID(detail.getDetailSeqID());
            lists.add(wfar);
        }
        res.setBody(body);
        return res;
    }

    private List<CurAndFixedInfo> transform(List<WithdrawFromNAccReqDetail> details, CurrentAndFixedExRequest request) {
        ArrayList<CurAndFixedInfo> lists = new ArrayList<CurAndFixedInfo>(1);
        EBHeader header = request.getHeader();
        String bankVersion = header.getBankVersion();
        CurrentAndFixedReqBody body = request.getBody();
        EBContext context = EBContext.getContext();
        for (WithdrawFromNAccReqDetail detail : details) {
            CurAndFixedInfo curAndFixedInfo = new CurAndFixedInfo();
            String accNo = detail.getAccNo();
            String accName = detail.getAccName();
            String acntBank = detail.getAcntBank();
            String fixedAccNo = detail.getFixedAccNo();
            String fixedAccName = detail.getFixedAccName();
            String fixedAcntBank = detail.getFixedAcntBank();
            String amount = detail.getAmount();
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)accNo), (Object)ResManager.loadKDString((String)"\u6d3b\u671f\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CafWithdrawNAccMethod_10", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)accName), (Object)ResManager.loadKDString((String)"\u6d3b\u671f\u8d26\u53f7\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CafWithdrawNAccMethod_11", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)acntBank), (Object)ResManager.loadKDString((String)"\u6d3b\u671f\u8d26\u53f7\u884c\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CafWithdrawNAccMethod_12", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(amount), (Object)ResManager.loadKDString((String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (String)"CafWithdrawNAccMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)CheckUtil.checkNumber(accNo), (Object)String.format(ResManager.loadKDString((String)"\u6d3b\u671f\u8d26\u53f7\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002%s\u3002", (String)"CafWithdrawNAccMethod_13", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo));
            curAndFixedInfo.setAmount(CheckUtil.checkBigDecimal(detail.getAmount(), ResManager.loadKDString((String)"\u8bf7\u6c42\u4e2d\u7684\u91d1\u989d", (String)"CafWithdrawNAccMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0])).toString());
            curAndFixedInfo.setErrorMsg("");
            curAndFixedInfo.setBackErrorMsg("");
            curAndFixedInfo.setBankMsg("");
            curAndFixedInfo.setCustomId(header.getCustomId());
            curAndFixedInfo.setBatchSeqId(body.getBatchSeqId());
            curAndFixedInfo.setDetailBizNo(detail.getDetailBizNo());
            curAndFixedInfo.setDetailSeqId(detail.getDetailSeqID());
            curAndFixedInfo.setAccNo(detail.getAccNo());
            curAndFixedInfo.setAccName(detail.getAccName());
            curAndFixedInfo.setAcntBank(detail.getAcntBank());
            curAndFixedInfo.setAcntBankNo(detail.getAcntBankNo());
            curAndFixedInfo.setFixedAccNo(detail.getFixedAccNo());
            curAndFixedInfo.setFixedAccName(detail.getFixedAccName());
            curAndFixedInfo.setFixedAcntBank(detail.getFixedAcntBank());
            curAndFixedInfo.setFixedAcntBankNo(detail.getFixedAcntBankNo());
            curAndFixedInfo.setCurrency(CurrencyUtils.convert2Bank((String)detail.getCurrency()));
            curAndFixedInfo.setAccBal("");
            if (!StringUtils.isEmpty((String)detail.getNotifyId())) {
                curAndFixedInfo.setNotifyId(detail.getNotifyId());
            }
            curAndFixedInfo.setBackBankStatus("1");
            curAndFixedInfo.setBankVersion("");
            curAndFixedInfo.setBankLoginId(context.getBankLoginID());
            curAndFixedInfo.setSubBizType(header.getSubBizType());
            curAndFixedInfo.setOpenDate("");
            curAndFixedInfo.setCloseDate("");
            curAndFixedInfo.setRateDate("");
            curAndFixedInfo.setEndIntDate("");
            curAndFixedInfo.setEndDate("");
            curAndFixedInfo.setExpireOp("");
            curAndFixedInfo.setRate("");
            curAndFixedInfo.setFixInt("");
            curAndFixedInfo.setFixTaxInt("");
            curAndFixedInfo.setFixActInt("");
            curAndFixedInfo.setCloseInt("");
            curAndFixedInfo.setStatus(Integer.valueOf(7));
            curAndFixedInfo.setStatusMsg(CurAndFixedState.PACKAGED.getCnName());
            curAndFixedInfo.setStatusName(CurAndFixedState.PACKAGED.getEnName());
            curAndFixedInfo.setBankStatus("");
            curAndFixedInfo.setBankStatusMsg("");
            curAndFixedInfo.setTranDate(LocalDateTime.now());
            curAndFixedInfo.setTranTime(LocalDateTime.now());
            curAndFixedInfo.setPriceNo("");
            curAndFixedInfo.setReqNbr(detail.getReqNbr());
            String currency = detail.getCurrency();
            curAndFixedInfo.setCurrency(CurrencyUtils.convert2Bank((String)currency));
            lists.add(curAndFixedInfo);
        }
        return lists;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return null;
    }

    private void checkStructure(CurrentAndFixedExRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CafWithdrawNAccMethod_14", (String)"ebg-aqap-business", (Object[])new Object[0]));
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CafWithdrawNAccMethod_15", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42 body \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CafWithdrawNAccMethod_16", (String)"ebg-aqap-business", (Object[])new Object[0]));
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"CafWithdrawNAccMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CafWithdrawNAccMethod_17", (String)"ebg-aqap-business", (Object[])new Object[0]));
        Preconditions.checkState((!CurAndFixedService.getInstance().batchSeqIDExist(batchSeqID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"batchSeqID \u5df2\u7ecf\u5b58\u5728\u3002", (String)"CafWithdrawNAccMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]));
    }

    private void checkBizNo(CurrentAndFixedExRequest request) {
        List details = request.getBody().getDetails();
        for (WithdrawFromNAccReqDetail detail : details) {
            QFilter filter = QFilter.of((String)"detail_biz_no = ? and back_bank_status = '1'", (Object[])new Object[]{detail.getDetailBizNo()});
            boolean flag = QueryServiceHelper.exists((String)"bank_cafinfo", (QFilter[])filter.toArray());
            if (!flag) continue;
            throw EBExceiptionUtil.duplicateException((String)String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42\u7591\u4f3c\u91cd\u590d\u88ab\u62e6\u622a\uff0c\u5df2\u5b58\u5728\u4e1a\u52a1\u5b8c\u6210\u6216\u5728\u9014\u7684\u4e1a\u52a1\u53f7[%s]\u3002", (String)"CafWithdrawNAccMethod_18", (String)"ebg-aqap-business", (Object[])new Object[0]), detail.getDetailBizNo()));
        }
    }
}

