/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.currentandfixed;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.business.currentandfixed.CurAndFixedBizType;
import kd.ebg.aqap.business.currentandfixed.cache.CacheCafStorage;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.business.currentandfixed.util.CurAndFixedConvert;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurAndFixedReqDetail;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurrentAndFixedRequest;
import kd.ebg.aqap.common.entity.biz.curandfixed.CurrentAndFixedResponse;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.services.CurAndFixedService;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBDuplicateException;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class CurrentAndFixedMethod
implements EBServiceMethod<CurrentAndFixedRequest, CurrentAndFixedResponse> {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CurrentAndFixedMethod.class);

    public CurrentAndFixedRequest mappingCurrency(CurrentAndFixedRequest request) {
        List list = request.getBody().getDetails();
        HashMap currencyMap = new HashMap(16);
        list.stream().forEach(item -> {
            String currency = item.getCurrency();
            currency = MappingCurrencyRepository.getInstance().getISOMappingCurrency(currency, currencyMap);
            item.setCurrency(currency);
        });
        return request;
    }

    public CurrentAndFixedResponse mappingCurrency(CurrentAndFixedResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getDetails();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.stream().forEach(item -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    public CurrentAndFixedResponse executeClientRequest(CurrentAndFixedRequest currentAndFixedRequest, EBContext ebContext) throws MalformedURLException {
        String bankVersionID = ebContext.getBankVersionID();
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        String batchSeqID = "";
        String dbk = "";
        try {
            try {
                this.checkStructure(currentAndFixedRequest);
                batchSeqID = currentAndFixedRequest.getBody().getBatchSeqId();
                this.checkBatchSeqIDUnique(batchSeqID);
                this.checkBizNo(currentAndFixedRequest);
            }
            catch (IllegalArgumentException e) {
                throw EBExceiptionUtil.preCheckException((String)e.getMessage(), (Throwable)e);
            }
            catch (EBDuplicateException e) {
                throw EBExceiptionUtil.duplicateException((String)e.getMessage(), (Throwable)e);
            }
            String bizType = currentAndFixedRequest.getHeader().getSubBizType();
            String code = CurAndFixedBizType.findCodeByName(bizType).getCode();
            BankHeader header = new BankHeader();
            header.setBankVersionID(bankVersionID);
            header.setBankCurrency(currentAndFixedRequest.getHeader().getCurrency());
            CurAndFixedService service = CurAndFixedService.getInstance();
            currentAndFixedRequest.getHeader().setBankVersion(bankVersionID);
            if (!"-1".equalsIgnoreCase(code)) {
                List<CurAndFixedInfo> cafInfos = CurAndFixedConvert.convert(currentAndFixedRequest);
                if ("1".equalsIgnoreCase(code) || "3".equalsIgnoreCase(code)) {
                    CurAndFixedInfo curAndFixedInfo = cafInfos.get(0);
                    String reqNbr = curAndFixedInfo.getReqNbr();
                    Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)reqNbr), (Object)ResManager.loadKDString((String)"\u7f3a\u5931\u6d41\u7a0b\u5b9e\u4f8b\u53f7\u3002", (String)"CurrentAndFixedMethod_12", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    String msg0 = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5173\u8054\u7684%s\u4e1a\u52a1\u51fa\u9519\u3002", (String)"CurrentAndFixedMethod_13", (String)"ebg-aqap-business", (Object[])new Object[0]), "1".equalsIgnoreCase(code) ? ResManager.loadKDString((String)"\u6d3b\u8f6c\u5b9a", (String)"CurrentAndFixedMethod_14", (String)"ebg-aqap-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6d3b\u8f6c\u901a\u77e5", (String)"CurrentAndFixedMethod_15", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    String msg1 = String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5173\u8054\u7684%s\u4e1a\u52a1\u975e\u6210\u529f\u72b6\u6001\u3002", (String)"CurrentAndFixedMethod_16", (String)"ebg-aqap-business", (Object[])new Object[0]), "1".equalsIgnoreCase(code) ? ResManager.loadKDString((String)"\u6d3b\u8f6c\u5b9a", (String)"CurrentAndFixedMethod_14", (String)"ebg-aqap-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6d3b\u8f6c\u901a\u77e5", (String)"CurrentAndFixedMethod_15", (String)"ebg-aqap-business", (Object[])new Object[0]));
                    List byFixedAndCurAccNo = "1".equalsIgnoreCase(code) ? service.findByReqNbr(reqNbr, CurAndFixedBizType.CURRENT_TO_FIXED.getName()) : service.findByReqNbr(reqNbr, CurAndFixedBizType.CURRENT_TO_NOTICE.getName());
                    Preconditions.checkArgument((byFixedAndCurAccNo.size() == 1 ? 1 : 0) != 0, (Object)msg0);
                    CurAndFixedInfo info = (CurAndFixedInfo)byFixedAndCurAccNo.get(0);
                    Preconditions.checkArgument((info.getStatus().intValue() == CurAndFixedState.SUCCESS.getId() ? 1 : 0) != 0, (Object)msg1);
                    curAndFixedInfo.setFixedAccName(info.getFixedAccName());
                    curAndFixedInfo.setFixedAcntBankNo(info.getFixedAcntBankNo());
                }
                CAFUtil.preTreatment(cafInfos, bankVersionID);
                Set<List<CurAndFixedInfo>> set = CAFUtil.packageCaf(cafInfos);
                dbk = currentAndFixedRequest.getHeader().getCustomId() + "_" + batchSeqID;
                if (!CacheCafStorage.checkRepeat(dbk)) {
                    CAFUtil.insertAll(cafInfos);
                    CAFUtil.async(set, (EBRequest)currentAndFixedRequest);
                } else {
                    this.logger.error("\u5f53\u524d\u7406\u8d22\u63a5\u53e3\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u4e1a\u52a1\u6279\u6b21\u53f7\uff1a {}", new Object[]{batchSeqID});
                }
                CurrentAndFixedResponse currentAndFixedResponse = CurAndFixedConvert.convertToResponse(cafInfos, currentAndFixedRequest.getHeader());
                return currentAndFixedResponse;
            }
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u7684subBizType\u6709\u8bef\uff0c\u5e94\u4e3acurrentToFixed\u3001fixedToCurrent\u3001currentToNotice\u3001noticeToCurrent\u4e2d\u7684\u4e00\u79cd\u3002", (String)"CurrentAndFixedMethod_2", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        finally {
            CacheCafStorage.release(dbk);
        }
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "CurrentAndFixed";
    }

    private void checkStructure(CurrentAndFixedRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CurrentAndFixedMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]));
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CurrentAndFixedMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]));
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)ResManager.loadKDString((String)"\u8bf7\u6c42 body \u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CurrentAndFixedMethod_9", (String)"ebg-aqap-business", (Object[])new Object[0]));
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"CurrentAndFixedMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    private void checkBatchSeqIDUnique(String batchSeqID) {
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)ResManager.loadKDString((String)"\u6279\u6b21\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CurrentAndFixedMethod_10", (String)"ebg-aqap-business", (Object[])new Object[0]));
        Preconditions.checkState((!CurAndFixedService.getInstance().batchSeqIDExist(batchSeqID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"batchSeqID \u5df2\u7ecf\u5b58\u5728\u3002", (String)"CurrentAndFixedMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]));
    }

    private void checkBizNo(CurrentAndFixedRequest request) {
        List details = request.getBody().getDetails();
        for (CurAndFixedReqDetail detail : details) {
            QFilter filter = QFilter.of((String)"detail_biz_no = ? and back_bank_status = '1'", (Object[])new Object[]{detail.getDetailBizNo()});
            boolean flag = QueryServiceHelper.exists((String)"bank_cafinfo", (QFilter[])filter.toArray());
            if (!flag) continue;
            throw EBExceiptionUtil.duplicateException((String)String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u8bf7\u6c42\u7591\u4f3c\u91cd\u590d\u88ab\u62e6\u622a\uff0c\u5df2\u5b58\u5728\u4e1a\u52a1\u5b8c\u6210\u6216\u5728\u9014\u7684\u4e1a\u52a1\u53f7[%s]\u3002", (String)"CurrentAndFixedMethod_11", (String)"ebg-aqap-business", (Object[])new Object[0]), detail.getDetailBizNo()));
        }
    }

    private void checkParamExist(String ... param) {
        for (String str : param) {
            Preconditions.checkArgument((!StringUtils.isEmpty((String)str) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u53c2\u6570\u7f3a\u5931", (String)"CurrentAndFixedMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
    }
}

