/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.schedule;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.aqap.business.detail.utils.SecondDetailUtil;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class SecondDetailHandScheduleJob
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SecondDetailHandScheduleJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        MDC.put((String)"schedule", (String)"true");
        MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
        if (!BusinessPropertyConfig.isOpenSecondDetailSwitch()) {
            this.logger.info("\u5f53\u524d\u672a\u5f00\u542f\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053\u529f\u80fd");
            return;
        }
        this.logger.info("\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053\u624b\u52a8\u4efb\u52a1\u5f00\u59cb");
        long start = System.currentTimeMillis();
        boolean isPaymentAllowed = SystemPropertyConfig.NOT_PAYMENT_ALLOW.getCurrentValueAsBoolean();
        if (!isPaymentAllowed) {
            this.logger.info("\u975e\u652f\u4ed8\u901a\u9053\u4e3a\u5173\u95ed\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2");
        } else {
            String startDate = BusinessPropertyConfig.getSecondDetailHandStartDate();
            String endDate = BusinessPropertyConfig.getSecondDetailHandEndDate();
            if (StringUtils.isEmpty((String)startDate)) {
                this.logger.info("\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053\u624b\u52a8\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u5f00\u59cb\u65e5\u671f\u4e3a\u7a7a");
                return;
            }
            if (StringUtils.isEmpty((String)endDate)) {
                this.logger.info("\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053\u624b\u52a8\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a");
                return;
            }
            LocalDate startLocalDate = LocalDate.parse(startDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            LocalDate endLocalDate = LocalDate.parse(endDate, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            if (startLocalDate == null) {
                this.logger.info("\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053\u624b\u52a8\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u5f00\u59cb\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
                return;
            }
            if (endLocalDate == null) {
                this.logger.info("\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053\u624b\u52a8\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e");
                return;
            }
            this.logger.info("\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053\u624b\u52a8\u4efb\u52a1\uff0c\u6267\u884c\u65e5\u671f\u4e3a{}\u81f3{}", new Object[]{startDate, endDate});
            new SecondDetailUtil().init(startLocalDate, endLocalDate);
        }
        long end = System.currentTimeMillis();
        this.logger.info("\u4ea4\u6613\u660e\u7ec6\u7b2c\u4e8c\u901a\u9053\u624b\u52a8\u4efb\u52a1\u7ed3\u675f\uff0c\u8017\u65f6{}\u6beb\u79d2", (Object)(end - start));
    }
}

