/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.ebg.aqap.business.detail.storage.atom.DetailFlag;
import kd.ebg.aqap.business.detail.storage.impl.DetailCache;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.annotation.Autowired;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.string.StringUtils;

@Service
public class DetailSyncService {
    @Autowired
    private DetailCache cache;

    public void recordTodayDetailTimestamp(String customId, String accNo, String date) {
        String key = DetailFlag.getkey(customId, accNo, date);
        this.cache.put("eb_detailSysncPeroid_", key, DetailFlag.getTimeStamp());
    }

    public boolean isExpire(String customId, String accNo, String date, int minutes) {
        String key;
        long syncTime;
        boolean result = true;
        if (minutes > 0 && (syncTime = this.cache.getSyncTime("eb_detailSysncPeroid_", key = DetailFlag.getkey(customId, accNo, date))) > 0L) {
            long now = System.currentTimeMillis();
            result = now - syncTime < 0L || now - syncTime > (long)(minutes * 60 * 1000);
        }
        return result;
    }

    public List<DetailInfo> getPagingDetail(String accNo, String date, int pageNum) {
        String key = this.genDetailPagingKey(accNo, date, pageNum);
        List<DetailInfo> result = this.cache.get("eb_detailPagingCache_", key);
        if (Objects.isNull(result)) {
            result = new ArrayList<DetailInfo>(1);
        }
        return result;
    }

    public List<DetailInfo> getPagingDetail(String accNo, String date, int pageNum, int pageSize) {
        String key = this.genDetailPagingKey(accNo, date, pageNum, pageSize);
        List<DetailInfo> result = this.cache.get("eb_detailPagingCache_", key);
        if (Objects.isNull(result)) {
            result = new ArrayList<DetailInfo>(1);
        }
        return result;
    }

    public List<DetailInfo> getPagingDetail(String accNo, String date, String currency, Integer isKeyRepeat, int pageNum, int pageSize) {
        String key = this.genDetailPagingKey(accNo, date, currency, isKeyRepeat, pageNum, pageSize);
        List<DetailInfo> result = this.cache.get("eb_detailPagingCache_", key);
        if (Objects.isNull(result)) {
            result = new ArrayList<DetailInfo>(1);
        }
        return result;
    }

    public boolean isHavingPagingDetail(String accNo, String date, int pageNum) {
        return this.getPagingDetail(accNo, date, pageNum).size() > 0;
    }

    public boolean isHavingPagingDetail(String accNo, String date, int pageNum, int pageSize) {
        return this.getPagingDetail(accNo, date, pageNum, pageSize).size() > 0;
    }

    public boolean isHavingPagingDetail(String accNo, String date, String currency, Integer isKeyRepeat, int pageNum, int pageSize) {
        return this.getPagingDetail(accNo, date, currency, isKeyRepeat, pageNum, pageSize).size() > 0;
    }

    private String genDetailPagingKey(String accNo, String date, int pageNum) {
        return "eb_todayDetail_" + EBContext.getContext().getCustomID() + "_" + accNo + "_" + date + "_page_" + pageNum;
    }

    private String genDetailPagingKey(String accNo, String date, int pageNum, int pageSize) {
        return "eb_todayDetail_" + EBContext.getContext().getCustomID() + "_" + accNo + "_" + date + "_page_" + pageNum + "_size_" + pageSize;
    }

    private String genDetailPagingKey(String accNo, String date, String currency, Integer isKeyRepeat, int pageNum, int pageSize) {
        String isKeyRepeatStr = "";
        if (isKeyRepeat != null) {
            isKeyRepeatStr = String.valueOf(isKeyRepeat);
        }
        return "eb_todayDetail_" + EBContext.getContext().getCustomID() + "_" + accNo + "_" + date + "_" + currency + "_" + isKeyRepeatStr + "_page_" + pageNum + "_size_" + pageSize;
    }

    public void savePagingDetail(List<DetailInfo> detailInfos, String accNo, String date, String currency, int pageSize, Integer isKeyRepeat) {
        if (isKeyRepeat != null) {
            detailInfos = detailInfos.stream().filter(d -> isKeyRepeat.equals(d.getIsKeyRepeat())).collect(Collectors.toList());
        }
        Map<Integer, List<DetailInfo>> groupedMap = this.getPagedDetail(detailInfos, pageSize);
        for (Map.Entry<Integer, List<DetailInfo>> entry : groupedMap.entrySet()) {
            List<DetailInfo> groupedDetails = entry.getValue();
            String cacheKey = this.genDetailPagingKey(accNo, date, currency, isKeyRepeat, entry.getKey(), pageSize);
            this.cache.remove("eb_detailPagingCache_", cacheKey);
            this.cache.put("eb_detailPagingCache_", cacheKey, groupedDetails);
        }
    }

    public int savePagingTotalNum(String accNo, String date, int totalNum) {
        int result = totalNum;
        String cacheKey = this.genPagingTotalKey(accNo, date);
        String key = "eb_detailPagingCache_" + cacheKey;
        if (CosmicCache.contains((String)key)) {
            return Integer.parseInt(CosmicCache.get((String)key));
        }
        CosmicCache.put((String)key, (String)String.valueOf(result));
        return result;
    }

    public int savePagingTotalNum(String accNo, String date, String currency, int totalNum, Integer isKeyRepeat) {
        int result = totalNum;
        String cacheKey = this.genPagingTotalKey(accNo, date, currency, isKeyRepeat);
        String key = "eb_detailPagingCache_" + cacheKey;
        if (CosmicCache.contains((String)key)) {
            return Integer.parseInt(CosmicCache.get((String)key));
        }
        CosmicCache.put((String)key, (String)String.valueOf(result));
        return result;
    }

    public void removePagingTotalNum(String accNo, String date) {
        String cacheKey = this.genPagingTotalKey(accNo, date);
        CosmicCache.delete((String)("eb_detailPagingCache_" + cacheKey));
    }

    public void removePagingTotalNum(String accNo, String date, String currecny, Integer isKeyRepeat) {
        String cacheKey = this.genPagingTotalKey(accNo, date, currecny, isKeyRepeat);
        CosmicCache.delete((String)("eb_detailPagingCache_" + cacheKey));
    }

    public Integer getPagingTotalNum(String accNo, String date) {
        String cacheKey = this.genPagingTotalKey(accNo, date);
        String totalNum = CosmicCache.get((String)("eb_detailPagingCache_" + cacheKey));
        if (StringUtils.isEmpty((String)totalNum)) {
            return 0;
        }
        return Integer.parseInt(totalNum);
    }

    public Integer getPagingTotalNum(String accNo, String date, String currency, Integer isKeyRepeat) {
        String cacheKey = this.genPagingTotalKey(accNo, date, currency, isKeyRepeat);
        String totalNum = CosmicCache.get((String)("eb_detailPagingCache_" + cacheKey));
        if (StringUtils.isEmpty((String)totalNum)) {
            return 0;
        }
        return Integer.parseInt(totalNum);
    }

    private String genPagingTotalKey(String accNo, String date) {
        return "eb_todayDetail_" + EBContext.getContext().getCustomID() + "_" + accNo + "_" + date + "_" + "totalNum";
    }

    private String genPagingTotalKey(String accNo, String date, String currency, Integer isKeyRepeat) {
        String isKeyRepeatStr = "";
        if (isKeyRepeat != null) {
            isKeyRepeatStr = String.valueOf(isKeyRepeat);
        }
        return "eb_todayDetail_" + EBContext.getContext().getCustomID() + "_" + accNo + "_" + date + "_" + currency + "_" + isKeyRepeatStr + "_" + "totalNum";
    }

    public Map<Integer, List<DetailInfo>> getPagedDetail(List<DetailInfo> detailInfos, int pageSize) {
        HashMap<Integer, List<DetailInfo>> groupedMap = new HashMap<Integer, List<DetailInfo>>(16);
        int pageNum = 1;
        int count = 0;
        ArrayList<DetailInfo> temp = new ArrayList<DetailInfo>(1);
        for (DetailInfo info : detailInfos) {
            if (count < pageSize) {
                temp.add(info);
            } else {
                groupedMap.put(pageNum, temp);
                temp = new ArrayList(1);
                temp.add(info);
                count = 0;
                ++pageNum;
            }
            ++count;
        }
        if (!temp.isEmpty()) {
            groupedMap.put(pageNum, temp);
        }
        return groupedMap;
    }
}

